/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.annotations.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.annotations.XYShapeAnnotation;

public class XYShapeAnnotationTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(XYShapeAnnotationTests.class);
    }

    public XYShapeAnnotationTests(String name) {
        super(name);
    }

    public void testEquals() {
        XYShapeAnnotation a1 = new XYShapeAnnotation(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), new BasicStroke(1.2f), Color.red, Color.blue);
        XYShapeAnnotation a2 = new XYShapeAnnotation(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), new BasicStroke(1.2f), Color.red, Color.blue);
        XYShapeAnnotationTests.assertTrue((boolean)a1.equals(a2));
        XYShapeAnnotationTests.assertTrue((boolean)a2.equals(a1));
        a1 = new XYShapeAnnotation(new Rectangle2D.Double(4.0, 3.0, 2.0, 1.0), new BasicStroke(1.2f), Color.red, Color.blue);
        XYShapeAnnotationTests.assertFalse((boolean)a1.equals(a2));
        a2 = new XYShapeAnnotation(new Rectangle2D.Double(4.0, 3.0, 2.0, 1.0), new BasicStroke(1.2f), Color.red, Color.blue);
        XYShapeAnnotationTests.assertTrue((boolean)a1.equals(a2));
        a1 = new XYShapeAnnotation(new Rectangle2D.Double(4.0, 3.0, 2.0, 1.0), new BasicStroke(2.3f), Color.red, Color.blue);
        XYShapeAnnotationTests.assertFalse((boolean)a1.equals(a2));
        a2 = new XYShapeAnnotation(new Rectangle2D.Double(4.0, 3.0, 2.0, 1.0), new BasicStroke(2.3f), Color.red, Color.blue);
        XYShapeAnnotationTests.assertTrue((boolean)a1.equals(a2));
        a1 = new XYShapeAnnotation(new Rectangle2D.Double(4.0, 3.0, 2.0, 1.0), new BasicStroke(2.3f), Color.green, Color.blue);
        XYShapeAnnotationTests.assertFalse((boolean)a1.equals(a2));
        a2 = new XYShapeAnnotation(new Rectangle2D.Double(4.0, 3.0, 2.0, 1.0), new BasicStroke(2.3f), Color.green, Color.blue);
        XYShapeAnnotationTests.assertTrue((boolean)a1.equals(a2));
        a1 = new XYShapeAnnotation(new Rectangle2D.Double(4.0, 3.0, 2.0, 1.0), new BasicStroke(2.3f), Color.green, Color.yellow);
        XYShapeAnnotationTests.assertFalse((boolean)a1.equals(a2));
        a2 = new XYShapeAnnotation(new Rectangle2D.Double(4.0, 3.0, 2.0, 1.0), new BasicStroke(2.3f), Color.green, Color.yellow);
        XYShapeAnnotationTests.assertTrue((boolean)a1.equals(a2));
    }

    public void testHashCode() {
        XYShapeAnnotation a1 = new XYShapeAnnotation(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), new BasicStroke(1.2f), Color.red, Color.blue);
        XYShapeAnnotation a2 = new XYShapeAnnotation(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), new BasicStroke(1.2f), Color.red, Color.blue);
        XYShapeAnnotationTests.assertTrue((boolean)a1.equals(a2));
        int h1 = a1.hashCode();
        int h2 = a2.hashCode();
        XYShapeAnnotationTests.assertEquals((int)h1, (int)h2);
    }

    public void testCloning() {
        XYShapeAnnotation a1 = new XYShapeAnnotation(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), new BasicStroke(1.2f), Color.red, Color.blue);
        XYShapeAnnotation a2 = null;
        try {
            a2 = (XYShapeAnnotation)a1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        XYShapeAnnotationTests.assertTrue((a1 != a2 ? 1 : 0) != 0);
        XYShapeAnnotationTests.assertTrue((a1.getClass() == a2.getClass() ? 1 : 0) != 0);
        XYShapeAnnotationTests.assertTrue((boolean)a1.equals(a2));
    }

    public void testSerialization() {
        XYShapeAnnotation a1 = new XYShapeAnnotation(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), new BasicStroke(1.2f), Color.red, Color.blue);
        XYShapeAnnotation a2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(a1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            a2 = (XYShapeAnnotation)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        XYShapeAnnotationTests.assertEquals((Object)a1, a2);
    }
}

