/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.annotations.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.annotations.XYBoxAnnotation;

public class XYBoxAnnotationTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(XYBoxAnnotationTests.class);
    }

    public XYBoxAnnotationTests(String name) {
        super(name);
    }

    public void testEquals() {
        XYBoxAnnotation a1 = new XYBoxAnnotation(1.0, 2.0, 3.0, 4.0, new BasicStroke(1.2f), Color.red, Color.blue);
        XYBoxAnnotation a2 = new XYBoxAnnotation(1.0, 2.0, 3.0, 4.0, new BasicStroke(1.2f), Color.red, Color.blue);
        XYBoxAnnotationTests.assertTrue((boolean)a1.equals(a2));
        XYBoxAnnotationTests.assertTrue((boolean)a2.equals(a1));
        a1 = new XYBoxAnnotation(2.0, 2.0, 3.0, 4.0, new BasicStroke(1.2f), Color.red, Color.blue);
        XYBoxAnnotationTests.assertFalse((boolean)a1.equals(a2));
        a2 = new XYBoxAnnotation(2.0, 2.0, 3.0, 4.0, new BasicStroke(1.2f), Color.red, Color.blue);
        XYBoxAnnotationTests.assertTrue((boolean)a1.equals(a2));
        a1 = new XYBoxAnnotation(1.0, 2.0, 3.0, 4.0, new BasicStroke(2.3f), Color.red, Color.blue);
        XYBoxAnnotationTests.assertFalse((boolean)a1.equals(a2));
        a2 = new XYBoxAnnotation(1.0, 2.0, 3.0, 4.0, new BasicStroke(2.3f), Color.red, Color.blue);
        XYBoxAnnotationTests.assertTrue((boolean)a1.equals(a2));
        a1 = new XYBoxAnnotation(1.0, 2.0, 3.0, 4.0, new BasicStroke(2.3f), Color.green, Color.blue);
        XYBoxAnnotationTests.assertFalse((boolean)a1.equals(a2));
        a2 = new XYBoxAnnotation(1.0, 2.0, 3.0, 4.0, new BasicStroke(2.3f), Color.green, Color.blue);
        XYBoxAnnotationTests.assertTrue((boolean)a1.equals(a2));
        a1 = new XYBoxAnnotation(1.0, 2.0, 3.0, 4.0, new BasicStroke(2.3f), Color.green, Color.yellow);
        XYBoxAnnotationTests.assertFalse((boolean)a1.equals(a2));
        a2 = new XYBoxAnnotation(1.0, 2.0, 3.0, 4.0, new BasicStroke(2.3f), Color.green, Color.yellow);
        XYBoxAnnotationTests.assertTrue((boolean)a1.equals(a2));
    }

    public void testHashCode() {
        XYBoxAnnotation a1 = new XYBoxAnnotation(1.0, 2.0, 3.0, 4.0, new BasicStroke(1.2f), Color.red, Color.blue);
        XYBoxAnnotation a2 = new XYBoxAnnotation(1.0, 2.0, 3.0, 4.0, new BasicStroke(1.2f), Color.red, Color.blue);
        XYBoxAnnotationTests.assertTrue((boolean)a1.equals(a2));
        int h1 = a1.hashCode();
        int h2 = a2.hashCode();
        XYBoxAnnotationTests.assertEquals((int)h1, (int)h2);
    }

    public void testCloning() {
        XYBoxAnnotation a1 = new XYBoxAnnotation(1.0, 2.0, 3.0, 4.0, new BasicStroke(1.2f), Color.red, Color.blue);
        XYBoxAnnotation a2 = null;
        try {
            a2 = (XYBoxAnnotation)a1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        XYBoxAnnotationTests.assertTrue((a1 != a2 ? 1 : 0) != 0);
        XYBoxAnnotationTests.assertTrue((a1.getClass() == a2.getClass() ? 1 : 0) != 0);
        XYBoxAnnotationTests.assertTrue((boolean)a1.equals(a2));
    }

    public void testSerialization() {
        XYBoxAnnotation a1 = new XYBoxAnnotation(1.0, 2.0, 3.0, 4.0, new BasicStroke(1.2f), Color.red, Color.blue);
        XYBoxAnnotation a2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(a1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            a2 = (XYBoxAnnotation)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        XYBoxAnnotationTests.assertEquals((Object)a1, a2);
    }
}

