/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.annotations.junit;

import java.awt.Color;
import java.awt.Font;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.annotations.CategoryTextAnnotation;
import org.jfree.chart.annotations.TextAnnotation;
import org.jfree.ui.TextAnchor;

public class TextAnnotationTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(TextAnnotationTests.class);
    }

    public TextAnnotationTests(String name) {
        super(name);
    }

    public void testEquals() {
        CategoryTextAnnotation a1 = new CategoryTextAnnotation("Test", (Comparable)((Object)"Category"), 1.0);
        CategoryTextAnnotation a2 = new CategoryTextAnnotation("Test", (Comparable)((Object)"Category"), 1.0);
        TextAnnotationTests.assertTrue((boolean)((TextAnnotation)a1).equals(a2));
        a1.setText("Text");
        TextAnnotationTests.assertFalse((boolean)((TextAnnotation)a1).equals(a2));
        a2.setText("Text");
        TextAnnotationTests.assertTrue((boolean)((TextAnnotation)a1).equals(a2));
        a1.setFont(new Font("Serif", 1, 18));
        TextAnnotationTests.assertFalse((boolean)((TextAnnotation)a1).equals(a2));
        a2.setFont(new Font("Serif", 1, 18));
        TextAnnotationTests.assertTrue((boolean)((TextAnnotation)a1).equals(a2));
        a1.setPaint(Color.red);
        TextAnnotationTests.assertFalse((boolean)((TextAnnotation)a1).equals(a2));
        a2.setPaint(Color.red);
        TextAnnotationTests.assertTrue((boolean)((TextAnnotation)a1).equals(a2));
        a1.setTextAnchor(TextAnchor.BOTTOM_LEFT);
        TextAnnotationTests.assertFalse((boolean)((TextAnnotation)a1).equals(a2));
        a2.setTextAnchor(TextAnchor.BOTTOM_LEFT);
        TextAnnotationTests.assertTrue((boolean)((TextAnnotation)a1).equals(a2));
        a1.setRotationAnchor(TextAnchor.BOTTOM_LEFT);
        TextAnnotationTests.assertFalse((boolean)((TextAnnotation)a1).equals(a2));
        a2.setRotationAnchor(TextAnchor.BOTTOM_LEFT);
        TextAnnotationTests.assertTrue((boolean)((TextAnnotation)a1).equals(a2));
        a1.setRotationAngle(Math.PI);
        TextAnnotationTests.assertFalse((boolean)((TextAnnotation)a1).equals(a2));
        a2.setRotationAngle(Math.PI);
        TextAnnotationTests.assertTrue((boolean)((TextAnnotation)a1).equals(a2));
    }

    public void testHashCode() {
        CategoryTextAnnotation a1 = new CategoryTextAnnotation("Test", (Comparable)((Object)"Category"), 1.0);
        CategoryTextAnnotation a2 = new CategoryTextAnnotation("Test", (Comparable)((Object)"Category"), 1.0);
        TextAnnotationTests.assertTrue((boolean)((TextAnnotation)a1).equals(a2));
        int h1 = a1.hashCode();
        int h2 = a2.hashCode();
        TextAnnotationTests.assertEquals((int)h1, (int)h2);
    }
}

