/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.jexcel.samples.demo;

import com.jniwrapper.util.Logger;
import com.jniwrapper.win32.gdi.Icon;
import com.jniwrapper.win32.jexcel.ExcelException;
import com.jniwrapper.win32.jexcel.Range;
import com.jniwrapper.win32.jexcel.WorkbookEventAdapter;
import com.jniwrapper.win32.jexcel.WorkbookEventListener;
import com.jniwrapper.win32.jexcel.WorkbookEventObject;
import com.jniwrapper.win32.jexcel.Worksheet;
import com.jniwrapper.win32.jexcel.WorksheetEventListener;
import com.jniwrapper.win32.jexcel.WorksheetEventObject;
import com.jniwrapper.win32.jexcel.samples.demo.AboutDialog;
import com.jniwrapper.win32.jexcel.samples.demo.AutomationPanel;
import com.jniwrapper.win32.jexcel.samples.demo.TitledPane;
import com.jniwrapper.win32.jexcel.ui.JWorkbook;
import com.jniwrapper.win32.jexcel.ui.JWorkbookEventAdapter;
import com.jniwrapper.win32.jexcel.ui.JWorkbookEventListener;
import com.jniwrapper.win32.jexcel.ui.JWorkbookEventObject;
import com.jniwrapper.win32.jexcel.ui.JWorkbookInterruptException;
import com.jniwrapper.win32.ui.MessageBox;
import com.jniwrapper.win32.ui.Wnd;
import com.jniwrapper.win32.ui.dialogs.OpenSaveFileDialog;
import com.sun.java.swing.plaf.windows.WindowsMenuBarUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.MenuBarUI;

public class JExcelDemo
extends JFrame {
    private static final Logger LOG = Logger.getInstance((Class)(class$com$jniwrapper$win32$jexcel$samples$demo$JExcelDemo == null ? (class$com$jniwrapper$win32$jexcel$samples$demo$JExcelDemo = JExcelDemo.class$("com.jniwrapper.win32.jexcel.samples.demo.JExcelDemo")) : class$com$jniwrapper$win32$jexcel$samples$demo$JExcelDemo));
    private static final String FILTER = "Excel Workbooks (*.xls) | *.xls";
    private JWorkbook _workbook;
    private JMenuBar _menuBar;
    private JTextArea _eventLog;
    private AutomationBarAction _automationBarAction;
    private EventLogAction _eventLogAction;
    private StaticViewAction _staticViewAction;
    private TitledPane _eventLogPane;
    private TitledPane _automationBarPane;
    private JSplitPane _splitPane;
    private JSplitPane _subSplitPane;
    private WorksheetEventLogger _worksheetEventLogger;
    private WorkbookEventLogger _workbookEventLogger;
    private JScrollPane _eventLogScrollPane;
    private AutomationPanel _automationPanel;
    private JMenuItem _miSaveAs;
    private JMenuItem _miPrintPreview;
    private JMenuItem _miPrint;
    private JMenuItem _miNew;
    private JMenuItem _miOpen;
    private JCheckBoxMenuItem _miStaticView;
    static /* synthetic */ Class class$com$jniwrapper$win32$jexcel$samples$demo$JExcelDemo;

    public JExcelDemo() throws ExcelException {
        super("JExcel Demo");
        this.setSize(900, 700);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
        this.getContentPane().setLayout(new BorderLayout());
        this._worksheetEventLogger = new WorksheetEventLogger();
        this._workbookEventLogger = new WorkbookEventLogger();
        this._workbook = new JWorkbook();
        if (!this._workbook.isWorkbookCreated()) {
            throw new IllegalStateException("Failed to obtain a workbook");
        }
        List worksheets = this._workbook.getWorksheets();
        for (int i = 0; i < worksheets.size(); ++i) {
            Worksheet worksheet = (Worksheet)worksheets.get(i);
            worksheet.addWorksheetEventListener((WorksheetEventListener)this._worksheetEventLogger);
        }
        this._workbook.addWorkbookEventListener((WorkbookEventListener)this._workbookEventLogger);
        this._workbook.addJWorkbookEventListener((JWorkbookEventListener)new JWorkbookListener());
        this._workbook.setMinimumSize(new Dimension(200, 200));
        this._eventLogAction = new EventLogAction();
        this._automationBarAction = new AutomationBarAction();
        this._staticViewAction = new StaticViewAction();
        this._eventLog = new JTextArea();
        this._eventLog.setFont(new Font("Courier New", 0, 11));
        this._eventLog.setEditable(false);
        this._eventLog.setBorder(null);
        this._eventLogScrollPane = new JScrollPane(this._eventLog);
        this._eventLogScrollPane.setBorder(null);
        JPanel logPanel = new JPanel(new BorderLayout());
        logPanel.add((Component)this._eventLogScrollPane, "Center");
        logPanel.setMinimumSize(new Dimension(200, 80));
        this._automationPanel = new AutomationPanel(this._workbook);
        this._automationPanel.setMinimumSize(new Dimension(244, 473));
        this._automationPanel.setMaximumSize(new Dimension(244, 0));
        this._automationBarPane = new TitledPane("Automation Bar", this._automationPanel, null, this._automationBarAction);
        this._subSplitPane = new JSplitPane(1, true);
        this._subSplitPane.setLeftComponent((Component)this._workbook);
        this._subSplitPane.setRightComponent(this._automationBarPane);
        this._subSplitPane.setBorder(null);
        this._subSplitPane.setDividerSize(2);
        this._subSplitPane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                JExcelDemo.this._subSplitPane.setDividerLocation(JExcelDemo.this._subSplitPane.getWidth() - 246);
            }
        });
        this._subSplitPane.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                JExcelDemo.this._subSplitPane.setDividerLocation(JExcelDemo.this._subSplitPane.getWidth() - 246);
            }
        });
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new JMenuItem(new AbstractAction("Clear"){

            public void actionPerformed(ActionEvent e) {
                JExcelDemo.this._eventLog.setText("");
            }
        }));
        this._eventLogPane = new TitledPane("Event Log", logPanel, popupMenu, this._eventLogAction);
        this._splitPane = new JSplitPane(0, true);
        this._splitPane.setTopComponent(this._subSplitPane);
        this._splitPane.setBottomComponent(this._eventLogPane);
        this._splitPane.setBorder(null);
        this._splitPane.setDividerSize(2);
        this._splitPane.setResizeWeight(0.8);
        this.getContentPane().add((Component)this._splitPane, "Center");
        this._menuBar = this.createMenuTree();
        this.updateRecentFiles();
        this.setJMenuBar(this._menuBar);
        this._automationPanel.updateRecentFiles();
    }

    private void enableMenuItems() {
        this._miPrint.setEnabled(true);
        this._miPrintPreview.setEnabled(true);
        this._miSaveAs.setEnabled(true);
        this._miStaticView.setEnabled(true);
    }

    private void printLog(String s) {
        this._eventLog.append(s + '\n');
        this._eventLogScrollPane.getVerticalScrollBar().setValue(this._eventLogScrollPane.getVerticalScrollBar().getMaximum());
        this._eventLogScrollPane.repaint();
    }

    private JMenuBar createMenuTree() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.setUI((MenuBarUI)new WindowsMenuBarUI());
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        this._miNew = new JMenuItem(new AbstractAction("New..."){

            public void actionPerformed(ActionEvent e) {
                JExcelDemo.this._workbook.newWorkbook();
            }
        });
        this._miNew.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this._miOpen = new JMenuItem(new AbstractAction("Open..."){

            public void actionPerformed(ActionEvent e) {
                OpenSaveFileDialog dialog = new OpenSaveFileDialog((Window)JExcelDemo.this);
                dialog.setFilter(JExcelDemo.FILTER);
                if (dialog.getOpenFileName()) {
                    try {
                        JExcelDemo.this._workbook.openWorkbook(new File(dialog.getFileName()));
                    }
                    catch (FileNotFoundException e1) {
                        JOptionPane.showMessageDialog(SwingUtilities.windowForComponent(JExcelDemo.this), "Cannot find file " + dialog.getFileName() + ".", "File not found", 0);
                    }
                }
            }
        });
        this._miOpen.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        JMenuItem miClose = new JMenuItem(new AbstractAction("Close"){

            public void actionPerformed(ActionEvent e) {
                JExcelDemo.this._workbook.close();
            }
        });
        this._miSaveAs = new JMenuItem(new AbstractAction("Save As..."){

            public void actionPerformed(ActionEvent e) {
                OpenSaveFileDialog dialog = new OpenSaveFileDialog((Window)JExcelDemo.this);
                dialog.setFilter(JExcelDemo.FILTER);
                if (dialog.getSaveFileName()) {
                    try {
                        JExcelDemo.this._workbook.saveCopyAs(new File(dialog.getFileName()));
                    }
                    catch (IOException el) {
                        JOptionPane.showMessageDialog(JExcelDemo.this, "Unable to save the workbook to the specified file.", "JExcel Demo", 0);
                    }
                }
            }
        });
        this._miPrintPreview = new JMenuItem(new AbstractAction("Print Preview"){

            public void actionPerformed(ActionEvent e) {
                JExcelDemo.this._workbook.setPrintPreview(true);
            }
        });
        this._miPrint = new JMenuItem(new AbstractAction("Print..."){

            public void actionPerformed(ActionEvent e) {
                JExcelDemo.this._workbook.showPrintDialog();
            }
        });
        this._miPrint.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        JMenuItem miExit = new JMenuItem(new AbstractAction("Exit"){

            public void actionPerformed(ActionEvent e) {
                JExcelDemo.this.processWindowEvent(new WindowEvent(JExcelDemo.this, 201));
            }
        });
        fileMenu.add(this._miNew);
        fileMenu.add(this._miOpen);
        fileMenu.add(miClose);
        fileMenu.addSeparator();
        fileMenu.add(this._miSaveAs);
        fileMenu.addSeparator();
        fileMenu.add(this._miPrintPreview);
        fileMenu.add(this._miPrint);
        fileMenu.addSeparator();
        fileMenu.addSeparator();
        fileMenu.add(miExit);
        fileMenu.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    JExcelDemo.this.updateRecentFiles();
                }
            }
        });
        JMenu viewMenu = new JMenu("View");
        viewMenu.setMnemonic(86);
        JCheckBoxMenuItem miShowAutomationBar = new JCheckBoxMenuItem(this._automationBarAction);
        this._automationBarAction.setMenuItem(miShowAutomationBar);
        miShowAutomationBar.setSelected(true);
        JCheckBoxMenuItem miShowEventLog = new JCheckBoxMenuItem(this._eventLogAction);
        this._eventLogAction.setMenuItem(miShowEventLog);
        miShowEventLog.setSelected(true);
        this._miStaticView = new JCheckBoxMenuItem(this._staticViewAction);
        this._staticViewAction.setMenuItem(this._miStaticView);
        viewMenu.add(miShowAutomationBar);
        viewMenu.add(miShowEventLog);
        viewMenu.addSeparator();
        viewMenu.add(this._miStaticView);
        JMenu helpMenu = new JMenu("Help");
        JMenuItem about = new JMenuItem(new ShowAboutAction(this));
        helpMenu.add(about);
        menuBar.add(fileMenu);
        menuBar.add(viewMenu);
        menuBar.add(helpMenu);
        return menuBar;
    }

    private void updateRecentFiles() {
        List files;
        try {
            files = this._workbook.getApplication().getRecentFiles();
        }
        catch (Exception e) {
            return;
        }
        if (!this._workbook.isWorkbookCreated()) {
            return;
        }
        JMenu fileMenu = this._menuBar.getMenu(0);
        while (fileMenu.getItemCount() > 11) {
            fileMenu.remove(9);
        }
        int max_length = 40;
        for (int i = 0; i < files.size(); ++i) {
            int pos;
            final File file = (File)files.get(i);
            String path = file.getAbsolutePath();
            if (path.length() > 40 && (pos = path.lastIndexOf(92)) != -1 && 40 - path.length() + pos > 0) {
                String subPath = path.substring(0, 40 - path.length() + pos);
                path = path.substring(0, subPath.lastIndexOf(92) + 1) + "..." + path.substring(pos, path.length());
            }
            JMenuItem recentFile = new JMenuItem(new AbstractAction(path){

                public void actionPerformed(ActionEvent e) {
                    try {
                        JExcelDemo.this._workbook.openWorkbook(file);
                    }
                    catch (FileNotFoundException ex) {
                        JOptionPane.showMessageDialog(SwingUtilities.windowForComponent(JExcelDemo.this), "Cannot find file " + file.getAbsolutePath() + ".", "File not found", 0);
                    }
                }
            });
            fileMenu.insert(recentFile, 9 + i);
        }
    }

    private static void setupFrameIcon(Window owner) {
        try {
            Wnd winWnd = new Wnd((Component)owner);
            Icon bigIcon = new Icon((class$com$jniwrapper$win32$jexcel$samples$demo$JExcelDemo == null ? (class$com$jniwrapper$win32$jexcel$samples$demo$JExcelDemo = JExcelDemo.class$("com.jniwrapper.win32.jexcel.samples.demo.JExcelDemo")) : class$com$jniwrapper$win32$jexcel$samples$demo$JExcelDemo).getResourceAsStream("res/jexcel.ico"), new Dimension(32, 32));
            Icon smallIcon = new Icon((class$com$jniwrapper$win32$jexcel$samples$demo$JExcelDemo == null ? (class$com$jniwrapper$win32$jexcel$samples$demo$JExcelDemo = JExcelDemo.class$("com.jniwrapper.win32.jexcel.samples.demo.JExcelDemo")) : class$com$jniwrapper$win32$jexcel$samples$demo$JExcelDemo).getResourceAsStream("res/jexcel.ico"), new Dimension(16, 16));
            winWnd.setWindowIcon(smallIcon, Icon.IconType.SMALL);
            winWnd.setWindowIcon(bigIcon, Icon.IconType.BIG);
        }
        catch (Exception e) {
            LOG.error((Object)"", (Throwable)e);
        }
    }

    private static void setupLF() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            UIDefaults defaults = UIManager.getDefaults();
            Font tahoma = new Font("Tahoma", 0, 11);
            defaults.put("MenuItem.font", tahoma);
            defaults.put("TabbedPane.font", tahoma);
            defaults.put("TextField.font", tahoma);
            defaults.put("Label.font", tahoma);
            defaults.put("Button.font", tahoma);
            defaults.put("ComboBox.font", tahoma);
            defaults.put("Panel.font", tahoma);
        }
        catch (Exception e) {
            LOG.error((Object)"", (Throwable)e);
        }
    }

    public static void main(String[] args) throws ExcelException {
        final JExcelDemo excelDemo = new JExcelDemo();
        excelDemo.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                JExcelDemo.setupFrameIcon(excelDemo);
            }
        });
        excelDemo.setExtendedState(6);
        excelDemo.setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        JExcelDemo.setupLF();
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        JFrame.setDefaultLookAndFeelDecorated(true);
    }

    class WorkbookEventLogger
    extends WorkbookEventAdapter {
        WorkbookEventLogger() {
        }

        public void newSheet(WorkbookEventObject eventObject) {
            Worksheet worksheet = eventObject.getWorksheet();
            JExcelDemo.this.printLog("\"" + worksheet.getName() + "\" sheet is added to \"" + eventObject.getWorkbook().getWorkbookName() + "\" workbook.");
            worksheet.addWorksheetEventListener((WorksheetEventListener)JExcelDemo.this._worksheetEventLogger);
        }
    }

    class WorksheetEventLogger
    implements WorksheetEventListener {
        WorksheetEventLogger() {
        }

        public void activated(WorksheetEventObject eventObject) {
            JExcelDemo.this.printLog(eventObject.getWorksheet().getName() + " activated.");
        }

        public void beforeDoubleClick(WorksheetEventObject eventObject) {
            JExcelDemo.this.printLog("Double click on " + eventObject.getCell().getAddress() + ".");
        }

        public void beforeRightClick(WorksheetEventObject eventObject) {
            JExcelDemo.this.printLog("Right click on " + eventObject.getRange().getAddress() + ".");
        }

        public void changed(WorksheetEventObject eventObject) {
            JExcelDemo.this.printLog(eventObject.getRange().getAddress() + " is changed.");
        }

        public void deactivated(WorksheetEventObject eventObject) {
            JExcelDemo.this.printLog(eventObject.getWorksheet().getName() + " deactivated.");
        }

        public void selectionChanged(WorksheetEventObject eventObject) {
            Range range = eventObject.getRange();
            JExcelDemo.this._automationPanel.setSelection(range);
            JExcelDemo.this.printLog(range.getAddress() + " selected.");
        }
    }

    class ShowAboutAction
    extends AbstractAction {
        Window _owner;

        ShowAboutAction(Window owner) {
            super("About JExcel");
            this._owner = owner;
        }

        public void actionPerformed(ActionEvent e) {
            AboutDialog aboutDialog = new AboutDialog((Frame)this._owner, "About JExcel Demo", "<html><H2>JExcel Demo</H2><H3></H3>Copyright \u00a9 2000-2006 TeamDev Ltd.", new ImageIcon(this.getClass().getResource("res/logo.jpg")));
            aboutDialog.setVisible(true);
        }
    }

    class StaticViewAction
    extends AbstractAction {
        private boolean _selected = false;
        private JCheckBoxMenuItem _menuItem;

        public StaticViewAction() {
            super("Static view");
        }

        public void setMenuItem(JCheckBoxMenuItem menuItem) {
            this._menuItem = menuItem;
        }

        public void actionPerformed(ActionEvent e) {
            this._selected = !this._selected;
            this._menuItem.setSelected(this._selected);
            JExcelDemo.this._workbook.setStaticMode(this._selected);
            this.enableMenuItems();
        }

        public void setSelected(boolean value) {
            this._selected = value;
            this._menuItem.setSelected(value);
            this.enableMenuItems();
        }

        private void enableMenuItems() {
            JExcelDemo.this._miPrint.setEnabled(!this._selected);
            JExcelDemo.this._miPrintPreview.setEnabled(!this._selected);
            JExcelDemo.this._miSaveAs.setEnabled(!this._selected);
            JExcelDemo.this._miNew.setEnabled(!this._selected);
            JExcelDemo.this._miOpen.setEnabled(!this._selected);
        }
    }

    class AutomationBarAction
    extends AbstractAction {
        private boolean _selected = true;
        private JCheckBoxMenuItem _menuItem;

        public AutomationBarAction() {
            super("Show Automation Bar");
        }

        public void setMenuItem(JCheckBoxMenuItem menuItem) {
            this._menuItem = menuItem;
        }

        public void actionPerformed(ActionEvent e) {
            this._selected = !this._selected;
            JExcelDemo.this._automationBarPane.setVisible(this._selected);
            if (this._selected) {
                JExcelDemo.this._subSplitPane.setDividerLocation(JExcelDemo.this._subSplitPane.getWidth() - 246);
            }
            this._menuItem.setSelected(this._selected);
        }
    }

    class EventLogAction
    extends AbstractAction {
        private boolean _selected = true;
        private JCheckBoxMenuItem _menuItem;

        public EventLogAction() {
            super("Show Event Log");
        }

        public void setMenuItem(JCheckBoxMenuItem menuItem) {
            this._menuItem = menuItem;
        }

        public void actionPerformed(ActionEvent e) {
            this._selected = !this._selected;
            JExcelDemo.this._eventLogPane.setVisible(this._selected);
            if (this._selected) {
                JExcelDemo.this._splitPane.setDividerLocation(0.8);
            }
            this._menuItem.setSelected(this._selected);
        }
    }

    private class JWorkbookListener
    extends JWorkbookEventAdapter {
        private JWorkbookListener() {
        }

        public void newWorkbook(JWorkbookEventObject eventObject) {
            JExcelDemo.this._staticViewAction.setSelected(false);
            List worksheets = JExcelDemo.this._workbook.getWorksheets();
            for (int i = 0; i < worksheets.size(); ++i) {
                Worksheet worksheet = (Worksheet)worksheets.get(i);
                worksheet.addWorksheetEventListener((WorksheetEventListener)JExcelDemo.this._worksheetEventLogger);
            }
            JExcelDemo.this._workbook.addWorkbookEventListener((WorkbookEventListener)JExcelDemo.this._workbookEventLogger);
            JExcelDemo.this.printLog("New workbook: " + eventObject.getWorkbook().getWorkbookName() + ".");
            JExcelDemo.this._automationPanel.updateRecentFiles();
            JExcelDemo.this.enableMenuItems();
        }

        public void workbookOpened(JWorkbookEventObject eventObject) {
            JExcelDemo.this._staticViewAction.setSelected(false);
            List worksheets = JExcelDemo.this._workbook.getWorksheets();
            for (int i = 0; i < worksheets.size(); ++i) {
                Worksheet worksheet = (Worksheet)worksheets.get(i);
                worksheet.addWorksheetEventListener((WorksheetEventListener)JExcelDemo.this._worksheetEventLogger);
            }
            JExcelDemo.this._workbook.addWorkbookEventListener((WorkbookEventListener)JExcelDemo.this._workbookEventLogger);
            JExcelDemo.this.printLog("Opened workbook: " + eventObject.getWorkbook().getWorkbookName() + ".");
            JExcelDemo.this._automationPanel.updateRecentFiles();
            JExcelDemo.this.enableMenuItems();
        }

        public void beforeWorkbookClose(JWorkbookEventObject eventObject) throws JWorkbookInterruptException {
            block8: {
                if (!JExcelDemo.this._workbook.isSaved()) {
                    int msgBoxresult = MessageBox.show((Wnd)new Wnd((Component)JExcelDemo.this._workbook), (String)"Excel confirmation", (String)("Do you want to save changes you made to '" + JExcelDemo.this._workbook.getWorkbookName() + "'"), (int)3);
                    if (msgBoxresult == 6) {
                        Window parent = SwingUtilities.getWindowAncestor((Component)JExcelDemo.this._workbook);
                        OpenSaveFileDialog saveDialog = new OpenSaveFileDialog(parent);
                        saveDialog.setFilter(JExcelDemo.FILTER);
                        boolean result = saveDialog.getSaveFileName();
                        if (result) {
                            String newFileName = saveDialog.getFileName();
                            File newFile = new File(newFileName);
                            try {
                                if (JExcelDemo.this._workbook.saveCopyAs(newFile).getValue() != 0L) {
                                    throw new JWorkbookInterruptException("Workbook closing canceled by user");
                                }
                                break block8;
                            }
                            catch (IOException e) {
                                throw new JWorkbookInterruptException("Input/Output error", (Throwable)e);
                            }
                        }
                        throw new JWorkbookInterruptException("Workbook closing canceled by user");
                    }
                    if (msgBoxresult == 2) {
                        throw new JWorkbookInterruptException("Workbook closing canceled by user");
                    }
                }
            }
            List worksheets = JExcelDemo.this._workbook.getWorksheets();
            for (int i = 0; i < worksheets.size(); ++i) {
                Worksheet worksheet = (Worksheet)worksheets.get(i);
                worksheet.removeWorksheetEventListener((WorksheetEventListener)JExcelDemo.this._worksheetEventLogger);
            }
            JExcelDemo.this._workbook.removeWorkbookEventListener((WorkbookEventListener)JExcelDemo.this._workbookEventLogger);
            JExcelDemo.this.printLog("Workbook \"" + eventObject.getWorkbook().getWorkbookName() + "\" closed.");
            JExcelDemo.this._staticViewAction.setSelected(false);
            JExcelDemo.this._miPrint.setEnabled(false);
            JExcelDemo.this._miPrintPreview.setEnabled(false);
            JExcelDemo.this._miSaveAs.setEnabled(false);
            JExcelDemo.this._miStaticView.setEnabled(false);
            JExcelDemo.this._automationPanel.setSelection(null);
        }

        public void printPreviewStateChanged(JWorkbookEventObject eventObject) {
            boolean isPrintPreview = eventObject.getJWorkbook().isPrintPreview();
            if (isPrintPreview) {
                JExcelDemo.this.printLog("Workbook \"" + eventObject.getWorkbook().getWorkbookName() + "\" is in the print preview mode.");
            } else {
                JExcelDemo.this.printLog("The print preview mode is closed.");
            }
            JMenu fileMenu = JExcelDemo.this._menuBar.getMenu(0);
            for (int i = 0; i < fileMenu.getItemCount() - 1; ++i) {
                if (fileMenu.getItem(i) == null) continue;
                fileMenu.getItem(i).setEnabled(!isPrintPreview);
            }
            fileMenu = JExcelDemo.this._menuBar.getMenu(1);
            fileMenu.getItem(3).setEnabled(!isPrintPreview);
        }
    }
}

