/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.system;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.Parameter;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt32;
import com.jniwrapper.util.EnumItem;
import com.jniwrapper.util.FlagSet;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.system.HookFunction;
import com.jniwrapper.win32.ui.User32;

public class WinEventHook {
    private static final String FUNCTION_SET_WIN_EVENT_HOOK = "SetWinEventHook";
    private static final String FUNCTION_UNHOOK_WIN_EVENT = "UnhookWinEvent";

    public static int setWinEventHook(WinEvent eventMin, WinEvent eventMax, Handle dllModule, HookFunction function, int processID, int threadID, WinEventFlag eventFlag) {
        Function func = User32.getInstance().getFunction(FUNCTION_SET_WIN_EVENT_HOOK);
        UInt32 result = new UInt32();
        func.invoke((Parameter)result, new Parameter[]{new UInt32((long)eventMin.getValue()), new UInt32((long)eventMax.getValue()), dllModule, function, new UInt32((long)processID), new UInt32((long)threadID), new UInt(eventFlag.getFlags())});
        return (int)result.getValue();
    }

    public static boolean unhookWinEvent(int hookID) {
        Function func = User32.getInstance().getFunction(FUNCTION_UNHOOK_WIN_EVENT);
        Bool result = new Bool();
        func.invoke((Parameter)result, (Parameter)new UInt32((long)hookID));
        return result.getValue();
    }

    public static class WinEvent
    extends EnumItem {
        public static final WinEvent EVENT_MIN = new WinEvent(1);
        public static final WinEvent EVENT_MAX = new WinEvent(Integer.MAX_VALUE);
        public static final WinEvent EVENT_SYSTEM_SOUND = new WinEvent(1);
        public static final WinEvent EVENT_SYSTEM_ALERT = new WinEvent(2);
        public static final WinEvent EVENT_SYSTEM_FOREGROUND = new WinEvent(3);
        public static final WinEvent EVENT_SYSTEM_MENUSTART = new WinEvent(4);
        public static final WinEvent EVENT_SYSTEM_MENUEND = new WinEvent(5);
        public static final WinEvent EVENT_SYSTEM_MENUPOPUPSTART = new WinEvent(6);
        public static final WinEvent EVENT_SYSTEM_MENUPOPUPEND = new WinEvent(7);
        public static final WinEvent EVENT_SYSTEM_CAPTURESTART = new WinEvent(8);
        public static final WinEvent EVENT_SYSTEM_CAPTUREEND = new WinEvent(9);
        public static final WinEvent EVENT_SYSTEM_MOVESIZESTART = new WinEvent(10);
        public static final WinEvent EVENT_SYSTEM_MOVESIZEEND = new WinEvent(11);
        public static final WinEvent EVENT_SYSTEM_CONTEXTHELPSTART = new WinEvent(12);
        public static final WinEvent EVENT_SYSTEM_CONTEXTHELPEND = new WinEvent(13);
        public static final WinEvent EVENT_SYSTEM_DRAGDROPSTART = new WinEvent(14);
        public static final WinEvent EVENT_SYSTEM_DRAGDROPEND = new WinEvent(15);
        public static final WinEvent EVENT_SYSTEM_DIALOGSTART = new WinEvent(16);
        public static final WinEvent EVENT_SYSTEM_DIALOGEND = new WinEvent(17);
        public static final WinEvent EVENT_SYSTEM_SCROLLINGSTART = new WinEvent(18);
        public static final WinEvent EVENT_SYSTEM_SCROLLINGEND = new WinEvent(19);
        public static final WinEvent EVENT_SYSTEM_SWITCHSTART = new WinEvent(20);
        public static final WinEvent EVENT_SYSTEM_SWITCHEND = new WinEvent(21);
        public static final WinEvent EVENT_SYSTEM_MINIMIZESTART = new WinEvent(22);
        public static final WinEvent EVENT_SYSTEM_MINIMIZEEND = new WinEvent(23);
        public static final WinEvent EVENT_OBJECT_CREATE = new WinEvent(32768);
        public static final WinEvent EVENT_OBJECT_DESTROY = new WinEvent(32769);
        public static final WinEvent EVENT_OBJECT_SHOW = new WinEvent(32770);
        public static final WinEvent EVENT_OBJECT_HIDE = new WinEvent(32771);
        public static final WinEvent EVENT_OBJECT_REORDER = new WinEvent(32772);
        public static final WinEvent EVENT_OBJECT_FOCUS = new WinEvent(32773);
        public static final WinEvent EVENT_OBJECT_SELECTION = new WinEvent(32774);
        public static final WinEvent EVENT_OBJECT_SELECTIONADD = new WinEvent(32775);
        public static final WinEvent EVENT_OBJECT_SELECTIONREMOVE = new WinEvent(32776);
        public static final WinEvent EVENT_OBJECT_SELECTIONWITHIN = new WinEvent(32777);
        public static final WinEvent EVENT_OBJECT_STATECHANGE = new WinEvent(32778);
        public static final WinEvent EVENT_OBJECT_LOCATIONCHANGE = new WinEvent(32779);
        public static final WinEvent EVENT_OBJECT_NAMECHANGE = new WinEvent(32780);
        public static final WinEvent EVENT_OBJECT_DESCRIPTIONCHANGE = new WinEvent(32781);
        public static final WinEvent EVENT_OBJECT_VALUECHANGE = new WinEvent(32782);
        public static final WinEvent EVENT_OBJECT_PARENTCHANGE = new WinEvent(32783);
        public static final WinEvent EVENT_OBJECT_HELPCHANGE = new WinEvent(32784);
        public static final WinEvent EVENT_OBJECT_DEFACTIONCHANGE = new WinEvent(32785);
        public static final WinEvent EVENT_OBJECT_ACCELERATORCHANGE = new WinEvent(32786);

        WinEvent(int value) {
            super(value);
        }
    }

    public static class WinEventFlag
    extends FlagSet {
        private static final long WINEVENT_INCONTEXT = 4L;
        private static final long WINEVENT_OUTOFCONTEXT = 0L;
        private static final long WINEVENT_SKIPOWNPROCESS = 2L;
        private static final long WINEVENT_SKIPOWNTHREAD = 1L;

        public WinEventFlag() {
        }

        public WinEventFlag(long flags) {
            super(flags);
        }

        public void setInContext(boolean value) {
            this.setupFlag(4L, value);
        }

        public boolean getInContext() {
            return this.contains(4L);
        }

        public void setOutOfContext(boolean value) {
            this.setupFlag(0L, value);
        }

        public boolean getOutOfContext() {
            return this.contains(0L);
        }

        public void setskipOwnProcess(boolean value) {
            this.setupFlag(2L, value);
        }

        public boolean getSkipOwnProcess() {
            return this.contains(2L);
        }

        public void setSkipOwnThread(boolean value) {
            this.setupFlag(1L, value);
        }

        public boolean getSkipOwnThread() {
            return this.contains(1L);
        }
    }
}

