/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.system;

import com.jniwrapper.Function;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.Structure;
import com.jniwrapper.UInt16;
import com.jniwrapper.win32.system.Kernel32;

public class SystemTime
extends Structure {
    private static final String FUNCTION_GetSystemTime = "GetSystemTime";
    private static final String FUNCTION_SetSystemTime = "SetSystemTime";
    private UInt16 wYear = new UInt16();
    private UInt16 wMonth = new UInt16();
    private UInt16 wDayOfWeek = new UInt16();
    private UInt16 wDay = new UInt16();
    private UInt16 wHour = new UInt16();
    private UInt16 wMinute = new UInt16();
    private UInt16 wSecond = new UInt16();
    private UInt16 wMilliseconds = new UInt16();

    public SystemTime() {
        this.init(new Parameter[]{this.wYear, this.wMonth, this.wDayOfWeek, this.wDay, this.wHour, this.wMinute, this.wSecond, this.wMilliseconds});
    }

    public SystemTime(SystemTime that) {
        super((Structure)that);
    }

    public int getYear() {
        return (int)this.wYear.getValue();
    }

    public void setYear(int value) {
        this.wYear.setValue((long)value);
    }

    public int getMonth() {
        return (int)this.wMonth.getValue();
    }

    public void setMonth(int value) {
        this.wMonth.setValue((long)value);
    }

    public int getDayOfWeek() {
        return (int)this.wDayOfWeek.getValue();
    }

    public void setDayOfWeek(int value) {
        this.wDayOfWeek.setValue((long)value);
    }

    public int getDay() {
        return (int)this.wDay.getValue();
    }

    public void setDay(int value) {
        this.wDay.setValue((long)value);
    }

    public int getHour() {
        return (int)this.wHour.getValue();
    }

    public void setHour(int value) {
        this.wHour.setValue((long)value);
    }

    public int getMinute() {
        return (int)this.wMinute.getValue();
    }

    public void setMinute(int value) {
        this.wMinute.setValue((long)value);
    }

    public int getSecond() {
        return (int)this.wSecond.getValue();
    }

    public void setSecond(int value) {
        this.wSecond.setValue((long)value);
    }

    public int getMilliseconds() {
        return (int)this.wMilliseconds.getValue();
    }

    public void setMilliseconds(int value) {
        this.wMilliseconds.setValue((long)value);
    }

    public Object clone() {
        return new SystemTime(this);
    }

    public static SystemTime getCurrent() {
        Function getSystemTime = Kernel32.getInstance().getFunction(FUNCTION_GetSystemTime);
        SystemTime result = new SystemTime();
        getSystemTime.invoke(null, (Parameter)new Pointer((Parameter)result));
        return result;
    }

    public static void setSystemTime(SystemTime value) {
        Function setSystemTime = Kernel32.getInstance().getFunction(FUNCTION_SetSystemTime);
        setSystemTime.invoke(null, (Parameter)new Pointer((Parameter)value));
    }

    public String toString() {
        StringBuffer result = new StringBuffer("SystemTime: [").append("Year=").append(this.getYear()).append(", Month=").append(this.getMonth()).append(", DayOfWeek=").append(this.getDayOfWeek()).append(", Day=").append(this.getDay()).append(", Hour=").append(this.getHour()).append(", Minute=").append(this.getMinute()).append(", Second=").append(this.getSecond()).append(", Milliseconds=").append(this.getMilliseconds()).append("]");
        return result.toString();
    }

    public static void main(String[] args) {
        SystemTime current = SystemTime.getCurrent();
        System.out.println("current = " + (Object)((Object)current));
    }
}

