/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.security;

import com.jniwrapper.Bool;
import com.jniwrapper.ComplexArray;
import com.jniwrapper.Function;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.Str;
import com.jniwrapper.Structure;
import com.jniwrapper.UInt32;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.security.Luid;
import com.jniwrapper.win32.security.LuidAndAttributes;
import com.jniwrapper.win32.system.AdvApi32;

public class TokenPrivileges
extends Structure {
    private UInt32 _privilegeCount = new UInt32();
    private ComplexArray _privileges = new ComplexArray((Parameter)new LuidAndAttributes(), 1);

    public TokenPrivileges() {
        this.init(new Parameter[]{this._privilegeCount, this._privileges});
    }

    private TokenPrivileges(TokenPrivileges other) {
        this._privilegeCount = (UInt32)other._privilegeCount.clone();
        this._privileges = (ComplexArray)other._privileges.clone();
        this.init(new Parameter[]{this._privilegeCount, this._privileges});
    }

    public int getPrivilegeCount() {
        return (int)this._privilegeCount.getValue();
    }

    public void setPrivilegeCount(int privilegeCount) {
        this._privilegeCount.setValue((long)privilegeCount);
    }

    public LuidAndAttributes getPrivileges(int index) {
        return (LuidAndAttributes)this._privileges.getElement(index);
    }

    public Object clone() {
        return new TokenPrivileges(this);
    }

    public static TokenPrivileges lookup(String name) {
        TokenPrivileges tokenPrivileges = new TokenPrivileges();
        if (TokenPrivileges.lookupPrivilegeValue(name, tokenPrivileges.getPrivileges(0).getLuid())) {
            return tokenPrivileges;
        }
        return null;
    }

    private static boolean lookupPrivilegeValue(String name, Luid luid) {
        Function function = AdvApi32.getInstance().getFunction(new FunctionName("LookupPrivilegeValue").toString());
        Bool bool = new Bool();
        function.invoke((Parameter)bool, new Parameter[]{new Handle(), new Str(name), new Pointer((Parameter)luid)});
        return bool.getValue();
    }
}

