/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.security;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.UInt32;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.process.CurrentProcess;
import com.jniwrapper.win32.security.TokenPrivileges;
import com.jniwrapper.win32.system.AdvApi32;

public class AccessToken
extends Handle {
    private static final int TOKEN_ADJUST_PRIVILEGES = 32;
    private static final int TOKEN_QUERY = 8;
    private static final int SE_PRIVILEGE_ENABLED = 2;
    private static final String FUNCTION_OPEN_PROCESS_TOKEN = "OpenProcessToken";
    private static final String FUNCTION_ADJUST_TOKEN_PRIVILEGES = "AdjustTokenPrivileges";

    public AccessToken() {
        AccessToken.openProcessToken(new CurrentProcess(), 40, this);
    }

    private static void openProcessToken(Handle processHandle, int desiredAcces, Handle resultToken) {
        Function function = AdvApi32.getInstance().getFunction(FUNCTION_OPEN_PROCESS_TOKEN);
        Bool returnValue = new Bool();
        function.invoke((Parameter)returnValue, new Parameter[]{processHandle, new UInt32((long)desiredAcces), new Pointer((Parameter)resultToken)});
    }

    public boolean enablePrivelege(String name) {
        TokenPrivileges tokenPrivileges = TokenPrivileges.lookup(name);
        if (tokenPrivileges != null) {
            tokenPrivileges.setPrivilegeCount(1);
            tokenPrivileges.getPrivileges(0).setAttributes(2);
            return this.adjustTokenPrivileges(tokenPrivileges);
        }
        return false;
    }

    private boolean adjustTokenPrivileges(TokenPrivileges newState) {
        Function function = AdvApi32.getInstance().getFunction(FUNCTION_ADJUST_TOKEN_PRIVILEGES);
        Bool returnValue = new Bool();
        long lastError = function.invoke((Parameter)returnValue, new Parameter[]{this, new Int(0L), new Pointer((Parameter)newState), new UInt32(0L), new Handle(), new Pointer((Parameter)new UInt32())});
        return returnValue.getValue() && lastError == 0L;
    }
}

