/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.registry;

import com.jniwrapper.Char;
import com.jniwrapper.IntegerParameter;
import com.jniwrapper.Parameter;
import com.jniwrapper.PrimitiveArray;
import com.jniwrapper.Str;
import com.jniwrapper.StringParameter;
import com.jniwrapper.UInt32;
import com.jniwrapper.UInt8;
import com.jniwrapper.WideChar;
import com.jniwrapper.win32.system.Kernel32;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public interface RegistryValueTransformer {
    public static final RegistryValueTransformer STRING_TRANSFORMER = new RegistryValueTransformer(){

        /*
         * WARNING - void declaration
         */
        public Parameter toRegistryValue(Object value) {
            void var2_2;
            Str result;
            if (value instanceof String) {
                result = new Str((String)value);
            } else if (value instanceof StringParameter) {
                result = (Parameter)value;
            } else {
                throw new IllegalArgumentException("Not a string parameter");
            }
            return var2_2;
        }

        public Object fromRegistryValue(Parameter value) {
            return ((StringParameter)value).getValue();
        }

        public Parameter createRegistryValueParameter(int size) {
            return new Str("", size);
        }

        public boolean isTypeSupported(Object value) {
            return value instanceof String || value instanceof StringParameter;
        }
    };
    public static final RegistryValueTransformer INTEGER_TRANSFORMER = new RegistryValueTransformer(){

        /*
         * WARNING - void declaration
         */
        public Parameter toRegistryValue(Object value) {
            void var2_2;
            Parameter result;
            if (value instanceof Number) {
                result = new UInt32(((Number)value).longValue());
            } else if (value instanceof IntegerParameter) {
                result = (Parameter)value;
            } else {
                throw new IllegalArgumentException("Not an integer parameter");
            }
            return var2_2;
        }

        public Object fromRegistryValue(Parameter value) {
            UInt32 parameter = (UInt32)value;
            return new Long(parameter.getValue());
        }

        public Parameter createRegistryValueParameter(int size) {
            return new UInt32();
        }

        public boolean isTypeSupported(Object value) {
            return value instanceof Number || value instanceof IntegerParameter;
        }
    };
    public static final RegistryValueTransformer MULTISTRING_TRANSFORMER = new RegistryValueTransformer(){

        /*
         * WARNING - void declaration
         */
        public Parameter toRegistryValue(Object value) {
            void var2_2;
            Collection<String> strings;
            if (value instanceof String[]) {
                strings = Arrays.asList((String[])value);
            } else if (value instanceof Collection) {
                strings = (Collection)value;
            } else {
                throw new IllegalArgumentException("Not a string collection");
            }
            StringBuffer chars = new StringBuffer();
            Iterator i = var2_2.iterator();
            while (i.hasNext()) {
                chars.append(i.next()).append('\u0000');
            }
            chars.append('\u0000');
            boolean unicode = Kernel32.getInstance().isUnicode();
            int length = chars.length();
            PrimitiveArray array = (PrimitiveArray)this.createRegistryValueParameter(length);
            for (int i2 = 0; i2 < chars.length(); ++i2) {
                char s = chars.charAt(i2);
                WideChar c = unicode ? new WideChar(s) : new Char(s);
                array.setElement(i2, (Parameter)c);
            }
            return array;
        }

        public Object fromRegistryValue(Parameter value) {
            ArrayList<String> strings = new ArrayList<String>();
            PrimitiveArray charArray = (PrimitiveArray)value;
            StringBuffer string = new StringBuffer();
            boolean unicode = Kernel32.getInstance().isUnicode();
            int elementCount = charArray.getElementCount();
            for (int i = 0; i < elementCount; ++i) {
                char c;
                Parameter element = charArray.getElement(i);
                char c2 = c = unicode ? ((WideChar)element).getValue() : ((Char)element).getValue();
                if (c == '\u0000') {
                    if (string.length() == 0) break;
                    strings.add(string.toString());
                    string = new StringBuffer();
                    continue;
                }
                string.append(c);
            }
            return strings;
        }

        public Parameter createRegistryValueParameter(int size) {
            boolean unicode = Kernel32.getInstance().isUnicode();
            Class clazz = unicode ? (5.class$com$jniwrapper$WideChar == null ? (5.class$com$jniwrapper$WideChar = 5.class$("com.jniwrapper.WideChar")) : 5.class$com$jniwrapper$WideChar) : (5.class$com$jniwrapper$Char == null ? (5.class$com$jniwrapper$Char = 5.class$("com.jniwrapper.Char")) : 5.class$com$jniwrapper$Char);
            return new PrimitiveArray(clazz, size);
        }

        public boolean isTypeSupported(Object value) {
            return value instanceof String[] || value instanceof Collection;
        }
    };
    public static final RegistryValueTransformer BINARY_TRANSFORMER = new RegistryValueTransformer(){

        public Parameter toRegistryValue(Object value) {
            Parameter result = null;
            if (value instanceof byte[]) {
                byte[] bytes = (byte[])value;
                PrimitiveArray byteArray = (PrimitiveArray)this.createRegistryValueParameter(bytes.length);
                for (int i = 0; i < bytes.length; ++i) {
                    byteArray.setElement(i, (Parameter)new UInt8((short)bytes[i]));
                }
                result = byteArray;
            } else if (value instanceof PrimitiveArray) {
                result = (Parameter)value;
            } else {
                throw new IllegalArgumentException("Not a byte array parameter");
            }
            return result;
        }

        public Object fromRegistryValue(Parameter value) {
            PrimitiveArray array = (PrimitiveArray)value;
            byte[] bytes = array.getBytes();
            return bytes;
        }

        public Parameter createRegistryValueParameter(int size) {
            return new PrimitiveArray(5.class$com$jniwrapper$UInt8 == null ? (5.class$com$jniwrapper$UInt8 = 5.class$("com.jniwrapper.UInt8")) : 5.class$com$jniwrapper$UInt8, size);
        }

        public boolean isTypeSupported(Object value) {
            return value instanceof byte[] || value instanceof PrimitiveArray;
        }
    };

    public Parameter toRegistryValue(Object var1);

    public Object fromRegistryValue(Parameter var1);

    public Parameter createRegistryValueParameter(int var1);

    public boolean isTypeSupported(Object var1);

    static class 5 {
        static /* synthetic */ Class class$com$jniwrapper$WideChar;
        static /* synthetic */ Class class$com$jniwrapper$Char;
        static /* synthetic */ Class class$com$jniwrapper$UInt8;

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

