/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.registry;

import com.jniwrapper.win32.registry.RegistryKey;

public class BrowserPaths {
    private static final String REG_IEXPLORE_COMMAND = "Applications\\iexplore.exe\\shell\\open\\command";
    private static final String REG_FIREFOX_COMMAND = "Applications\\FIREFOX.EXE\\shell\\open\\command";
    private static final String PARAM_DEF_IE = "%1";
    private static final String PARAM_DEF_FIREFOX = "-url";

    private BrowserPaths() {
    }

    public static String getDefaultBrowserCommand() {
        RegistryKey rkey = RegistryKey.CLASSES_ROOT.openSubKey("http\\shell\\open\\command");
        return rkey.values().get("").toString();
    }

    static String getIExploreCommand() {
        RegistryKey rkey = RegistryKey.CLASSES_ROOT.openSubKey(REG_IEXPLORE_COMMAND);
        return rkey.values().get("").toString();
    }

    static String getFirefoxCommand() {
        if (RegistryKey.CLASSES_ROOT.exists(REG_FIREFOX_COMMAND)) {
            RegistryKey rkey = RegistryKey.CLASSES_ROOT.openSubKey(REG_FIREFOX_COMMAND);
            return rkey.values().get("").toString();
        }
        return null;
    }

    public static String getDefaultBrowserPath() {
        String defaultBrowserCommand = BrowserPaths.getDefaultBrowserCommand();
        if (defaultBrowserCommand.indexOf("iexplore") != -1) {
            return BrowserPaths.getExecutablePath(defaultBrowserCommand, PARAM_DEF_IE);
        }
        if (defaultBrowserCommand.toLowerCase().indexOf("firefox") != -1) {
            return BrowserPaths.getExecutablePath(defaultBrowserCommand, PARAM_DEF_FIREFOX);
        }
        return BrowserPaths.getExecutablePath(defaultBrowserCommand, PARAM_DEF_IE);
    }

    public static String getIExplorePath() {
        return BrowserPaths.getExecutablePath(BrowserPaths.getIExploreCommand(), PARAM_DEF_IE);
    }

    public static String getFirefoxPath() {
        String firefoxCommand = BrowserPaths.getFirefoxCommand();
        if (firefoxCommand != null) {
            return BrowserPaths.getExecutablePath(firefoxCommand, PARAM_DEF_FIREFOX);
        }
        return null;
    }

    private static String getExecutablePath(String command, String paramDef) {
        int paramPos = command.lastIndexOf(paramDef);
        if (paramPos == -1) {
            return command;
        }
        String exePath = command.substring(0, paramPos - 1);
        return exePath;
    }

    public static void main(String[] args) {
        System.out.println("Default browser command: " + BrowserPaths.getDefaultBrowserCommand());
        System.out.println("Default browser file: " + BrowserPaths.getDefaultBrowserPath());
        System.out.println("IExplore.exe file: " + BrowserPaths.getIExplorePath());
        System.out.println("FireFox.exe file: " + BrowserPaths.getFirefoxPath());
    }
}

