/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.gdi;

import com.jniwrapper.UInt32;
import java.awt.Color;

public class ColorRef
extends UInt32 {
    static final int CLR_INVALID = -1;

    public ColorRef() {
    }

    public ColorRef(long value) {
        super(value);
    }

    public ColorRef(Color color) {
        this.setColor(color);
    }

    public void setColor(Color color) {
        int rgb = color.getRGB();
        this.setValue(ColorRef.toBGR(rgb));
    }

    public Color toColor() {
        return ColorRef.fromNativeColor((int)this.getValue());
    }

    public static int toBGR(int rgb) {
        int r = (rgb & 0xFF0000) >> 16;
        int g = rgb & 0xFF00;
        int b = rgb & 0xFF;
        int result = r | g | b << 16;
        return result;
    }

    public static int toRGB(int bgr) {
        int b = (bgr & 0xFF0000) >> 16;
        int g = bgr & 0xFF00;
        int r = bgr & 0xFF;
        int result = b | g | r << 16;
        return result;
    }

    public static int toNativeColor(Color color) {
        return ColorRef.toBGR(color.getRGB());
    }

    public static Color fromNativeColor(int color) {
        return new Color(ColorRef.toRGB(color));
    }

    public boolean isInvalid() {
        long value = this.getValue();
        return value == -1L;
    }
}

