/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.samples.demo.operations;

import com.jniwrapper.Int32;
import com.jniwrapper.LongInt;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.ULongInt;
import com.jniwrapper.util.Logger;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.PageRange;
import com.jniwrapper.win32.automation.OleContainer;
import com.jniwrapper.win32.automation.OleMessageLoop;
import com.jniwrapper.win32.automation.PrintHandler;
import com.jniwrapper.win32.automation.PrinterDeviceInfo;
import com.jniwrapper.win32.automation.types.VariantBool;
import com.jniwrapper.win32.com.ComException;
import com.jniwrapper.win32.com.ComFunctions;
import com.jniwrapper.win32.com.IClassFactory;
import com.jniwrapper.win32.com.IUnknown;
import com.jniwrapper.win32.com.server.CoClassMetaInfo;
import com.jniwrapper.win32.com.server.IClassFactoryServer;
import com.jniwrapper.win32.com.server.IUnknownServer;
import com.jniwrapper.win32.com.server.IUnknownVTBL;
import com.jniwrapper.win32.gdi.PrintParameters;
import com.jniwrapper.win32.ole.IPreviewCallback;
import com.jniwrapper.win32.ole.PageSet;
import com.jniwrapper.win32.ole.impl.IInPlacePrintPreviewImpl;
import com.jniwrapper.win32.ole.impl.IPreviewCallbackImpl;
import com.jniwrapper.win32.ole.impl.IPrintImpl;
import com.jniwrapper.win32.ole.server.IPreviewCallbackVTBL;
import com.jniwrapper.win32.ui.dialogs.PrintDialog;
import java.awt.Container;
import java.awt.Window;

public class OfficePrintHandler
implements PrintHandler {
    private static final Logger LOG = Logger.getInstance((Class)(class$com$jniwrapper$win32$samples$demo$operations$OfficePrintHandler == null ? (class$com$jniwrapper$win32$samples$demo$operations$OfficePrintHandler = OfficePrintHandler.class$("com.jniwrapper.win32.samples.demo.operations.OfficePrintHandler")) : class$com$jniwrapper$win32$samples$demo$operations$OfficePrintHandler));
    private static IClassFactoryServer PREVIEW_CALLBACK_CLASS_FACTORY_SERVER;
    private static final IClassFactory PREVIEW_CALLBACK_FACTORY;
    private static final int NOTIFY_FINISHED = 1;
    private static final int NOTIFY_FORCECLOSEPREVIEW = 32;
    private static final int NOTIFY_UNABLETOPREVIEW = 128;
    private static final int PRINTFLAG_RECOMPOSETODEVICE = 8;
    private OleContainer _oleContainer;
    private boolean _inPrintPreview;
    static /* synthetic */ Class class$com$jniwrapper$win32$samples$demo$operations$OfficePrintHandler;
    static /* synthetic */ Class class$com$jniwrapper$win32$samples$demo$operations$OfficePrintHandler$PreviewCallback;
    static /* synthetic */ Class class$com$jniwrapper$win32$ole$IPreviewCallback;

    private static IClassFactory createPreviewCallbackFactory() {
        PREVIEW_CALLBACK_CLASS_FACTORY_SERVER = new IClassFactoryServer(class$com$jniwrapper$win32$samples$demo$operations$OfficePrintHandler$PreviewCallback == null ? (class$com$jniwrapper$win32$samples$demo$operations$OfficePrintHandler$PreviewCallback = OfficePrintHandler.class$("com.jniwrapper.win32.samples.demo.operations.OfficePrintHandler$PreviewCallback")) : class$com$jniwrapper$win32$samples$demo$operations$OfficePrintHandler$PreviewCallback);
        PREVIEW_CALLBACK_CLASS_FACTORY_SERVER.registerInterface(class$com$jniwrapper$win32$ole$IPreviewCallback == null ? (class$com$jniwrapper$win32$ole$IPreviewCallback = OfficePrintHandler.class$("com.jniwrapper.win32.ole.IPreviewCallback")) : class$com$jniwrapper$win32$ole$IPreviewCallback, (IUnknownVTBL)new IPreviewCallbackVTBL((CoClassMetaInfo)PREVIEW_CALLBACK_CLASS_FACTORY_SERVER));
        PREVIEW_CALLBACK_CLASS_FACTORY_SERVER.setDefaultInterface(class$com$jniwrapper$win32$ole$IPreviewCallback == null ? (class$com$jniwrapper$win32$ole$IPreviewCallback = OfficePrintHandler.class$("com.jniwrapper.win32.ole.IPreviewCallback")) : class$com$jniwrapper$win32$ole$IPreviewCallback);
        return PREVIEW_CALLBACK_CLASS_FACTORY_SERVER.createIClassFactory();
    }

    public void setContainer(OleContainer container) {
        this._oleContainer = container;
    }

    public void print() {
        this.print(1, 1, 1);
    }

    public void print(int startPage, int endPage, int numPages) {
        PrintParameters printParameters = PrintParameters.create((int)startPage, (int)endPage, (int)numPages);
        this.print(printParameters);
    }

    public void print(final PrintParameters printParameters) {
        try {
            final PrinterDeviceInfo deviceInfo = this.getPrintInfo(this.getParentWindow(), printParameters);
            Runnable runnable = new Runnable(){

                public void run() {
                    IPrintImpl print = new IPrintImpl();
                    print.setAutoDelete(false);
                    OfficePrintHandler.this._oleContainer.getOleObject().queryInterface(print.getIID(), (IUnknown)print);
                    if (deviceInfo != null) {
                        Handle lpTargetDevice = deviceInfo.createPrintDevice();
                        Handle pageSet = OfficePrintHandler.this.createPageSet(printParameters);
                        OfficePrintHandler.this.doPrint(lpTargetDevice, pageSet, print);
                    }
                    print.release();
                }
            };
            try {
                OleMessageLoop.invokeMethod((Object)runnable, (String)"run");
            }
            catch (Exception e) {
                LOG.error((Object)"", (Throwable)e);
            }
        }
        catch (ComException e) {
            LOG.error((Object)"Can't print office document.", (Throwable)e);
        }
    }

    private PrinterDeviceInfo getPrintInfo(Window printDialogOwner, PrintParameters printParameters) {
        PrinterDeviceInfo result = new PrinterDeviceInfo();
        PrintDialog printDialog = new PrintDialog(printDialogOwner);
        printDialog.setCopies(printParameters.getNumCopies());
        printDialog.setMinPage(printParameters.getMinPage());
        printDialog.setMaxPage(printParameters.getMaxPage());
        printDialog.setFromPage(printParameters.getFromPage());
        printDialog.setToPage(printParameters.getToPage());
        if (printDialog.open()) {
            result.setDevNames(printDialog.getDevNames());
            result.setDevMode(printDialog.getDevMode());
            result.setNumCopies((long)printDialog.getCopies());
            return result;
        }
        return null;
    }

    private Handle createPageSet(PrintParameters printParameters) {
        PageSet pageSet = new PageSet();
        Pointer.Void lpPageSet = ComFunctions.coTaskMemAlloc((ULongInt)new ULongInt((long)pageSet.getLength()));
        Pointer ptrPageSet = new Pointer((Parameter)pageSet);
        lpPageSet.castTo(ptrPageSet);
        pageSet.setOddPages(printParameters.isPrintOddPages());
        pageSet.setEvenPages(printParameters.isPrintEvenPages());
        pageSet.setPageRange((long)printParameters.getPageRanges().length);
        for (int i = 0; i < printParameters.getPageRanges().length; ++i) {
            PageRange pageRange = printParameters.getPageRanges()[i];
            PageRange pageRangeForPageSet = (PageRange)pageSet.getPages().getElement(i);
            pageRangeForPageSet.setFromPage(pageRange.getFromPage());
            pageRangeForPageSet.setToPage((long)pageRange.getToPage());
        }
        return new Handle(lpPageSet.getValue());
    }

    private void doPrint(Handle lpTargetDevice, Handle lpPageSet, IPrintImpl print) {
        int pagesPrinted = 0;
        int lastPage = 0;
        print.setInitialPageNum(new LongInt(1L));
        print.print(new Int32(8), lpTargetDevice, lpPageSet, null, null, new Int32(1), new Int32(pagesPrinted), new Int32(lastPage));
    }

    public void printPreview() {
        Runnable runnable = new Runnable(){

            public void run() {
                IInPlacePrintPreviewImpl preview = new IInPlacePrintPreviewImpl();
                preview.setAutoDelete(false);
                OfficePrintHandler.this._oleContainer.getOleObject().queryInterface(preview.getIID(), (IUnknown)preview);
                preview.queryStatus();
                IPreviewCallbackImpl previewCallback = new IPreviewCallbackImpl();
                previewCallback.setAutoDelete(false);
                PREVIEW_CALLBACK_FACTORY.createInstance(null, previewCallback.getIID(), (IUnknown)previewCallback);
                PreviewCallback previewCallbackInstance = (PreviewCallback)((Object)PREVIEW_CALLBACK_CLASS_FACTORY_SERVER.getInstances().pop());
                previewCallbackInstance.setPrintHandler(OfficePrintHandler.this);
                preview.startPrintPreview(new Int32(1), null, (IPreviewCallback)previewCallback, new Int32(1));
                OfficePrintHandler.this._inPrintPreview = true;
                previewCallback.release();
                preview.release();
            }
        };
        try {
            OleMessageLoop.invokeMethod((Object)runnable, (String)"run");
        }
        catch (Exception e) {
            LOG.error((Object)"", (Throwable)e);
        }
    }

    public void closePrintPreview() {
        Runnable runnable = new Runnable(){

            public void run() {
                OfficePrintHandler.this.exitPrintPreview(true);
            }
        };
        try {
            OleMessageLoop.invokeMethod((Object)runnable, (String)"run");
        }
        catch (Exception e) {
            LOG.error((Object)"", (Throwable)e);
        }
    }

    private void exitPrintPreview(boolean force) {
        this._inPrintPreview = false;
        if (force) {
            IInPlacePrintPreviewImpl preview = new IInPlacePrintPreviewImpl();
            preview.setAutoDelete(false);
            this._oleContainer.getOleObject().queryInterface(preview.getIID(), (IUnknown)preview);
            preview.endPrintPreview(new VariantBool(true));
            preview.release();
        }
    }

    public boolean isInPrintPreview() {
        return this._inPrintPreview;
    }

    private Window getParentWindow() {
        Container parent;
        for (parent = this._oleContainer.getParent(); parent != null && !(parent instanceof Window); parent = parent.getParent()) {
        }
        return (Window)parent;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PREVIEW_CALLBACK_FACTORY = OfficePrintHandler.createPreviewCallbackFactory();
    }

    public static class PreviewCallback
    extends IUnknownServer {
        private OfficePrintHandler _printHandler;

        public PreviewCallback(CoClassMetaInfo classImpl) {
            super(classImpl);
        }

        public void setPrintHandler(OfficePrintHandler helper) {
            this._printHandler = helper;
        }

        public void Notify(Int32 wStatus, Int32 nLastPage, Pointer previewStatus) {
            if (wStatus.getValue() == 32L || wStatus.getValue() == 1L || wStatus.getValue() == 128L) {
                this._printHandler.exitPrintPreview(true);
            }
        }
    }
}

