/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.samples.demo;

import com.jniwrapper.util.Logger;
import com.jniwrapper.win32.automation.Automation;
import com.jniwrapper.win32.automation.FileOperationsHandler;
import com.jniwrapper.win32.automation.OleContainer;
import com.jniwrapper.win32.automation.OleMessageLoop;
import com.jniwrapper.win32.automation.PrintHandler;
import com.jniwrapper.win32.com.IUnknown;
import com.jniwrapper.win32.samples.demo.OleContainerInfoBean;
import com.jniwrapper.win32.samples.demo.operations.OfficeFileOperationsHandler;
import com.jniwrapper.win32.samples.demo.operations.OfficePrintHandler;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PowerPointContainer
extends OleContainerInfoBean {
    private static final Logger LOG = Logger.getInstance((Class)(class$com$jniwrapper$win32$samples$demo$PowerPointContainer == null ? (class$com$jniwrapper$win32$samples$demo$PowerPointContainer = PowerPointContainer.class$("com.jniwrapper.win32.samples.demo.PowerPointContainer")) : class$com$jniwrapper$win32$samples$demo$PowerPointContainer));
    private JTextField tfName;
    private JLabel lblSlidesCount;
    private JCheckBox cbStatic;
    static /* synthetic */ Class class$com$jniwrapper$win32$samples$demo$PowerPointContainer;
    static /* synthetic */ Class class$com$jniwrapper$win32$samples$demo$ExcelContainer;

    public PowerPointContainer() {
        super("Powerpoint.Show", "Microsoft PowerPoint files (*.ppt)|*.ppt", "This page demonstrates OLE Container with a Microsoft PowerPoint presentation embedded.", "ppt");
    }

    public OleContainer getContainer() {
        if (this._container == null) {
            OleContainer container = super.getContainer();
            container.setFileOperationsHandler((FileOperationsHandler)new OfficeFileOperationsHandler(3){

                public void documentOpened(File file) {
                    if (PowerPointContainer.this.cbStatic.isSelected()) {
                        PowerPointContainer.this.cbStatic.setSelected(false);
                    }
                    try {
                        OleMessageLoop.invokeMethod((Object)PowerPointContainer.this, (String)"displayFileInfo");
                    }
                    catch (Exception e) {
                        LOG.error((Object)"", (Throwable)e);
                    }
                }
            });
            container.setPrintDocumentHandler((PrintHandler)new OfficePrintHandler());
        }
        return super.getContainer();
    }

    public void loadFile(String fileName) {
        this.getContainer().open(new File(fileName));
    }

    public void displayFileInfo() {
        Automation presentation = new Automation((IUnknown)this.getContainer().getOleObject());
        String name = presentation.getProperty("Name").getBstrVal().getValue();
        Automation slides = new Automation((IUnknown)presentation.getProperty("Slides").getPdispVal());
        String worksheetsCount = String.valueOf(slides.getProperty("Count").getIntVal().getValue());
        this.tfName.setText(name);
        this.lblSlidesCount.setText(worksheetsCount);
    }

    public JPanel createFileInfoPanel() {
        JPanel pageInfo = new JPanel(new GridBagLayout());
        pageInfo.setBorder(BorderFactory.createTitledBorder("Presentation Info"));
        pageInfo.setPreferredSize(new Dimension(100, 75));
        JLabel lblNameLabel = new JLabel("Presentation Name:");
        JLabel lblWordsCountLabel = new JLabel("Slides Count:");
        this.tfName = new JTextField();
        this.tfName.setBackground(null);
        this.tfName.setBorder(BorderFactory.createEmptyBorder());
        this.tfName.setEditable(false);
        this.lblSlidesCount = new JLabel();
        this.cbStatic = new JCheckBox("Static Display Mode");
        this.cbStatic.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OleContainer container = PowerPointContainer.this.getContainer();
                if (PowerPointContainer.this.cbStatic.isSelected()) {
                    container.setAutoActivateMode(OleContainer.AutoActivateMode.Manual);
                    container.inPlaceDeactivate();
                } else {
                    container.setAutoActivateMode(OleContainer.AutoActivateMode.GetFocus);
                    container.doVerb(-1);
                }
            }
        });
        pageInfo.add((Component)lblWordsCountLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        pageInfo.add((Component)this.lblSlidesCount, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 10, 10), 0, 0));
        pageInfo.add((Component)lblNameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 10, 10), 0, 0));
        pageInfo.add((Component)this.tfName, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 10, 10), 0, 0));
        pageInfo.add((Component)this.cbStatic, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 10, 10), 0, 0));
        pageInfo.add((Component)new Panel(), new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        return pageInfo;
    }

    public ImageIcon getIcon() {
        ImageIcon icon = null;
        try {
            icon = new ImageIcon(ImageIO.read((class$com$jniwrapper$win32$samples$demo$ExcelContainer == null ? (class$com$jniwrapper$win32$samples$demo$ExcelContainer = PowerPointContainer.class$("com.jniwrapper.win32.samples.demo.ExcelContainer")) : class$com$jniwrapper$win32$samples$demo$ExcelContainer).getResourceAsStream("res/powerpoint.png")));
        }
        catch (Exception e) {
            LOG.error((Object)"", (Throwable)e);
        }
        return icon;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

