/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.samples.demo;

import com.jniwrapper.util.Logger;
import com.jniwrapper.win32.automation.Automation;
import com.jniwrapper.win32.automation.OleContainer;
import com.jniwrapper.win32.automation.types.Variant;
import com.jniwrapper.win32.com.IUnknown;
import com.jniwrapper.win32.samples.demo.OleContainerInfoBean;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MediaPlayerContainer
extends OleContainerInfoBean {
    private static final Logger LOG = Logger.getInstance((Class)(class$com$jniwrapper$win32$samples$demo$MediaPlayerContainer == null ? (class$com$jniwrapper$win32$samples$demo$MediaPlayerContainer = MediaPlayerContainer.class$("com.jniwrapper.win32.samples.demo.MediaPlayerContainer")) : class$com$jniwrapper$win32$samples$demo$MediaPlayerContainer));
    private JLabel lblClipFileName;
    private JLabel lblClipDuration = new JLabel();
    private JLabel lblVideoSize;
    private JCheckBox cbMute;
    private JPanel _fileInfo;
    static /* synthetic */ Class class$com$jniwrapper$win32$samples$demo$MediaPlayerContainer;
    static /* synthetic */ Class class$com$jniwrapper$win32$samples$demo$ExcelContainer;

    public MediaPlayerContainer() {
        super("MediaPlayer.MediaPlayer.1", "Media Files (*.avi; *.mpg; *.mpeg; *.wmv; *.asf; *.mp3)|*.avi;*.mpg;*.mpeg;*.wmv;*.asf; *.mp3", "This page demonstrates the MediaPlayer ActiveX component embedded into OleContainer.", "avi");
        this.lblClipFileName = new JLabel();
        this.lblVideoSize = new JLabel();
        this.cbMute = new JCheckBox("Mute");
    }

    public void loadFile(String fileName) {
        OleContainer container = this.getContainer();
        Automation automation = new Automation((IUnknown)container.getOleObject());
        automation.setProperty("FileName", (Object)fileName);
        container.doVerb(-5);
        final Automation mediaPlayer = new Automation((IUnknown)this.getContainer().getOleObject());
        fileName = mediaPlayer.getProperty("FileName").getBstrVal().getValue();
        String duration = this.parseClipDuration((long)mediaPlayer.getProperty("Duration").getDblVal().getValue());
        long videoWidth = mediaPlayer.getProperty("ImageSourceWidth").getIntVal().getValue();
        long videoHeight = mediaPlayer.getProperty("ImageSourceHeight").getIntVal().getValue();
        String videoSize = "";
        if (videoWidth != 0L && videoHeight != 0L) {
            videoSize = "Video Size: " + String.valueOf(videoWidth) + "x" + String.valueOf(videoHeight);
        }
        this.lblClipFileName.setText(fileName);
        this.lblClipDuration.setText(duration);
        this.lblVideoSize.setText(videoSize);
        this.cbMute.setSelected(mediaPlayer.getProperty("Mute").getBoolVal().getBooleanValue());
        this.cbMute.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                mediaPlayer.setProperty("Mute", new Variant(MediaPlayerContainer.this.cbMute.isSelected()));
            }
        });
        this._fileInfo.revalidate();
        this._fileInfo.repaint();
    }

    public ImageIcon getIcon() {
        ImageIcon icon = null;
        try {
            icon = new ImageIcon(ImageIO.read((class$com$jniwrapper$win32$samples$demo$ExcelContainer == null ? (class$com$jniwrapper$win32$samples$demo$ExcelContainer = MediaPlayerContainer.class$("com.jniwrapper.win32.samples.demo.ExcelContainer")) : class$com$jniwrapper$win32$samples$demo$ExcelContainer).getResourceAsStream("res/mplayer.png")));
        }
        catch (Exception e) {
            LOG.error((Object)"", (Throwable)e);
        }
        return icon;
    }

    public JPanel createFileInfoPanel() {
        this._fileInfo = new JPanel(new GridBagLayout());
        this._fileInfo.setBorder(BorderFactory.createTitledBorder("Media File Info"));
        this._fileInfo.setPreferredSize(new Dimension(100, 75));
        JLabel lblClipFileNameLabel = new JLabel("Clip File Name:");
        JLabel lblClipDurationLabel = new JLabel("Clip Duration:");
        this._fileInfo.add((Component)lblClipFileNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this._fileInfo.add((Component)this.lblClipFileName, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 10, 10), 0, 0));
        this._fileInfo.add((Component)this.cbMute, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 10, 10), 0, 0));
        this._fileInfo.add((Component)lblClipDurationLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 10, 10), 0, 0));
        this._fileInfo.add((Component)this.lblClipDuration, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 10), 0, 0));
        this._fileInfo.add((Component)this.lblVideoSize, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 10, 10), 0, 0));
        this._fileInfo.add((Component)new Panel(), new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        return this._fileInfo;
    }

    private String parseClipDuration(long seconds) {
        StringBuffer result = new StringBuffer();
        long hh = seconds / 3600L;
        long mm = (seconds - hh * 60L * 60L) / 60L;
        long ss = seconds - hh * 60L * 60L - mm * 60L;
        if (hh < 10L) {
            result.append("0").append(String.valueOf(hh));
        } else {
            result.append(String.valueOf(hh));
        }
        result.append(":");
        if (mm < 10L) {
            result.append("0").append(String.valueOf(mm));
        } else {
            result.append(String.valueOf(mm));
        }
        result.append(":");
        if (ss < 10L) {
            result.append("0").append(String.valueOf(ss));
        } else {
            result.append(String.valueOf(ss));
        }
        return result.toString();
    }

    public void activate() {
        OleContainer container = this.getContainer();
        container.doVerb(-5);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

