/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.samples.demo;

import com.jniwrapper.util.Logger;
import com.jniwrapper.win32.automation.Automation;
import com.jniwrapper.win32.automation.FileOperationsHandler;
import com.jniwrapper.win32.automation.OleContainer;
import com.jniwrapper.win32.automation.OleMessageLoop;
import com.jniwrapper.win32.automation.PrintHandler;
import com.jniwrapper.win32.com.IUnknown;
import com.jniwrapper.win32.samples.demo.OleContainerInfoBean;
import com.jniwrapper.win32.samples.demo.operations.OfficeFileOperationsHandler;
import com.jniwrapper.win32.samples.demo.operations.OfficePrintHandler;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ExcelContainer
extends OleContainerInfoBean {
    private static final Logger LOG = Logger.getInstance((Class)(class$com$jniwrapper$win32$samples$demo$ExcelContainer == null ? (class$com$jniwrapper$win32$samples$demo$ExcelContainer = ExcelContainer.class$("com.jniwrapper.win32.samples.demo.ExcelContainer")) : class$com$jniwrapper$win32$samples$demo$ExcelContainer));
    JLabel lblAuthor;
    JLabel lblName;
    JLabel lblWorksheetsCount;
    JCheckBox cbStatic;
    static /* synthetic */ Class class$com$jniwrapper$win32$samples$demo$ExcelContainer;

    public ExcelContainer() {
        super("Excel.Sheet", "Microsoft Excel files (*.xls)|*.xls", "This page demonstrates OLE Container with a Microsoft Excel workbook embedded.", "xls");
    }

    public OleContainer getContainer() {
        if (this._container == null) {
            OleContainer container = super.getContainer();
            container.setFileOperationsHandler((FileOperationsHandler)new OfficeFileOperationsHandler(1){

                public void documentOpened(File file) {
                    if (ExcelContainer.this.cbStatic.isSelected()) {
                        ExcelContainer.this.cbStatic.setSelected(false);
                    }
                    try {
                        OleMessageLoop.invokeMethod((Object)ExcelContainer.this, (String)"displayFileInfo");
                    }
                    catch (Exception e) {
                        LOG.error((Object)"", (Throwable)e);
                    }
                }
            });
            container.setPrintDocumentHandler((PrintHandler)new OfficePrintHandler());
        }
        return super.getContainer();
    }

    public void loadFile(String fileName) {
        this.getContainer().open(new File(fileName));
    }

    public void displayFileInfo() {
        Automation workbook = new Automation((IUnknown)this.getContainer().getOleObject());
        String author = workbook.getProperty("Author").getBstrVal().getValue();
        String name = workbook.getProperty("Name").getBstrVal().getValue();
        Automation worksheets = new Automation((IUnknown)workbook.getProperty("Worksheets").getPdispVal());
        String worksheetsCount = String.valueOf(worksheets.getProperty("Count").getIntVal().getValue());
        this.lblAuthor.setText(author);
        this.lblName.setText(name);
        this.lblWorksheetsCount.setText(worksheetsCount);
    }

    public JPanel createFileInfoPanel() {
        JPanel pageInfo = new JPanel(new GridBagLayout());
        pageInfo.setBorder(BorderFactory.createTitledBorder("Workbook Info"));
        pageInfo.setPreferredSize(new Dimension(100, 75));
        JLabel lblAuthorLabel = new JLabel("Author:");
        JLabel lblNameLabel = new JLabel("Name:");
        JLabel lblWorksheetsCountLabel = new JLabel("Worksheets Count:");
        this.lblAuthor = new JLabel();
        this.lblName = new JLabel();
        this.lblWorksheetsCount = new JLabel();
        this.cbStatic = new JCheckBox("Static Display Mode");
        this.cbStatic.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OleContainer container = ExcelContainer.this.getContainer();
                if (ExcelContainer.this.cbStatic.isSelected()) {
                    container.setAutoActivateMode(OleContainer.AutoActivateMode.Manual);
                    container.inPlaceDeactivate();
                } else {
                    container.setAutoActivateMode(OleContainer.AutoActivateMode.GetFocus);
                    container.doVerb(-5);
                }
            }
        });
        pageInfo.add((Component)lblAuthorLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        pageInfo.add((Component)this.lblAuthor, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 10, 10), 0, 0));
        pageInfo.add((Component)lblNameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 10, 10), 0, 0));
        pageInfo.add((Component)this.lblName, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 10, 10), 0, 0));
        pageInfo.add((Component)lblWorksheetsCountLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 10, 10), 0, 0));
        pageInfo.add((Component)this.lblWorksheetsCount, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 10, 10), 0, 0));
        pageInfo.add((Component)this.cbStatic, new GridBagConstraints(2, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 10, 10), 0, 0));
        pageInfo.add((Component)new Panel(), new GridBagConstraints(0, 2, 4, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        return pageInfo;
    }

    public ImageIcon getIcon() {
        ImageIcon icon = null;
        try {
            icon = new ImageIcon(ImageIO.read((class$com$jniwrapper$win32$samples$demo$ExcelContainer == null ? (class$com$jniwrapper$win32$samples$demo$ExcelContainer = ExcelContainer.class$("com.jniwrapper.win32.samples.demo.ExcelContainer")) : class$com$jniwrapper$win32$samples$demo$ExcelContainer).getResourceAsStream("res/excel.png")));
        }
        catch (Exception e) {
            LOG.error((Object)"", (Throwable)e);
        }
        return icon;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

