/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.com.generator.ideaplugin.util;

import com.intellij.openapi.projectRoots.ProjectJdk;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.roots.SourceFolder;

public class GeneratorPreferences {
    private static final GeneratorPreferences INSTANCE = new GeneratorPreferences();
    private SourceFolder _sourceFolder = null;
    private ProjectJdk _projectJDK = null;
    private ProjectJdk _specificJDK = null;
    private ProjectJdk _selectedJDK = null;
    private String _comfyJPath = "";

    private GeneratorPreferences() {
    }

    public static GeneratorPreferences getInstance() {
        return INSTANCE;
    }

    public SourceFolder getSourceFolder() {
        return this._sourceFolder;
    }

    public ProjectJdk getSelectedJDK() {
        return this._selectedJDK;
    }

    public ProjectJdk getProjectJDK() {
        return this._projectJDK;
    }

    public String getProjectJDKName() {
        return this._projectJDK != null ? this._projectJDK.getName() : "";
    }

    public ProjectJdk getSpecificJDK() {
        return this._specificJDK;
    }

    public String getSpecificJDKName() {
        return this._specificJDK != null ? this._specificJDK.getName() : "";
    }

    public String getComfyJPath() {
        return this._comfyJPath;
    }

    public void setSelectedJDK(ProjectJdk selectedJDK) {
        this._selectedJDK = selectedJDK;
    }

    public void setProjectJDK(ProjectJdk projectJDK) {
        this._projectJDK = projectJDK;
        this._selectedJDK = projectJDK;
    }

    public void setProjectJDK(String projectName) {
        ProjectJdk projectByName = this.getProjectByName(projectName);
        this.setProjectJDK(projectByName);
    }

    public void setSpecificJDK(ProjectJdk specificJDK) {
        this._specificJDK = specificJDK;
        this._selectedJDK = specificJDK;
    }

    public void setSpecificJDK(String projectName) {
        ProjectJdk projectByName = this.getProjectByName(projectName);
        this.setSpecificJDK(projectByName);
    }

    private ProjectJdk getProjectByName(String name) {
        ProjectJdkTable tableJDKs = ProjectJdkTable.getInstance();
        ProjectJdk[] JDKs = tableJDKs.getAllJdks();
        for (int i = 0; i < JDKs.length; ++i) {
            ProjectJdk jdk = JDKs[i];
            if (!jdk.getName().equals(name)) continue;
            return jdk;
        }
        return null;
    }

    public void setComfyJPath(String comfyJPath) {
        this._comfyJPath = comfyJPath;
    }

    public void setSourceFolder(SourceFolder sourceFolder) {
        this._sourceFolder = sourceFolder;
    }
}

