/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.com.generator.ideaplugin.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.DocumentAdapter;
import com.jniwrapper.win32.com.generator.ideaplugin.ui.SelectSourceFolderDialog;
import com.jniwrapper.win32.com.generator.ideaplugin.util.GeneratorPreferences;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

public class ModeSelectionDialog
extends DialogWrapper {
    private Project _project;
    private JTextField _jarLocationField;
    private JTextField _sourceFolderField;
    private JTextField _javaDocsLocationField;
    private JRadioButton _sourceFilesButton;
    private JRadioButton _packToJarButton;
    private JButton _browseForSourceFolderButton;
    private JButton _browseForJarButton;
    private JButton _browseForDocsButton;
    private JCheckBox _generateDocsCheckBox;
    private boolean _packToJar;
    private boolean _generateJavaDocs;
    private String _javaDocsPath;
    private String _jarLocation;
    private SourceFolder _sourceFolder;

    public ModeSelectionDialog(Project project) {
        super(true);
        this._project = project;
        this.init();
        this.setTitle("Code Generator Mode");
    }

    public boolean isPackToJar() {
        return this._packToJar;
    }

    public boolean isGenerateJavaDocs() {
        return this._generateJavaDocs;
    }

    public String getJavaDocsPath() {
        return this._javaDocsPath;
    }

    public String getJarLocation() {
        return this._jarLocation;
    }

    public SourceFolder getSourceFolder() {
        return this._sourceFolder;
    }

    protected JComponent createCenterPanel() {
        JPanel mainPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        mainPanel.setLayout(layout);
        mainPanel.setPreferredSize(new Dimension(250, 250));
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ModeSelectionDialog.this.refreshControlsEnablement();
            }
        };
        DocumentAdapter docListener = new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ModeSelectionDialog.this.verifyContent();
            }
        };
        this._sourceFilesButton = new JRadioButton("Generate source files to:");
        this._sourceFilesButton.setSelected(true);
        this._sourceFilesButton.addActionListener(listener);
        this._sourceFolderField = new JTextField();
        this._sourceFolderField.setPreferredSize(new Dimension(150, 23));
        this._sourceFolderField.setMinimumSize(new Dimension(150, 23));
        this._sourceFolderField.setEditable(false);
        this._sourceFolderField.getDocument().addDocumentListener((DocumentListener)docListener);
        this._browseForSourceFolderButton = new JButton("...");
        this._browseForSourceFolderButton.setPreferredSize(new Dimension(25, 23));
        this._browseForSourceFolderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ModeSelectionDialog.this.browseForSourceFolderButtonPressed();
            }
        });
        this._packToJarButton = new JRadioButton("Pack generated classes to JAR:");
        this._packToJarButton.addActionListener(listener);
        ButtonGroup radioGroup = new ButtonGroup();
        radioGroup.add(this._sourceFilesButton);
        radioGroup.add(this._packToJarButton);
        this._jarLocationField = new JTextField();
        this._jarLocationField.setMinimumSize(new Dimension(150, 23));
        this._jarLocationField.setPreferredSize(new Dimension(150, 23));
        this._jarLocationField.getDocument().addDocumentListener((DocumentListener)docListener);
        this._browseForJarButton = new JButton("...");
        this._browseForJarButton.setPreferredSize(new Dimension(25, 23));
        this._browseForJarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ModeSelectionDialog.this.browseForJARButtonPressed();
            }
        });
        this._generateDocsCheckBox = new JCheckBox("Generate Java docs to:");
        this._generateDocsCheckBox.addActionListener(listener);
        this._javaDocsLocationField = new JTextField();
        this._javaDocsLocationField.setMinimumSize(new Dimension(150, 23));
        this._javaDocsLocationField.setPreferredSize(new Dimension(150, 23));
        this._javaDocsLocationField.getDocument().addDocumentListener((DocumentListener)docListener);
        this._browseForDocsButton = new JButton("...");
        this._browseForDocsButton.setPreferredSize(new Dimension(25, 23));
        this._browseForDocsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ModeSelectionDialog.this.browseForDocsButtonPressed();
            }
        });
        mainPanel.add((Component)this._sourceFilesButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        mainPanel.add((Component)this._sourceFolderField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 19, 2, new Insets(5, 0, 5, 0), 0, 0));
        mainPanel.add((Component)this._browseForSourceFolderButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 19, 0, new Insets(5, 5, 5, 5), 0, 0));
        mainPanel.add((Component)this._packToJarButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 23, new Insets(5, 5, 5, 0), 0, 0));
        mainPanel.add((Component)this._jarLocationField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 19, 2, new Insets(5, 0, 5, 0), 0, 0));
        mainPanel.add((Component)this._browseForJarButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 19, 0, new Insets(5, 5, 5, 5), 0, 0));
        mainPanel.add((Component)new JSeparator(), new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 0), 0, 0));
        mainPanel.add((Component)this._generateDocsCheckBox, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        mainPanel.add((Component)this._javaDocsLocationField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 0), 0, 0));
        mainPanel.add((Component)this._browseForDocsButton, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        mainPanel.add((Component)Box.createVerticalBox(), new GridBagConstraints(0, 4, 3, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.refreshControlsEnablement();
        this.verifyContent();
        return mainPanel;
    }

    private void browseForSourceFolderButtonPressed() {
        SourceFolder sourceFolder;
        GeneratorPreferences preferences = GeneratorPreferences.getInstance();
        SelectSourceFolderDialog sourceFolderDialog = new SelectSourceFolderDialog(this._project, preferences.getSourceFolder(), true);
        sourceFolderDialog.show();
        if (sourceFolderDialog.isOK() && (sourceFolder = sourceFolderDialog.getSourceFolder()) != null) {
            this._sourceFolderField.setText(this.normalizePath(sourceFolder.getFile().getUrl()));
            this._sourceFolder = sourceFolder;
        }
    }

    private void browseForJARButtonPressed() {
        JFileChooser chooser = new JFileChooser();
        chooser.setApproveButtonText("Select");
        chooser.setDialogTitle("Select existing or create new JAR");
        chooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".jar");
            }

            public String getDescription() {
                return "*.jar";
            }
        });
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setMultiSelectionEnabled(false);
        if (chooser.showOpenDialog(this.getContentPane()) != 0) {
            return;
        }
        File selected = chooser.getSelectedFile();
        if (selected != null) {
            this._jarLocationField.setText(this.normalizePath(selected.getPath()));
        }
    }

    private void browseForDocsButtonPressed() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle("Select generated Java docs path");
        chooser.setMultiSelectionEnabled(true);
        if (chooser.showOpenDialog(this.getContentPane()) != 0) {
            return;
        }
        File selectedFolder = chooser.getSelectedFile();
        if (selectedFolder != null) {
            this._javaDocsLocationField.setText(this.normalizePath(selectedFolder.getPath()));
        }
    }

    private void refreshControlsEnablement() {
        this._browseForSourceFolderButton.setEnabled(this._sourceFilesButton.isSelected());
        boolean enabled = this._packToJarButton.isSelected();
        this._jarLocationField.setEditable(enabled);
        this._browseForJarButton.setEnabled(enabled);
        enabled = this._generateDocsCheckBox.isSelected();
        this._javaDocsLocationField.setEditable(enabled);
        this._browseForDocsButton.setEnabled(enabled);
    }

    protected void doOKAction() {
        this._generateJavaDocs = this._generateDocsCheckBox.isSelected();
        this._packToJar = this._packToJarButton.isSelected();
        this._javaDocsPath = this._javaDocsLocationField.getText();
        this._jarLocation = this._jarLocationField.getText();
        super.doOKAction();
    }

    private void verifyContent() {
        boolean enableOk = true;
        if (this._sourceFilesButton.isSelected() && this._sourceFolderField.getText().length() == 0) {
            enableOk = false;
        }
        if (this._packToJarButton.isSelected() && this._jarLocationField.getText().length() == 0) {
            enableOk = false;
        }
        if (this._generateDocsCheckBox.isSelected() && this._javaDocsLocationField.getText().length() == 0) {
            enableOk = false;
        }
        this.setOKActionEnabled(enableOk);
    }

    private String normalizePath(String path) {
        return path.replaceAll("\\\\", "/");
    }
}

