/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.com.generator.ideaplugin;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.jniwrapper.win32.com.generator.ideaplugin.util.GeneratorPreferences;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jdom.Element;

public class ComfyJPluginConfiguration {
    public static final String PROJECT_JDK_RBTN = "PROJECT_JDK_RBTN";
    public static final String SPECIFIC_JDK_RBTN = "SPECIFIC_JDK_RBTN";
    public static final String PROJECT_JDK = "PROJECT_JDK";
    public static final String SPECIFIC_JDK = "SPECIFIC_JDK";
    public static final String COMFYJ_PATH = "COMFYJ_PATH";
    public static final String COMFYJ_TITLE = "ComfyJ";
    private static final double COMFYJ_VERSION = 2.2;
    private static final ComfyJPluginConfiguration INSTANCE = new ComfyJPluginConfiguration();
    private Properties _properties = new Properties();

    private ComfyJPluginConfiguration() {
        this._properties.setProperty(PROJECT_JDK_RBTN, "true");
        this._properties.setProperty(SPECIFIC_JDK_RBTN, "false");
        this._properties.setProperty(PROJECT_JDK, "");
        this._properties.setProperty(SPECIFIC_JDK, "");
        this._properties.setProperty(COMFYJ_PATH, "");
    }

    public static ComfyJPluginConfiguration getInstance() {
        return INSTANCE;
    }

    public void readExternal(Element element) throws InvalidDataException {
        List settings = element.getChildren("settings");
        for (Element subElement : settings) {
            String name = subElement.getAttribute("name").getValue();
            String value = subElement.getAttribute("value").getValue();
            this._properties.put(name, value);
        }
        this.createGeneratorPreferences();
    }

    public void writeExternal(Element element) throws WriteExternalException {
        Set<Map.Entry<Object, Object>> set = this._properties.entrySet();
        for (Map.Entry<Object, Object> entry : set) {
            Element subElement = new Element("settings");
            subElement.setAttribute("name", entry.getKey().toString());
            subElement.setAttribute("value", entry.getValue().toString());
            element.addContent(subElement);
        }
    }

    private void createGeneratorPreferences() {
        GeneratorPreferences preferences = GeneratorPreferences.getInstance();
        String stringSetting = this.getStringSetting(PROJECT_JDK);
        preferences.setProjectJDK(stringSetting);
        preferences.setSpecificJDK(this.getStringSetting(SPECIFIC_JDK));
        String comfyJPath = this.getStringSetting(COMFYJ_PATH);
        if (!this.checkComfyJLocation(comfyJPath) && !this.checkComfyJVersion(comfyJPath)) {
            comfyJPath = "";
        }
        preferences.setComfyJPath(comfyJPath);
    }

    public void setSetting(String name, boolean value) {
        this._properties.setProperty(name, value ? "true" : "false");
    }

    public void setSetting(String name, String value) {
        this._properties.setProperty(name, value);
    }

    public boolean getBooleanSetting(String name) {
        return this._properties.getProperty(name).equalsIgnoreCase("true");
    }

    public String getStringSetting(String name) {
        return this._properties.getProperty(name);
    }

    public boolean checkComfyJVersion(String path) {
        File comfyJDirectory = new File(path + "/lib");
        if (comfyJDirectory.exists() && comfyJDirectory.isDirectory()) {
            File[] files = comfyJDirectory.listFiles();
            for (int i = 0; i < files.length; ++i) {
                Manifest manifest;
                try {
                    JarFile jarFile = new JarFile(files[i]);
                    manifest = jarFile.getManifest();
                }
                catch (IOException e) {
                    continue;
                }
                Attributes mainAttributes = manifest.getMainAttributes();
                String version = mainAttributes.getValue("Version");
                String title = mainAttributes.getValue("Title");
                if (version == null || !(Double.parseDouble(version) >= 2.2) || title == null || !title.equalsIgnoreCase(COMFYJ_TITLE)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean checkComfyJLocation(String path) {
        File comfyJDirectory = new File(path + "/lib");
        if (comfyJDirectory.exists() && comfyJDirectory.isDirectory()) {
            File[] files = comfyJDirectory.listFiles();
            for (int i = 0; i < files.length; ++i) {
                Manifest manifest;
                try {
                    JarFile jarFile = new JarFile(files[i]);
                    manifest = jarFile.getManifest();
                }
                catch (IOException e) {
                    continue;
                }
                Attributes mainAttributes = manifest.getMainAttributes();
                String title = mainAttributes.getValue("Title");
                if (title == null || !title.equalsIgnoreCase(COMFYJ_TITLE)) continue;
                return true;
            }
        }
        return false;
    }
}

