/*
 * Decompiled with CFR 0.152.
 */
package comfyj.generator.eclipseplugin.popup.actions;

import comfyj.generator.eclipseplugin.preferences.GeneratorPreferences;
import comfyj.generator.eclipseplugin.ui.ContainerSelectionDialog;
import comfyj.generator.eclipseplugin.utility.ResourcesUtility;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.actions.FormatAllAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class CodeGenerateAction
implements IObjectActionDelegate,
IWorkbenchWindowActionDelegate {
    protected IWorkbenchWindow window;
    protected IWorkbenchSite site;
    protected ISelection selection;
    protected IProject selectedProject;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.site = targetPart.getSite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(IAction action) {
        Shell shell;
        Shell shell2 = shell = this.window != null ? this.window.getShell() : new Shell();
        if (this.selection != null && this.selection instanceof IStructuredSelection) {
            this.selectedProject = (IProject)((IStructuredSelection)this.selection).iterator().next();
            try {
                if (!ResourcesUtility.isJavaProject(this.selectedProject)) {
                    MessageDialog.openInformation((Shell)shell, (String)"Project Verification", (String)"The selected project is not a Java project.");
                    return;
                }
            }
            catch (CoreException e) {
                MessageDialog.openError((Shell)shell, (String)"Failed to Verify Project", (String)e.getMessage());
                return;
            }
            ContainerSelectionDialog dialog = new ContainerSelectionDialog(shell, (IContainer)this.selectedProject);
            if (dialog.open() == 0) {
                IProject selectedContainer = dialog.getSelectedContainer() == null ? this.selectedProject : dialog.getSelectedContainer();
                GeneratorPreferences preferences = GeneratorPreferences.getInstance();
                String javahome = this.getVerifiedJDKPath(preferences);
                if (!ResourcesUtility.checkComfyJLocation(preferences.getComfyJPath())) {
                    MessageDialog.openError((Shell)shell, (String)"Incorrect ComfyJ Location", (String)"The specified ComfyJ path is not correct. Navigate to 'Window -> Preferences... -> Code Generator for ComfyJ' in order to specify ComfyJ path.");
                    return;
                }
                String comfyJars = ResourcesUtility.findJars(preferences.getComfyJPath());
                if (javahome == null || javahome.trim().length() == 0 || comfyJars.trim().length() == 0) {
                    return;
                }
                String cmd = MessageFormat.format("{0}\\bin\\java.exe -cp {1} com.jniwrapper.win32.com.generator.Application -path \"" + selectedContainer.getLocation() + "\" -plugin", javahome, comfyJars);
                try {
                    Process process = Runtime.getRuntime().exec(cmd, null, new File(preferences.getComfyJPath() + "/bin"));
                    InputStream is = process.getInputStream();
                    is.close();
                    InputStream err = process.getErrorStream();
                    BufferedReader errorReader = new BufferedReader(new InputStreamReader(err));
                    try {
                        String line;
                        String output = "";
                        while ((line = errorReader.readLine()) != null) {
                            output = output + line + "\n";
                        }
                        if (output.indexOf("java.lang.ExceptionInInitializerError") != -1) {
                            MessageDialog.openError((Shell)shell, (String)"Execution error", (String)"Unable to start the Code Generator for ComfyJ.\nMake sure the JNIWrapper and ComfyJ license files are located in the ComfyJ folder.");
                            return;
                        }
                    }
                    finally {
                        is.close();
                        err.close();
                        errorReader.close();
                    }
                    process.waitFor();
                    if (process.exitValue() != 0) {
                        return;
                    }
                }
                catch (Exception e) {
                    MessageDialog.openError((Shell)shell, (String)"Failed to Launch Code Generator for ComfyJ", (String)e.getMessage());
                    return;
                }
                try {
                    new ProgressMonitorDialog(shell).run(true, true, new IRunnableWithProgress((IContainer)selectedContainer){
                        private final /* synthetic */ IContainer val$selectedContainer;
                        {
                            this.val$selectedContainer = val$selectedContainer;
                        }

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                this.val$selectedContainer.refreshLocal(2, null);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    FormatAllAction formatAction = new FormatAllAction(this.site);
                    formatAction.run((IStructuredSelection)new StructuredSelection((Object[])this.collectPackages((IContainer)selectedContainer)));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    private String getVerifiedJDKPath(GeneratorPreferences preferences) {
        String jdkPath = "";
        if (preferences.useSpecificJDK()) {
            jdkPath = this.containsToolsAndJavaExe(preferences.getJDKPath());
        } else {
            IJavaProject javaProject = JavaCore.create((IProject)this.selectedProject);
            IVMInstall vmInstall = null;
            try {
                if (javaProject.exists()) {
                    vmInstall = JavaRuntime.getVMInstall((IJavaProject)javaProject);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if (vmInstall != null) {
                jdkPath = this.containsToolsAndJavaExe(vmInstall.getInstallLocation().getPath());
            }
        }
        return jdkPath;
    }

    private String containsToolsAndJavaExe(String jdkPath) {
        IPath javaExeLocation;
        File javaExeFile;
        IPath toolsLocation;
        File toolsFile;
        Path location = new Path(jdkPath);
        String error = null;
        if ("jre".equalsIgnoreCase(location.lastSegment())) {
            location = location.removeLastSegments(1);
        }
        if (!(toolsFile = (toolsLocation = location.append("lib").append("tools.jar")).toFile()).exists()) {
            error = toolsLocation.toString();
        }
        if (!(javaExeFile = (javaExeLocation = location.append("bin").append("java.exe")).toFile()).exists()) {
            error = javaExeLocation.toString();
        }
        if (error != null) {
            Shell shell = this.window != null ? this.window.getShell() : new Shell();
            MessageDialog.openInformation((Shell)shell, (String)"Incorrect JDK path", (String)("The JDK at location '" + location + "' cannot be used. File '" + error + "' not found, it is necessary for the correct Code Generator work.\nNavigate to 'Window -> Preferences... -> Code Generator for ComfyJ' in order to configure JDK settings."));
            jdkPath = null;
        } else {
            jdkPath = location.toString();
        }
        return jdkPath;
    }

    private IJavaElement[] collectPackages(IContainer root) throws CoreException {
        ArrayList packages = new ArrayList();
        this.collectPackagesRecursively(root, packages);
        return packages.toArray(new IJavaElement[packages.size()]);
    }

    private void collectPackagesRecursively(IContainer root, List collected) throws CoreException {
        collected.add(JavaCore.create((IResource)root));
        IResource[] members = root.members();
        for (int i = 0; i < members.length; ++i) {
            if (!(members[i] instanceof IContainer)) continue;
            this.collectPackagesRecursively((IContainer)members[i], collected);
        }
    }
}

