using System;
using System.Collections;
using System.Text;
using System.IO;

using NI.Email.Mime.Message;
using NI.Email.Mime.Field;
using NI.Email.Mime.Util;

namespace NI.Mime4Net.Samples.ExtractAttachments {
	public class Program {

		static void Main(string[] args) {
			Stream mimeMsgStream = new MemoryStream( Encoding.ASCII.GetBytes(mimeMsg) );

			MimeMessage m = new MimeMessage(mimeMsgStream);

			FindAttachments(m);
		}
		
		
		protected static void FindAttachments(Entity mimeEntity) {
			if (mimeEntity.IsMultipart) 
				foreach (Entity part in ((Multipart)mimeEntity.Body).BodyParts) {
					ContentTypeField contentType = part.Header.GetField(MimeField.ContentType) as ContentTypeField;
					if (contentType==null) continue;

					if (part.Body is MimeMessage) { 
						Console.WriteLine("Attached email found!");
						FindAttachments( (MimeMessage)part.Body );
					} else if ( !(part.Body is ITextBody) ) {
						Console.WriteLine("Attachment found: "+part.Header.GetField(MimeField.ContentType).Raw );
						
						// if available attachment name stored in content type 'name' parameter
						// be aware that 'name' _may_ contain invalid file name
						string logFile = contentType.Parameters.Contains("name") ?
							Path.Combine( Environment.CurrentDirectory, contentType.Parameters["name"].ToString() ) :
							Path.Combine( Environment.CurrentDirectory, Path.GetFileNameWithoutExtension(Path.GetTempFileName())+".attachment" );
						Console.WriteLine("Writing attachment to file: "+logFile );
						FileStream outFile = new FileStream(logFile, FileMode.Create);
						BinaryReader rdr = ((IBinaryBody)part.Body).Reader;

						byte[] buf = new byte[1024];
						int bytesRead = 0;
						while ( (bytesRead=rdr.Read(buf,0,buf.Length))>0 )
							outFile.Write(buf, 0, bytesRead);
						
						outFile.Flush();
                        outFile.Close();
					}
				} 
		}


		static string mimeMsg = @"x-sender: <>
x-receiver: SMS@server07.uk-me.com
Received: from mail.uk-me.com ([192.168.1.1]) by smzmailer.uk-me.com with Microsoft SMTPSVC(6.0.3790.211);   Thu, 29 Mar 2007 22:17:11 +0100
Received: from smzmailer.uk-me.com ([192.168.1.17]) by mail.uk-me.com with Microsoft SMTPSVC(5.0.2195.5329);  Thu, 29 Mar 2007 22:17:12 +0100
From: postmaster@SMS.uk-me.com
To: sms@uk-me.com
Date: Thu, 29 Mar 2007 22:17:11 +0100
MIME-Version: 1.0
Content-Type: multipart/report; report-type=delivery-status; boundary=""9B095B5ADSN=_01C765779A9125CC00000081smzmailer.uk?me.""
X-DSNContext: 7ce717b1 - 1142 - 00000001 - 00000000
Message-ID: <xnSYe4nhr000000ad@smzmailer.uk-me.com>
Subject: Delivery Status Notification (Failure)
Return-Path: <>
X-OriginalArrivalTime: 29 Mar 2007 21:17:12.0222 (UTC) FILETIME=[9DFD5BE0:01C77247]

This is a MIME-formatted message.  
Portions of this message may be unreadable without a MIME-capable mail program.

--9B095B5ADSN=_01C765779A9125CC00000081smzmailer.uk?me.
Content-Type: text/plain; charset=unicode-1-1-utf-7

This is an automatically generated Delivery Status Notification.

Delivery to the following recipients failed.
 
       andygriffiths@plc.com
 
 
 

--9B095B5ADSN=_01C765779A9125CC00000081smzmailer.uk?me.
Content-Type: message/delivery-status

Reporting-MTA: dns;smzmailer.uk-me.com
Received-From-MTA: dns;server16
Arrival-Date: Thu, 29 Mar 2007 22:17:07 +0100
Final-Recipient: rfc822;andygriffiths@plc.com
Action: failed
Status: 5.5.0
Diagnostic-Code: smtp;550 Invalid recipient <andygriffiths@plc.com> (#5.1.1)

--9B095B5ADSN=_01C765779A9125CC00000081smzmailer.uk?me.
Content-Type: message/rfc822

Received: from server16 ([192.168.1.28]) by smzmailer.uk-me.com with Microsoft SMTPSVC(6.0.3790.211); Thu, 29 Mar 2007 22:17:07 +0100
sensitivity: Normal
reply-to: sup@uk-me.com
importance: Normal
mime-version: 1.0
from: ""Mobile Enterprise SMZ Mailer"" <sms@uk-me.com>
to: michaelaspittles@plc.com, andygriffiths@plc.com, iainhorne@plc.com, markpaver@plc.com
date: 29 Mar 2007 22:17:08 +0100
subject: SMS Analyser Database Update - Vodafone UK(WIN)
content-type: multipart/mixed; boundary=--boundary_6_5c67bd1a-1e7e-4400-af5f-836d043c1017
Return-Path: smsanalyser@uk-me.com
Message-ID: <SERVER07rPFWy3rB07X000005f6@smzmailer.uk-me.com>
X-OriginalArrivalTime: 29 Mar 2007 21:17:07.0760 (UTC) FILETIME=[9B548300:01C77247]


----boundary_6_5c67bd1a-1e7e-4400-af5f-836d043c1017
content-type: text/html; charset=utf-8
content-transfer-encoding: base64

PEhUTUw+U01TIEFuYWx5c2lzIFNlcnZpY2UgcG93ZXJlZCBieSBNb2JpbGUgRW50ZXJwcmlz
PlNNUyBBbmFseXNlciBTdXBwb3J0PC9hPiBvciBjYWxsICs0NCAxNjM1IDU2ODc5MDwvSFRNTD4=
----boundary_6_5c67bd1a-1e7e-4400-af5f-836d043c1017
content-type: application/octet-stream; name=WIN_501.smz
content-transfer-encoding: base64

Kk1vYmlsZSBFbnRlcnByaXNlIFNNUyBBbmFseXNlciBTTVogW35TTVp+XVBLAwQUAAsACAAg
ZXJwcmlzZSBTTVMgQW5hbHlzZXIgU01aIEVuZA==
----boundary_6_5c67bd1a-1e7e-4400-af5f-836d043c1017--




--9B095B5ADSN=_01C765779A9125CC00000081smzmailer.uk?me.--";



	}
}
