/*
 * Decompiled with CFR 0.152.
 */
package com.smardec.license4j.demo;

import com.smardec.license4j.License;
import com.smardec.license4j.LicenseManager;
import com.smardec.license4j.LicenseUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public class DemoFrame
extends JFrame {
    private JButton jButtonPrevious = new JButton("< Previous");
    private JButton jButtonNext = new JButton("Next >");
    private CardLayout cardLayout = new CardLayout();
    private JPanel jPanelCards = new JPanel(this.cardLayout);
    private int currentCard = 0;
    private static final int totalCards = 4;
    private boolean keysGenerated = false;

    public static void main(String[] args) {
        DemoFrame demoFrame = new DemoFrame();
        demoFrame.setSize(600, 550);
        DemoFrame.centerOnScreen(demoFrame);
        demoFrame.show();
    }

    public DemoFrame() {
        this.setDefaultCloseOperation(3);
        this.setTitle("License4J Demo");
        this.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("com/smardec/license4j/demo/img/logo.gif")).getImage());
        this.initControls();
    }

    public void initControls() {
        this.jPanelCards.add((Component)this.getIntroPanel(), "panel_1");
        this.jPanelCards.add((Component)this.getKeysPanel(), "panel_2");
        this.jPanelCards.add((Component)this.getLicensePanel(), "panel_3");
        this.jPanelCards.add((Component)this.getLastPanel(), "panel_4");
        JPanel jPanelButtons = new JPanel(new GridLayout(1, 2, 5, 5));
        this.jButtonPrevious.setMnemonic('P');
        this.jButtonNext.setMnemonic('N');
        this.jButtonPrevious.setEnabled(false);
        this.jButtonPrevious.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DemoFrame.this.cardLayout.previous(DemoFrame.this.jPanelCards);
                DemoFrame.this.currentCard--;
                DemoFrame.this.setNavigationButtonsState();
            }
        });
        this.jButtonNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DemoFrame.this.currentCard == 3) {
                    System.exit(0);
                }
                DemoFrame.this.cardLayout.next(DemoFrame.this.jPanelCards);
                DemoFrame.this.currentCard++;
                DemoFrame.this.setNavigationButtonsState();
            }
        });
        jPanelButtons.add(this.jButtonPrevious);
        jPanelButtons.add(this.jButtonNext);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(Box.createHorizontalGlue(), "Center");
        jPanel.add((Component)jPanelButtons, "East");
        this.getContentPane().setLayout(new GridBagLayout());
        DemoFrame.constrain(this.getContentPane(), this.jPanelCards, 0, 0, 1, 1, 1, 18, 1.0, 1.0, 5, 5, 0, 5);
        DemoFrame.constrain(this.getContentPane(), jPanel, 0, 1, 1, 1, 2, 18, 0.0, 0.0, 5, 5, 5, 5);
    }

    private JPanel getIntroPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Introduction");
        titledBorder.setTitleColor(Color.black);
        jPanel.setBorder(titledBorder);
        JBlackLabel jLabelIntro = new JBlackLabel("<html>&nbsp;&nbsp;&nbsp;&nbsp;License4J is a pure Java library for creating and validating licenses. <br><br>&nbsp;&nbsp;&nbsp;&nbsp;The key concept is features of a license. You can easily add any feature to your license file, i.e. name of the product, version, expiry date, number of executable instances, customer's name, company, IP address, etc. Feature's value can be string or any serializable Java object. You can have unsigned features - features that are not used in the signature generation/verification and therefore can change their values leaving the license valid. <br>&nbsp;&nbsp;&nbsp;&nbsp;Also the library provides methods for signing arbitrary content that should not be changed by the user. <br><br>Advantages: <br>&nbsp;&nbsp;-&nbsp;&nbsp;Easy to use <br>&nbsp;&nbsp;-&nbsp;&nbsp;Straightforward API <br>&nbsp;&nbsp;-&nbsp;&nbsp;Use of public key standard methods <br>&nbsp;&nbsp;-&nbsp;&nbsp;Complete documentation <br>&nbsp;&nbsp;-&nbsp;&nbsp;Compatible with JDK 1.3, JDK 1.4 and JDK 1.5 <br>&nbsp;&nbsp;-&nbsp;&nbsp;Backward compatibility <br>&nbsp;&nbsp;-&nbsp;&nbsp;Free lifetime email support <br>&nbsp;&nbsp;-&nbsp;&nbsp;Free one year updates and upgrades <br>&nbsp;&nbsp;-&nbsp;&nbsp;No royalty or runtime fees</html>");
        DemoFrame.constrain(jPanel, jLabelIntro, 0, 0, 1, 1, 2, 18, 1.0, 1.0, 0, 5, 5, 5);
        return jPanel;
    }

    private JPanel getKeysPanel() {
        JBlackLabel jLabelIntro = new JBlackLabel("<html>At first you should generate private and public keys. The private key should not be disclosed as it is used to create new license files. The public key is used to validate license files. The public key is a one-way function of the private key so it's almost impossible to compute the private key from the public one.</html>");
        JBlackLabel jLabelPublicKey = new JBlackLabel("Public key:");
        JBlackLabel jLabelPrivateKey = new JBlackLabel("Private key:");
        final JTextArea jTextAreaPublicKey = new JTextArea();
        jTextAreaPublicKey.setEditable(false);
        jTextAreaPublicKey.setLineWrap(true);
        jTextAreaPublicKey.setRows(5);
        final JTextArea jTextAreaPrivateKey = new JTextArea();
        jTextAreaPrivateKey.setEditable(false);
        jTextAreaPrivateKey.setLineWrap(true);
        jTextAreaPrivateKey.setRows(5);
        final JButton jButtonGenerateKeys = new JButton("Generate keys");
        jButtonGenerateKeys.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String[] keys = LicenseUtil.createKeyPair();
                jTextAreaPublicKey.setText(keys[0]);
                jTextAreaPrivateKey.setText(keys[1]);
                LicenseManager.setPublicKey((String)keys[0]);
                LicenseManager.setPrivateKey((String)keys[1]);
                DemoFrame.this.keysGenerated = true;
                DemoFrame.this.setNavigationButtonsState();
                jButtonGenerateKeys.setEnabled(false);
            }
        });
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Generating keys");
        titledBorder.setTitleColor(Color.black);
        jPanel.setBorder(titledBorder);
        DemoFrame.constrain(jPanel, jLabelIntro, 0, 0, 2, 1, 2, 18, 1.0, 0.0, 0, 5, 5, 5);
        DemoFrame.constrain(jPanel, jLabelPublicKey, 0, 1, 1, 1, 2, 18, 1.0, 0.0, 0, 5, 0, 5);
        DemoFrame.constrain(jPanel, new JScrollPane(jTextAreaPublicKey), 0, 2, 1, 1, 1, 18, 1.0, 1.0, 5, 5, 0, 5);
        DemoFrame.constrain(jPanel, jLabelPrivateKey, 1, 1, 1, 1, 2, 18, 1.0, 0.0, 0, 5, 0, 5);
        DemoFrame.constrain(jPanel, new JScrollPane(jTextAreaPrivateKey), 1, 2, 1, 1, 1, 18, 1.0, 1.0, 5, 5, 0, 5);
        DemoFrame.constrain(jPanel, jButtonGenerateKeys, 0, 3, 2, 1, 0, 12, 1.0, 0.0, 5, 5, 5, 5);
        return jPanel;
    }

    private JPanel getLicensePanel() {
        JBlackLabel jLabelIntro = new JBlackLabel("<html>Here you can create sample license. You can edit the features below and preview/edit the resulting license.</html>");
        JBlackLabel jLabelFeatures = new JBlackLabel("Features:");
        final JTextArea jTextAreaFeatures = new JTextArea("# Here you can define features\n# that will be in the license\n\nCustomer=Customer name\nCompany=Company name\nFeature1=true\nFeature2=false\nExpire=10-10-2007");
        JBlackLabel jLabelLicense = new JBlackLabel("License:");
        final JTextArea jTextAreaLicense = new JTextArea();
        final JBlackLabel jLabelResult = new JBlackLabel("<Validation result>");
        JButton jButtonCreateLicense = new JButton("Create license");
        final JButton jButtonValidateLicense = new JButton("Validate license");
        jButtonValidateLicense.setEnabled(false);
        jButtonCreateLicense.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    String features = jTextAreaFeatures.getText();
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(features.getBytes());
                    License license = LicenseManager.loadLicense((InputStream)inputStream);
                    StringWriter writer = new StringWriter();
                    LicenseManager.saveLicense((License)license, (Writer)writer);
                    writer.close();
                    jTextAreaLicense.setText(writer.toString());
                    jTextAreaLicense.setCaretPosition(0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                jButtonValidateLicense.setEnabled(true);
            }
        });
        jButtonValidateLicense.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                block3: {
                    try {
                        String licenseText = jTextAreaLicense.getText();
                        ByteArrayInputStream inputStream = new ByteArrayInputStream(licenseText.getBytes());
                        License license = LicenseManager.loadLicense((InputStream)inputStream);
                        if (LicenseManager.isValid((License)license)) {
                            jLabelResult.setText("License is valid.");
                            break block3;
                        }
                        jLabelResult.setText("License is not valid.");
                    }
                    catch (Exception exception) {
                        jLabelResult.setText("License is not valid.");
                    }
                }
            }
        });
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Licensing");
        titledBorder.setTitleColor(Color.black);
        jPanel.setBorder(titledBorder);
        DemoFrame.constrain(jPanel, jLabelIntro, 0, 0, 2, 1, 2, 18, 1.0, 0.0, 0, 5, 5, 5);
        DemoFrame.constrain(jPanel, jLabelFeatures, 0, 1, 1, 1, 2, 18, 1.0, 0.0, 0, 5, 0, 5);
        DemoFrame.constrain(jPanel, jLabelLicense, 1, 1, 1, 1, 2, 18, 1.0, 0.0, 0, 0, 0, 5);
        JPanel jPanelTextAreas = new JPanel(new GridLayout(1, 2, 5, 5));
        jPanelTextAreas.add(new JScrollPane(jTextAreaFeatures));
        jPanelTextAreas.add(new JScrollPane(jTextAreaLicense));
        DemoFrame.constrain(jPanel, jPanelTextAreas, 0, 2, 2, 1, 1, 18, 1.0, 1.0, 5, 5, 0, 5);
        JPanel jPanelButtons = new JPanel(new GridLayout(1, 2, 5, 5));
        jPanelButtons.add(jButtonCreateLicense);
        jPanelButtons.add(jButtonValidateLicense);
        DemoFrame.constrain(jPanel, jPanelButtons, 0, 3, 2, 1, 0, 12, 0.0, 0.0, 5, 5, 5, 5);
        DemoFrame.constrain(jPanel, jLabelResult, 0, 4, 2, 1, 0, 12, 0.0, 0.0, 0, 5, 5, 5);
        return jPanel;
    }

    private JPanel getLastPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder("More information");
        titledBorder.setTitleColor(Color.black);
        jPanel.setBorder(titledBorder);
        JBlackLabel jLabel = new JBlackLabel("<html>- More examples can be found at 'samples/console'<br>- Source code of all examples can be found at 'samples/src'<br>- API documentation can be found at 'api'<br><br>If you have any questions or comments, please email license4j@smardec.com</html>");
        JBlackLabel jLabelCopyright = new JBlackLabel("<html>Copyright (C) 2003-2005 Smardec. All rights reserved.<br>http://www.smardec.com</html>");
        DemoFrame.constrain(jPanel, jLabel, 0, 0, 1, 1, 2, 18, 1.0, 1.0, 0, 5, 5, 5);
        DemoFrame.constrain(jPanel, jLabelCopyright, 0, 1, 1, 1, 2, 16, 1.0, 1.0, 5, 5, 5, 5);
        return jPanel;
    }

    private void setNavigationButtonsState() {
        if (this.currentCard == 0) {
            this.jButtonPrevious.setEnabled(false);
        } else {
            this.jButtonPrevious.setEnabled(true);
        }
        if (this.currentCard == 3) {
            this.jButtonNext.setText("Exit");
        } else {
            this.jButtonNext.setText("Next >");
        }
        if (this.currentCard == 1 && !this.keysGenerated) {
            this.jButtonNext.setEnabled(false);
        } else {
            this.jButtonNext.setEnabled(true);
        }
    }

    private static void constrain(Container container, Component component, int x, int y, int width, int height, int fill, int anchor, double weightx, double weighty, int insetTop, int insetLeft, int insetBottom, int insetRight) {
        Insets insets = new Insets(insetTop, insetLeft, insetBottom, insetRight);
        GridBagConstraints gbc = new GridBagConstraints(x, y, width, height, weightx, weighty, anchor, fill, insets, 0, 0);
        LayoutManager lm = container.getLayout();
        GridBagLayout gbl = (GridBagLayout)lm;
        gbl.setConstraints(component, gbc);
        container.add(component);
    }

    private static void centerOnScreen(Component component) {
        if (component == null) {
            return;
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension compSize = component.getSize();
        if (compSize.height > screenSize.height) {
            compSize.height = screenSize.height;
        }
        if (compSize.width > screenSize.width) {
            compSize.width = screenSize.width;
        }
        component.setSize(compSize);
        component.setLocation((screenSize.width - compSize.width) / 2, (screenSize.height - compSize.height) / 2);
    }

    private static class JBlackLabel
    extends JLabel {
        public JBlackLabel(String text) {
            super(text);
        }

        public Color getForeground() {
            return Color.black;
        }
    }
}

