﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

using HiMap.Carto;
using HiMap.MapControls.Tools;
using HiMap.Geometry;


namespace HiMap
{
    /// <summary>
    /// Draw Polygon
    /// </summary>
    public class ToolCreatePolygon : ToolCreatePoint 
    {
        public ToolCreatePolygon (Form frm,IFeatureLayer layer):base(frm,layer)
        {
        }
        protected override void OnToolCreate(HiMap.MapControls.MapControl Map)
        {
            base.OnToolCreate(Map);
            MePic = new PicCtrl(_frm, Map, listPoint, listPoint1, PicType.Polygon);
        }
        protected override void Btn3Click(object sender, EventArgs e)
        {
            if (listPoint.Count < 3)
            {
                System.Windows.Forms.MessageBox.Show("A polygon must have 3 nodes least, continue to draw.");
                return;
            }
            IFeatureClass cls = (IFeatureClass)_layer.Class;
            IFeature feat = null;
            IPointCollection line = new PolygonClass();
            for (int i = 0; i < listPoint.Count; i++)
            {
                feat = cls.CreateFeature();
                line.AddPoint(listPoint[i]);
            }
            feat.Shape = line;
            feat.Save();
            BtnExitClick(null, null);
        }
    }
}
