﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

using HiMap.Carto;
using HiMap.MapControls.Tools;
using HiMap.Geometry;


namespace HiMap
{
    /// <summary>
    /// Tool for create points
    /// </summary>
    public class ToolCreatePoint:ToolClass
    {
        //Picture start location
        protected int StaX, StaY;
        //Picture moved whether or not
        protected bool isMouseDown;
        //Map points collection
        protected List<IPoint> listPoint;

        //Screen points
        protected List<System.Drawing.Point> listPoint1;

        //Picture control class
        protected PicCtrl MePic = null;
        //Selected picturebox control
        protected PictureBox picSd;
        protected IFeatureLayer _layer;
        protected Panel _pl;
        protected Button _bt2;
        protected Button _bt3;
        protected Button _btExit;
        protected Form _frm;
        protected ComboBox _cmb;

        /// <summary>
        /// Initialization create point tool
        /// </summary>
        /// <param name="layer">Layers which need to draw</param>
        public ToolCreatePoint(Form frm, IFeatureLayer layer) 
        {
            _frm=frm;
            _layer = layer;
            this.CreateControls();
            listPoint = new List<IPoint>();
            listPoint1 = new List<System.Drawing.Point>();
            _cmb.Items.Add("All");
            _cmb.SelectedIndex = 0;
            isMouseDown = false;
            picSd = null;
        }

        protected override void OnToolCreate(HiMap.MapControls.MapControl Map)
        {
            base.OnToolCreate(Map);
            MePic = new PicCtrl(_frm, Map, listPoint, listPoint1, PicType.Point);
        }
        /// <summary>
        /// Setup form
        /// </summary>
        protected override void OnMouseDown(object sender, System.Windows.Forms.MouseEventArgs e)
        {
            this.MePic.CreatePic(e.X, e.Y);

            //Save points to cache which will be drawn
            listPoint.Add(this.Map.PointToMapPoint(e.X,e.Y));
            listPoint1.Add(new System.Drawing.Point(e.X, e.Y));
            //Draw points
            this.MePic.Draw();

            //write points into combobox
            this.setCmd();

            if (e.Y + _pl.Height+5 > this.Map.Height)
            {
                _pl.Location = new System.Drawing.Point(_pl.Location.X, e.Y - 5);
            }
            else 
            {
                _pl.Location = new System.Drawing.Point(_pl.Location.X, e.Y + _pl.Height + 5);
            }
            _pl.Visible = true;
        }
        
        //Delete points
        private void Btn2Click(object sender, EventArgs e)
        {
            if (_cmb.SelectedItem.ToString() == "All")
            {
                BtnExitClick(null, null);
            }
            else 
            {   
                MePic.Delete(_cmb.SelectedIndex - 1);
                _cmb.Items.RemoveAt(_cmb.SelectedIndex);
                picSd = null;
                _cmb.SelectedIndex = _cmb.Items.Count-1;
            }
        }

        //Save points
        protected virtual void Btn3Click(object sender, EventArgs e)
        {
            IFeatureClass cls = (IFeatureClass)_layer.Class;
            IFeature feat=null;
            for (int i = 0; i < listPoint.Count; i++) 
            {
                feat = cls.CreateFeature();
                feat.Shape = listPoint[i];
                feat.Save();
            }
            this.Map.MapRefresh();
            _pl.Visible = false;
            BtnExitClick(null, null);
        }

        //Cancel
        protected virtual void BtnExitClick(object sender, EventArgs e)
        {
            listPoint.Clear();
            listPoint1.Clear();
            this.MePic.Clear();
            this.Map.MapRefresh();
            _pl.Visible = false;

            _cmb.Items.Clear();
            _cmb.Items.Add("All");
            _cmb.SelectedIndex = 0;
        }

        private void CmbSelectedIndexChanged(object sender, EventArgs e) 
        {
            if (picSd != null) 
            {
                picSd.BackColor = System.Drawing.Color.Red;
            }
            if (_cmb.SelectedItem.ToString() != "All") 
            {
                MePic[_cmb.SelectedIndex - 1].BackColor = System.Drawing.Color.Blue;
                picSd = MePic[_cmb.SelectedIndex - 1];
            }
        }

        private void setCmd() 
        {
            int index = listPoint1.Count - 1;
            _cmb.Items.Add("Point" + index.ToString());
            _cmb.SelectedIndex = _cmb.Items.Count - 1;
        }

        //Create temp controls
        private void CreateControls() 
        { 
            _pl=new Panel();
            _bt2=new Button();
            _bt3=new Button();
            _btExit=new Button();
            _cmb=new ComboBox();


            _pl.Width = 240;
            _pl.Height = 27;
            _pl.BackColor = System.Drawing.Color.FromArgb(192,192,192);
            _pl.MouseDown += new MouseEventHandler(this.panCtrl_MouseDown);
            _pl.MouseMove += new MouseEventHandler(this.panCtrl_MouseMove);
            _pl.MouseUp += new MouseEventHandler(this.panCtrl_MouseUp);
            _pl.Visible = false;
            _frm.Controls.Add(_pl);
            _frm.Controls.SetChildIndex(_pl, 0);


            
            _cmb.Location = new System.Drawing.Point(3, 3);
            _cmb.Width = 75;
            _cmb.Height = 22;
            _cmb.SelectedIndexChanged += new EventHandler(this.CmbSelectedIndexChanged);
            _pl.Controls.Add(_cmb);

            _bt2.Text = "Delete";
            _bt2.Location = new System.Drawing.Point(84, 3);
            _bt2.Width = 47;
            _bt2.Height = 20;
            _bt2.Click += new EventHandler(this.Btn2Click);
            _pl.Controls.Add(_bt2);


            _bt3.Text = "Save";
            _bt3.Location = new System.Drawing.Point(137, 3);
            _bt3.Width = 47;
            _bt3.Height = 20;
            _bt3.Click += new EventHandler(this.Btn3Click);
            _pl.Controls.Add(_bt3);


            _btExit.Text = "Cancel";
            _btExit.Location = new System.Drawing.Point(190, 3);
            _btExit.Width = 47;
            _btExit.Height = 20;
            _btExit.Click += new EventHandler(this.BtnExitClick);
            _pl.Controls.Add(_btExit);

            
        }

        private void panCtrl_MouseMove(object sender, MouseEventArgs e)
        {
            if (isMouseDown == true)
            {
                this._pl.Location = new System.Drawing.Point(0, this._pl.Location.Y + e.Y - StaY);
            }
        }

        private void panCtrl_MouseDown(object sender, MouseEventArgs e)
        {
            StaX = e.X;
            StaY = e.Y;
            isMouseDown = true;
        }

        private void panCtrl_MouseUp(object sender, MouseEventArgs e)
        {
            isMouseDown = false;
        }
        
        //Clear temp controls when this tool dispose
        protected override void OnToolUpdated(object sender, EventArgs e)
        {
            _frm.Controls.Remove(_bt2);
            _frm.Controls.Remove(_bt3);
            _frm.Controls.Remove(_btExit);
            _frm.Controls.Remove(_cmb);
            _frm.Controls.Remove(_pl);
            BtnExitClick(null, null);
        }
    }
}
