﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using HiMap.Carto;
using HiMap.Driver;
using HiMap.Geometry;
using HiMap.MapControls;
using HiMap.MapControls.Tools;
using HiMap.Style;

namespace HiMap
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            //////////////////////////////////////////////////////////////////////////
            // NOTICE: Setup the UserInterface of HiMap to English language version //
            //////////////////////////////////////////////////////////////////////////
            HiMap.MapControls.Setup.Language = LanguageType.English;

            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
             //Create a new map
            HiMap.Carto.Map map = new HiMap.Carto.Map("testMap");

            //Binding the map to mapControl
            mapControl1.Map = map;
            //Binding the mapControl1 to layerControlForCombox1.Map
            layerControlForCombox1.Map = mapControl1;
        }

        //Add layers
        private void menuItem11_Click(object sender, EventArgs e)
        {
            ICommand cmd = new CommandAddLayer();

            //Initialization
            cmd.OnCreate(this.mapControl1);

            //Execute
            cmd.OnClick();

            //Don' t splite labels to single chars
            for (int i = 0; i < mapControl1.Map.LayerCount; i++)
            {
                IFeatureLayer layer = (IFeatureLayer)mapControl1.Map.GetLayer(i);
                layer.SplitLabel = false; 
            }

        }

        //Previous View
        private void menuItem7_Click(object sender, EventArgs e)
        {
            ICommand cmd = new CommandBeforeView();
            //Initialization
            cmd.OnCreate(this.mapControl1);
            //Execute
            cmd.OnClick();
        }

        //Next View
        private void menuItem8_Click(object sender, EventArgs e)
        {
            ICommand cmd = new CommandAfterView();
            //Initialization

            cmd.OnCreate(this.mapControl1);
            //Execute
            cmd.OnClick();
        }

        //Position point
        private void menuItem9_Click(object sender, EventArgs e)
        {
            ICommand cmd = new CommandGotoXY();
            //Initialization

            cmd.OnCreate(this.mapControl1);
            //Execute
            cmd.OnClick();
        }

        //Information
        private void menuItem10_Click(object sender, EventArgs e)
        {
            ITool cmd = new ToolInfoClass();
            //Initialization

            cmd.OnCreate(this.mapControl1);

            //Make it actived
            this.mapControl1.CurTool = cmd;
        }

        //Full Extent
        private void menuItem6_Click(object sender, EventArgs e)
        {
            ICommand cmd = new CommandFull();

            //Initialization
            cmd.OnCreate(this.mapControl1);

            //Execute
            cmd.OnClick();
        }

        //ZoomIn tool
        private void menuItem3_Click(object sender, EventArgs e)
        {
            ITool cmd = new ToolZoomIn();
            
            //Initialization
            cmd.OnCreate(this.mapControl1);

            //Make it actived
            this.mapControl1.CurTool = cmd;
        }

        //ZoomOut
        private void menuItem4_Click(object sender, EventArgs e)
        {
            ITool cmd = new ToolZoomOut();

            //Initialization
            cmd.OnCreate(this.mapControl1);

            //Make it actived
            this.mapControl1.CurTool = cmd;
        }

        //Pan tool
        private void menuItem5_Click(object sender, EventArgs e)
        {
            ITool cmd = new ToolPan();

            //Initialization
            cmd.OnCreate(this.mapControl1);

            //Make it actived
            this.mapControl1.CurTool = cmd;
        }

        //Define a select tool
        private void menuItem17_Click(object sender, EventArgs e)
        {
            ITool cmd = new ToolSelected(this, (IFeatureLayer)this.layerControlForCombox1.GetLayer());
            cmd.OnCreate(this.mapControl1);
            mapControl1.CurTool = cmd;
        }

        //Draw geometry
        private void menuItem12_Click_1(object sender, EventArgs e)
        {
            IFeatureLayer layer = (IFeatureLayer)this.layerControlForCombox1.GetLayer();
            if (layer == null)
            {
                MessageBox.Show("Please select a layer!");
                return;
            }

            ITool cmd = null;
            switch (layer.GeometryType)
            {
                case GeometryType.Point:
                    cmd = new ToolCreatePoint(this, (IFeatureLayer)this.layerControlForCombox1.GetLayer());
                    break;
                case GeometryType.Polygon:
                    cmd = new ToolCreatePolygon(this, (IFeatureLayer)this.layerControlForCombox1.GetLayer());
                    break;
                case GeometryType.Polyline:
                    cmd = new ToolCreatePolyline(this, (IFeatureLayer)this.layerControlForCombox1.GetLayer());
                    break;
            }
            if (cmd != null)
            {
                cmd.OnCreate(this.mapControl1);
                
                //Make it actived
                this.mapControl1.CurTool = cmd;
            }
            else
            {
                MessageBox.Show("Don't support this type of the layer!");
                return;
            }
        }

        //Delete features
        private void menuItem15_Click(object sender, EventArgs e)
        {
            if (AppInfo.SelectedFeature == null)
            {
                MessageBox.Show("Please select a geometry!");
            }
            else 
            {
                IFeatureClass cls = (IFeatureClass)AppInfo.SelectedFeature.Class;
                cls.DeleteFeature(AppInfo.SelectedFeature);
                AppInfo.SelectedFeature = null;
                mapControl1.MapRefresh();
            }
        }

        //Update the geometry
        private void menuItem13_Click(object sender, EventArgs e)
        {
            if (AppInfo.SelectedFeature == null)
            {
                MessageBox.Show("Please select a geometry!");
            }
            else
            {
                UpdateGeometry uGeo = new UpdateGeometry(this, this.mapControl1);
                uGeo.Show(AppInfo.SelectedFeature);
            }
        }

        //Update the feature property
        private void menuItem14_Click(object sender, EventArgs e)
        {
            if (AppInfo.SelectedFeature == null)
            {
                MessageBox.Show("Please select a geometry!");
            }
            else
            {
                FrmInfo frm = new FrmInfo(AppInfo.SelectedFeature);
                frm.ShowDialog();
                AppInfo.SelectedFeature = null;
                mapControl1.MapRefresh();
            }
        }

        //Setup Layers
        private void menuItem18_Click(object sender, EventArgs e)
        {
            FrmLayers frm = new FrmLayers(mapControl1);
            frm.ShowDialog();
            AppInfo.SelectedFeature = null;
            mapControl1.MapRefresh();
        }

        //Distance Tool
        private void menuItem22_Click(object sender, EventArgs e)
        {
            ITool cmd = new ToolDistance();
            cmd.OnCreate(this.mapControl1);
            this.mapControl1.CurTool = cmd;

        }

        //Remove layers
        private void menuItem23_Click(object sender, EventArgs e)
        {
            FrmLayerList layerList = new FrmLayerList();
            layerList.InitLayers(this.mapControl1);
            layerList.ShowDialog();

            this.mapControl1.MapRefresh();
        }

        private void menuItem25_Click(object sender, EventArgs e)
        {
            openFileDialog1.Filter = "MapDoc files(*.xml)|*.xml|All files(*.*)|*.*";
            openFileDialog1.InitialDirectory = "\\";
            openFileDialog1.ShowDialog();
            if (openFileDialog1.FileName != "")
            {
                this.mapControl1.Open(openFileDialog1.FileName);
                this.mapControl1.MapRefresh();
            }
        }

        private void menuItem26_Click(object sender, EventArgs e)
        {
            saveFileDialog1.Filter = "MapDoc files(*.xml)|*.xml|All files(*.*)|*.*";
            saveFileDialog1.ShowDialog();
            if (saveFileDialog1.FileName != "")
            {
                this.mapControl1.Save(saveFileDialog1.FileName);
                MessageBox.Show("MapDoc file saved!");
            }
        }
    }
}