class Arguments {
	var caller:Object;
	var callee:Object;
	var length:Number;
}

class Object {
	var prototype:Object;
	var constructor:Object;

	function toString():String;
	function toLocaleString():String;
	function valueOf():Object;
	function toSource(object:Object):String;
	function isPrototypeOf(object:Object):Boolean;
	function hasOwnProperty(name:String):Boolean;
	function propertyIsEnumerable(name:String):Boolean;
}

class Function {
	var name:String;
	var arity:Number;
	var length:Number;
	var arguments:Arguments;
	
	function apply(thisObj:Object, args:Array):Object;
	function call(thisObj:Object, ... args):Object;
}

class Math {
	static var E:Number;
	static var LN2:Number;
	static var LOG2E:Number;
	static var PI:Number;
	static var SQRT1_2:Number;
	static var SQRT2:Number;

	static function abs(x:Number):Number;
	static function acos(x:Number):Number;
	static function asin(x:Number):Number;
	static function atan(x:Number):Number;
	static function atan2(y:Number,x:Number):Number;
	static function ceil(x:Number):Number;
	static function cos(x:Number):Number;
	static function exp(x:Number):Number;
	static function floor(x:Number):Number;
	static function log(x:Number):Number;
	static function max(... values):Number;
	static function min(... values):Number;
	static function pow(x:Number,y:Number):Number;
	static function random():Number;
	static function round(x:Number):Number;
	static function sin(x:Number):Number;
	static function sqrt(x:Number):Number;
	static function tan(x:Number):Number;
}

class Array {
	var length:Number;

	function concat(... items):Array;
	function join(delimiter:String):String;
	function pop():Object;
	function push(... items):Number;
	function reverse();
	function shift():Object;
	function slice(startIndex:Number, endIndex:Number):Array;
	function sort(compare:Object, options:Number):Array;
	function splice(startIndex:Number, deleteCount:Number, ... items):Array;
	function unshift(... items):Number;
}

class Boolean {
	function Boolean(value:Object);
}

class Date {
	function Date(year:Number,month:Number,date:Number,hour:Number,min:Number,sec:Number,ms:Number);
	function getDate():Number;
	function getDay():Number;
	function getFullYear():Number;
	function getHours():Number;
	function getMilliseconds():Number;
	function getMinutes():Number;
	function getMonth():Number;
	function getSeconds():Number;
	function getTime():Number;
	function getTimezoneOffset():Number;
	function getYear():Number;
	function getUTCDate():Number;
	function getUTCDay():Number;
	function getUTCFullYear():Number;
	function getUTCHours():Number;
	function getUTCMilliseconds():Number;
	function getUTCMinutes():Number;
	function getUTCMonth():Number;
	function getUTCSeconds():Number;
	function setDate(value:Number);
	function setFullYear(value:Number);
	function setHours(value:Number);
	function setMilliseconds(value:Number);
	function setMinutes(value:Number);
	function setMonth(value:Number);
	function setSeconds(value:Number);
	function setTime(value:Number);
	function setYear(value:Number);
	function setUTCDate(value:Number);
	function setUTCFullYear(value:Number);
	function setUTCHours(value:Number);
	function setUTCMilliseconds(value:Number);
	function setUTCMinutes(value:Number);
	function setUTCMonth(value:Number);
	function setUTCSeconds(value:Number);
	static function UTC(year:Number,month:Number,date:Number,hour:Number,min:Number,sec:Number,ms:Number):Number;
}

class Number {
	static var MAX_VALUE:Number;
	static var MIN_VALUE:Number;
	static var NaN:Number;
	static var NEGATIVE_INFINITY:Number;
	static var POSITIVE_INFINITY:Number;

	function Number(num:Object);
	
	function toPrecision(precision:Number):String;
	function toFixed(fractionDigits:Number):String;
	function toExponential(fractionDigits:Number):String;
}

class String {
	var length:Number;

	static function fromCharCode(... chars):String;

	function String(string:String);
	function charAt(index:Number):String;
	function charCodeAt(index:Number):Number;
	function concat(... strings):String;
	function indexOf(value:String, startIndex:Number):Number;
	function lastIndexOf(value:String, startIndex:Number):Number;
	function slice(index1:Number,index2:Number):String;
	function split(delimiter:String):Array;
	function substring(index1:Number,index2:Number):String;
	function toUpperCase():String;
	function toLowerCase():String;
}

class RegExp {
	function RegExp(pattern:String, flags:String);
	
	var source:String;
	var global:Boolean;
	var ignoreCase:Boolean;
	var multiline:Boolean;
	var lastIndex:Number;
	
	function exec(string:String):Array;
	function test(string:String):Boolean;
}

class Error {
	var name:String;
	var message:String;
	
	function Error(message:String);
}

class EvalError extends Error {
}

class RangeError extends Error {
}

class ReferenceError extends Error {
}

class SyntaxError extends Error {
}

class TypeError extends Error {
}

class URIError extends Error {
}

class Global {
	var NaN:Number;
	var Infinity:Number;
	var undefined:Object;

	function escape(str:String):String;
	function eval(string:String):Object;
	function isFinite(number:Number):Boolean;
	function isNaN(number:Number):Boolean;
	function parseFloat(string:String):Number;
	function parseInt(string:String, radix:Number):Number;
	function unescape(string:String):String;
	function decodeURI(encodedURI:String):String;
	function decodeURIComponent(encodedURI:String):String;
	function encodeURI(uri:String):String;
	function encodeURIComponent(uri:String):String;
}

[Event(nsIDOMWindow, onabort, onblur, onchange, onclick, onclose, ondragdrop, onerror, onfocus, onkeydown, onkeypress, onkeyup, onload, onmousedown, onmousemove, onmouseout, onmouseover, onmouseup, onpaint, onreset, onresize, onscroll, onselect, onsubmit, onunload)]
DOM(nsIDOMWindow) class Window implements
  nsIDOMWindow,
  nsIDOMJSWindow,
  nsIDOMWindowInternal,
  nsIDOMEventTarget,
  nsIDOMViewCSS,
  nsIDOMAbstractView,
  nsIDOMStorageWindow {}

DOM(nsIDOMLocation) class Location implements
  nsIDOMLocation,
  nsIDOMNSLocation {}

DOM(nsIDOMNavigator) class Navigator implements
  nsIDOMNavigator,
  nsIDOMNavigator_MOZILLA_1_8_BRANCH,
  nsIDOMJSNavigator,
  nsIDOMClientInformation {}

DOM(nsIDOMPlugin) class Plugin implements
  nsIDOMPlugin {}

DOM(nsIDOMPluginArray) class PluginArray implements
  nsIDOMPluginArray,
  nsIDOMJSPluginArray {}

DOM(nsIDOMMimeType) class MimeType implements
  nsIDOMMimeType {}

DOM(nsIDOMMimeTypeArray) class MimeTypeArray implements
  nsIDOMMimeTypeArray {}

DOM(nsIDOMBarProp) class BarProp implements
  nsIDOMBarProp {}

DOM(nsIDOMHistory) class History implements
  nsIDOMHistory,
  nsIDOMNSHistory {}

DOM(nsIDOMScreen) class Screen implements
  nsIDOMScreen {}

DOM(nsIDOMConstructor) class Constructor implements
  nsIDOMConstructor {}

DOM(nsIDOMXMLDocument) class XMLDocument implements
  nsIDOMDocument,
  nsIDOMXMLDocument,
  nsIDOMNSDocument, nsIDOMDocumentEvent, nsIDOMDocumentStyle, nsIDOMNSDocumentStyle, nsIDOMDocumentView, nsIDOMDocumentRange, nsIDOMDocumentTraversal, nsIDOMDocumentXBL, nsIDOMEventTarget, nsIDOM3Document, nsIDOM3Node {}

DOM(nsIDOMDocumentType) class DocumentType implements
  nsIDOMDocumentType,
  nsIDOM3Node {}

DOM(nsIDOMDOMImplementation) class DOMImplementation implements
  nsIDOMDOMImplementation {}

DOM(nsIDOMDOMException) class DOMException implements
  nsIDOMDOMException,
  nsIException {}

DOM(nsIDOMDocumentFragment) class DocumentFragment implements
  nsIDOMDocumentFragment,
  nsIDOM3Node {}

[Event(nsIDOMElement, onblur, onchange, onclick, ondblclick, onfocus, onkeydown, onkeypress, onkeyup, onmousedown, onmousemove, onmouseout, onmouseover, onmouseup, onresize)]
DOM(nsIDOMElement) class Element implements
  nsIDOMElement,
  nsIDOMEventTarget,
  nsIDOM3Node {}

DOM(nsIDOMAttr) class Attr implements
  nsIDOMAttr,
  nsIDOM3Node {}

DOM(nsIDOMText) class Text implements
  nsIDOMText,
  nsIDOMEventTarget,
  nsIDOM3Node {}

DOM(nsIDOMComment) class Comment implements
  nsIDOMComment,
  nsIDOMEventTarget,
  nsIDOM3Node {}

DOM(nsIDOMCDATASection) class CDATASection implements
  nsIDOMCDATASection,
  nsIDOMEventTarget,
  nsIDOM3Node {}

DOM(nsIDOMProcessingInstruction) class ProcessingInstruction implements
  nsIDOMProcessingInstruction,
  nsIDOMEventTarget,
  nsIDOM3Node {}

DOM(nsIDOMEntity) class Entity implements
  nsIDOMEntity {}

DOM(nsIDOMEntityReference) class EntityReference implements
  nsIDOMEntityReference {}

DOM(nsIDOMNotation) class Notation implements
  nsIDOMNotation {}

DOM(nsIDOMNodeList) class NodeList implements
  nsIDOMNodeList {}

DOM(nsIDOMNamedNodeMap) class NamedNodeMap implements
  nsIDOMNamedNodeMap {}

DOM(nsIDOMStyleSheetList) class DocumentStyleSheetList implements
  nsIDOMStyleSheetList {}

DOM(nsIDOMEvent) class Event implements
  nsIDOMEvent, nsIDOMNSEvent {}

DOM(nsIDOMPopupBlockedEvent) class PopupBlockedEvent implements
  nsIDOMPopupBlockedEvent,
  nsIDOMEvent, nsIDOMNSEvent {}

DOM(nsIDOMSmartCardEvent) class SmartCardEvent implements
  nsIDOMSmartCardEvent {}

DOM(nsIDOMPageTransitionEvent) class PageTransitionEvent implements
  nsIDOMPageTransitionEvent,
  nsIDOMEvent, nsIDOMNSEvent {}

DOM(nsIDOMMutationEvent) class MutationEvent implements
  nsIDOMMutationEvent,
  nsIDOMEvent, nsIDOMNSEvent {}

DOM(nsIDOMUIEvent) class UIEvent implements
  nsIDOMUIEvent, nsIDOMNSUIEvent, nsIDOMEvent, nsIDOMNSEvent {}

DOM(nsIDOMKeyEvent) class KeyboardEvent implements
  nsIDOMKeyEvent,
  nsIDOMUIEvent, nsIDOMNSUIEvent, nsIDOMEvent, nsIDOMNSEvent {}

DOM(nsIDOMMouseEvent) class MouseEvent implements
  nsIDOMMouseEvent,
  nsIDOMUIEvent, nsIDOMNSUIEvent, nsIDOMEvent, nsIDOMNSEvent {}

DOM(nsIDOMHTMLDocument) class HTMLDocument implements
  nsIDOMHTMLDocument,
  nsIDOMNSHTMLDocument,
  nsIDOMNSDocument, nsIDOMDocumentEvent, nsIDOMDocumentStyle, nsIDOMNSDocumentStyle, nsIDOMDocumentView, nsIDOMDocumentRange, nsIDOMDocumentTraversal, nsIDOMDocumentXBL, nsIDOMEventTarget, nsIDOM3Document, nsIDOM3Node {}

DOM(nsIDOMHTMLCollection) class HTMLCollection implements
  nsIDOMNodeList,
  nsIDOMHTMLCollection {}

DOM(nsIDOMHTMLOptionsCollection) class HTMLOptionsCollection implements
  nsIDOMHTMLOptionsCollection,
  nsIDOMNSHTMLOptionCollection,
  nsIDOMHTMLCollection {}

DOM(nsIDOMHTMLCollection) class HTMLFormControlCollection implements
  nsIDOMHTMLCollection,
  nsIDOMNSHTMLFormControlList {}

DOM(nsIDOMHTMLCollection) class HTMLGenericCollection implements
  nsIDOMHTMLCollection {}

DOM(nsIDOMHTMLAnchorElement) class HTMLAnchorElement implements
  nsIDOMHTMLAnchorElement,
  nsIDOMNSHTMLAnchorElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLAppletElement) class HTMLAppletElement implements
  nsIDOMHTMLAppletElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLAreaElement) class HTMLAreaElement implements
  nsIDOMHTMLAreaElement,
  nsIDOMNSHTMLAreaElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLBRElement) class HTMLBRElement implements
  nsIDOMHTMLBRElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLBaseElement) class HTMLBaseElement implements
  nsIDOMHTMLBaseElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLBaseFontElement) class HTMLBaseFontElement implements
  nsIDOMHTMLBaseFontElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLBodyElement) class HTMLBodyElement implements
  nsIDOMHTMLBodyElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLButtonElement) class HTMLButtonElement implements
  nsIDOMHTMLButtonElement,
  nsIDOMNSHTMLButtonElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLDListElement) class HTMLDListElement implements
  nsIDOMHTMLDListElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLElement) class HTMLDelElement implements
  nsIDOMHTMLModElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLDirectoryElement) class HTMLDirectoryElement implements
  nsIDOMHTMLDirectoryElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLDivElement) class HTMLDivElement implements
  nsIDOMHTMLDivElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLEmbedElement) class HTMLEmbedElement implements
  nsIDOMHTMLEmbedElement,

  nsIDOMGetSVGDocument,

  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLFieldSetElement) class HTMLFieldSetElement implements
  nsIDOMHTMLFieldSetElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLFontElement) class HTMLFontElement implements
  nsIDOMHTMLFontElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLFormElement) class HTMLFormElement implements
  nsIDOMHTMLFormElement,
  nsIDOMNSHTMLFormElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLFrameElement) class HTMLFrameElement implements
  nsIDOMHTMLFrameElement,
  nsIDOMNSHTMLFrameElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLFrameSetElement) class HTMLFrameSetElement implements
  nsIDOMHTMLFrameSetElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLHRElement) class HTMLHRElement implements
  nsIDOMHTMLHRElement,
  nsIDOMNSHTMLHRElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLHeadElement) class HTMLHeadElement implements
  nsIDOMHTMLHeadElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLHeadingElement) class HTMLHeadingElement implements
  nsIDOMHTMLHeadingElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLHtmlElement) class HTMLHtmlElement implements
  nsIDOMHTMLHtmlElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLIFrameElement) class HTMLIFrameElement implements
  nsIDOMHTMLIFrameElement,
  nsIDOMNSHTMLFrameElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLImageElement) class HTMLImageElement implements
  nsIDOMHTMLImageElement,
  nsIDOMNSHTMLImageElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLInputElement) class HTMLInputElement implements
  nsIDOMHTMLInputElement,
  nsIDOMNSHTMLInputElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLElement) class HTMLInsElement implements
  nsIDOMHTMLModElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLIsIndexElement) class HTMLIsIndexElement implements
  nsIDOMHTMLIsIndexElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLLIElement) class HTMLLIElement implements
  nsIDOMHTMLLIElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLLabelElement) class HTMLLabelElement implements
  nsIDOMHTMLLabelElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLLegendElement) class HTMLLegendElement implements
  nsIDOMHTMLLegendElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLLinkElement) class HTMLLinkElement implements
  nsIDOMHTMLLinkElement,
  nsIDOMLinkStyle,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLMapElement) class HTMLMapElement implements
  nsIDOMHTMLMapElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLMenuElement) class HTMLMenuElement implements
  nsIDOMHTMLMenuElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLMetaElement) class HTMLMetaElement implements
  nsIDOMHTMLMetaElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLModElement) class HTMLModElement implements
  nsIDOMHTMLModElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLOListElement) class HTMLOListElement implements
  nsIDOMHTMLOListElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLObjectElement) class HTMLObjectElement implements
  nsIDOMHTMLObjectElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLOptGroupElement) class HTMLOptGroupElement implements
  nsIDOMHTMLOptGroupElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLOptionElement) class HTMLOptionElement implements
  nsIDOMNSHTMLOptionElement,
  nsIDOMHTMLOptionElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLParagraphElement) class HTMLParagraphElement implements
  nsIDOMHTMLParagraphElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLParamElement) class HTMLParamElement implements
  nsIDOMHTMLParamElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLPreElement) class HTMLPreElement implements
  nsIDOMHTMLPreElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLQuoteElement) class HTMLQuoteElement implements
  nsIDOMHTMLQuoteElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLScriptElement) class HTMLScriptElement implements
  nsIDOMHTMLScriptElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLSelectElement) class HTMLSelectElement implements
  nsIDOMHTMLSelectElement,
  nsIDOMNSHTMLSelectElement,
  nsIDOMNSXBLFormControl,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLElement) class HTMLSpacerElement implements
  nsIDOMHTMLElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLElement) class HTMLSpanElement implements
  nsIDOMHTMLElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLStyleElement) class HTMLStyleElement implements
  nsIDOMHTMLStyleElement,
  nsIDOMLinkStyle,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLTableCaptionElement) class HTMLTableCaptionElement implements
  nsIDOMHTMLTableCaptionElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLTableCellElement) class HTMLTableCellElement implements
  nsIDOMHTMLTableCellElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLTableColElement) class HTMLTableColElement implements
  nsIDOMHTMLTableColElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLTableColElement) class HTMLTableColGroupElement implements
  nsIDOMHTMLTableColElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLTableElement) class HTMLTableElement implements
  nsIDOMHTMLTableElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLTableRowElement) class HTMLTableRowElement implements
  nsIDOMHTMLTableRowElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLTableSectionElement) class HTMLTableSectionElement implements
  nsIDOMHTMLTableSectionElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLTextAreaElement) class HTMLTextAreaElement implements
  nsIDOMHTMLTextAreaElement,
  nsIDOMNSHTMLTextAreaElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLTitleElement) class HTMLTitleElement implements
  nsIDOMHTMLTitleElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLUListElement) class HTMLUListElement implements
  nsIDOMHTMLUListElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLElement) class HTMLUnknownElement implements
  nsIDOMHTMLElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMHTMLElement) class HTMLWBRElement implements
  nsIDOMHTMLElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMCSSStyleRule) class CSSStyleRule implements
  nsIDOMCSSStyleRule {}

DOM(nsIDOMCSSCharsetRule) class CSSCharsetRule implements
  nsIDOMCSSCharsetRule {}

DOM(nsIDOMCSSImportRule) class CSSImportRule implements
  nsIDOMCSSImportRule {}

DOM(nsIDOMCSSMediaRule) class CSSMediaRule implements
  nsIDOMCSSMediaRule {}

DOM(nsIDOMCSSRule) class CSSNameSpaceRule implements
  nsIDOMCSSRule {}

DOM(nsIDOMCSSRuleList) class CSSRuleList implements
  nsIDOMCSSRuleList {}

DOM(nsIDOMCSSRuleList) class CSSGroupRuleRuleList implements
  nsIDOMCSSRuleList {}

DOM(nsIDOMMediaList) class MediaList implements
  nsIDOMMediaList {}

DOM(nsIDOMStyleSheetList) class StyleSheetList implements
  nsIDOMStyleSheetList {}

DOM(nsIDOMCSSStyleSheet) class CSSStyleSheet implements
  nsIDOMCSSStyleSheet {}

DOM(nsIDOMCSSStyleDeclaration) class CSSStyleDeclaration implements
  nsIDOMCSSStyleDeclaration,
  nsIDOMCSS2Properties,
  nsIDOMNSCSS2Properties {}

DOM(nsIDOMCSSStyleDeclaration) class ComputedCSSStyleDeclaration implements
  nsIDOMCSSStyleDeclaration,
  nsIDOMCSS2Properties,
  nsIDOMNSCSS2Properties {}

DOM(nsIDOMCSSPrimitiveValue) class ROCSSPrimitiveValue implements
  nsIDOMCSSPrimitiveValue {}

DOM(nsIDOMCSSValueList) class CSSValueList implements
  nsIDOMCSSValueList {}

DOM(nsIDOMRect) class CSSRect implements
  nsIDOMRect {}

DOM(nsIDOMRGBColor) class CSSRGBColor implements
  nsIDOMRGBColor {}

DOM(nsIDOMRange) class Range implements
  nsIDOMRange,
  nsIDOMNSRange {}

DOM(nsIDOMTreeWalker) class TreeWalker implements
  nsIDOMTreeWalker {}

DOM(nsISelection) class Selection implements
  nsISelection {}

DOM(nsIDOMXULDocument) class XULDocument implements
  nsIDOMDocument,
  nsIDOMXULDocument,
  nsIDOMXULDocument_MOZILLA_1_8_BRANCH,
  nsIDOMNSDocument, nsIDOMDocumentEvent, nsIDOMDocumentStyle, nsIDOMNSDocumentStyle, nsIDOMDocumentView, nsIDOMDocumentRange, nsIDOMDocumentTraversal, nsIDOMDocumentXBL, nsIDOMEventTarget, nsIDOM3Document, nsIDOM3Node {}

DOM(nsIDOMXULElement) class XULElement implements
  nsIDOMXULElement,
  nsIDOMEventTarget,
  nsIDOM3Node {}

DOM(nsIDOMXULCommandDispatcher) class XULCommandDispatcher implements
  nsIDOMXULCommandDispatcher {}

DOM(nsIDOMNodeList) class XULNodeList implements
  nsIDOMNodeList {}

DOM(nsIDOMNamedNodeMap) class XULNamedNodeMap implements
  nsIDOMNamedNodeMap {}

DOM(nsIDOMAttr) class XULAttr implements
  nsIDOMAttr {}

DOM(nsIControllers) class XULControllers implements
  nsIControllers {}

DOM(nsIBoxObject) class BoxObject implements
  nsIBoxObject {}

DOM(nsITreeSelection) class TreeSelection implements
  nsITreeSelection {}

DOM(nsITreeContentView) class TreeContentView implements
  nsITreeContentView,
  nsITreeView {}

DOM(nsIDOMCrypto) class Crypto implements
  nsIDOMCrypto {}

DOM(nsIDOMCRMFObject) class CRMFObject implements
  nsIDOMCRMFObject {}

DOM(nsIDOMPkcs11) class Pkcs11 implements
  nsIDOMPkcs11 {}

DOM(nsIDOMProcessingInstruction) class XMLStylesheetProcessingInstruction implements
  nsIDOMProcessingInstruction,
  nsIDOMLinkStyle,
  nsIDOMEventTarget,
  nsIDOM3Node {}

DOM(nsIDOMWindow) class ChromeWindow implements
  nsIDOMWindow,
  nsIDOMJSWindow,
  nsIDOMWindowInternal,
  nsIDOMChromeWindow,
  nsIDOMEventTarget,
  nsIDOMViewCSS,
  nsIDOMAbstractView {}

DOM(nsIDOMRangeException) class RangeException implements
  nsIDOMRangeException,
  nsIException {}

DOM(nsIDOMHTMLCollection) class ContentList implements
  nsIDOMNodeList,
  nsIDOMHTMLCollection {}

DOM(nsIImageDocument) class ImageDocument implements
  nsIDOMHTMLDocument,
  nsIImageDocument,
  nsIDOMNSHTMLDocument,
  nsIDOMNSDocument, nsIDOMDocumentEvent, nsIDOMDocumentStyle, nsIDOMNSDocumentStyle, nsIDOMDocumentView, nsIDOMDocumentRange, nsIDOMDocumentTraversal, nsIDOMDocumentXBL, nsIDOMEventTarget, nsIDOM3Document, nsIDOM3Node {}

DOM(nsIXULTemplateBuilder) class XULTemplateBuilder implements
  nsIXULTemplateBuilder {}

DOM(nsIXULTreeBuilder) class XULTreeBuilder implements
  nsIXULTreeBuilder,
  nsITreeView {}

DOM(nsIDOMDOMStringList) class DOMStringList implements
  nsIDOMDOMStringList {}

DOM(nsIDOMNameList) class NameList implements
  nsIDOMNameList {}

DOM(nsITreeColumn) class TreeColumn implements
  nsITreeColumn {}

DOM(nsITreeColumns) class TreeColumns implements
  nsITreeColumns {}

DOM(nsIDOMCSSMozDocumentRule) class CSSMozDocumentRule implements
  nsIDOMCSSMozDocumentRule {}

DOM(nsIDOMBeforeUnloadEvent) class BeforeUnloadEvent implements
  nsIDOMBeforeUnloadEvent,
  nsIDOMEvent, nsIDOMNSEvent {}

DOM(nsIDOMSVGDocument) class SVGDocument implements
  nsIDOMSVGDocument,
  nsIDOMDocument,
  nsIDOMNSDocument, nsIDOMDocumentEvent, nsIDOMDocumentStyle, nsIDOMNSDocumentStyle, nsIDOMDocumentView, nsIDOMDocumentRange, nsIDOMDocumentTraversal, nsIDOMDocumentXBL, nsIDOMEventTarget, nsIDOM3Document, nsIDOM3Node {}

DOM(nsIDOMSVGCircleElement) class SVGCircleElement implements
  nsIDOMSVGCircleElement,
  nsIDOMEventTarget, nsIDOMSVGLocatable, nsIDOMSVGTransformable, nsIDOMSVGStylable, nsIDOMSVGElement, nsIDOM3Node {}

DOM(nsIDOMSVGClipPathElement) class SVGClipPathElement implements
  nsIDOMSVGClipPathElement,
  nsIDOMSVGLocatable,
  nsIDOMSVGTransformable,
  nsIDOMSVGStylable,
  nsIDOMSVGElement, nsIDOM3Node {}

DOM(nsIDOMSVGDefsElement) class SVGDefsElement implements
  nsIDOMSVGDefsElement,
  nsIDOMEventTarget, nsIDOMSVGLocatable, nsIDOMSVGTransformable, nsIDOMSVGStylable, nsIDOMSVGElement, nsIDOM3Node {}

DOM(nsIDOMSVGDescElement) class SVGDescElement implements
  nsIDOMSVGDescElement,
  nsIDOMSVGStylable,
  nsIDOMSVGElement, nsIDOM3Node {}

DOM(nsIDOMSVGEllipseElement) class SVGEllipseElement implements
  nsIDOMSVGEllipseElement,
  nsIDOMEventTarget, nsIDOMSVGLocatable, nsIDOMSVGTransformable, nsIDOMSVGStylable, nsIDOMSVGElement, nsIDOM3Node {}

DOM(nsIDOMSVGGElement) class SVGGElement implements
  nsIDOMSVGGElement,
  nsIDOMEventTarget, nsIDOMSVGLocatable, nsIDOMSVGTransformable, nsIDOMSVGStylable, nsIDOMSVGElement, nsIDOM3Node {}

DOM(nsIDOMSVGGradientElement) class SVGGradientElement implements
  nsIDOMSVGGradientElement,
  nsIDOMSVGURIReference,
  nsIDOMSVGStylable,
  nsIDOMSVGElement, nsIDOM3Node {}

DOM(nsIDOMSVGImageElement) class SVGImageElement implements
  nsIDOMSVGImageElement,
  nsIDOMSVGURIReference,
  nsIDOMEventTarget, nsIDOMSVGLocatable, nsIDOMSVGTransformable, nsIDOMSVGStylable, nsIDOMSVGElement, nsIDOM3Node {}

DOM(nsIDOMSVGLinearGradientElement) class SVGLinearGradientElement implements
  nsIDOMSVGGradientElement,
  nsIDOMSVGLinearGradientElement,
  nsIDOMSVGURIReference,
  nsIDOMSVGStylable,
  nsIDOMSVGElement, nsIDOM3Node {}

DOM(nsIDOMSVGLineElement) class SVGLineElement implements
  nsIDOMSVGLineElement,
  nsIDOMEventTarget, nsIDOMSVGLocatable, nsIDOMSVGTransformable, nsIDOMSVGStylable, nsIDOMSVGElement, nsIDOM3Node {}

DOM(nsIDOMSVGMarkerElement) class SVGMarkerElement implements
  nsIDOMSVGMarkerElement,
  nsIDOMSVGStylable,
  nsIDOMSVGFitToViewBox,
  nsIDOMSVGElement, nsIDOM3Node {}

DOM(nsIDOMSVGMetadataElement) class SVGMetadataElement implements
  nsIDOMSVGMetadataElement,
  nsIDOMSVGElement, nsIDOM3Node {}

DOM(nsIDOMSVGPathElement) class SVGPathElement implements
  nsIDOMSVGPathElement,
  nsIDOMSVGAnimatedPathData,
  nsIDOMEventTarget, nsIDOMSVGLocatable, nsIDOMSVGTransformable, nsIDOMSVGStylable, nsIDOMSVGElement, nsIDOM3Node {}

DOM(nsIDOMSVGPolygonElement) class SVGPolygonElement implements
  nsIDOMSVGPolygonElement,
  nsIDOMSVGAnimatedPoints,
  nsIDOMEventTarget, nsIDOMSVGLocatable, nsIDOMSVGTransformable, nsIDOMSVGStylable, nsIDOMSVGElement, nsIDOM3Node {}

DOM(nsIDOMSVGPolylineElement) class SVGPolylineElement implements
  nsIDOMSVGPolylineElement,
  nsIDOMSVGAnimatedPoints,
  nsIDOMEventTarget, nsIDOMSVGLocatable, nsIDOMSVGTransformable, nsIDOMSVGStylable, nsIDOMSVGElement, nsIDOM3Node {}

DOM(nsIDOMSVGRadialGradientElement) class SVGRadialGradientElement implements
  nsIDOMSVGGradientElement,
  nsIDOMSVGRadialGradientElement,
  nsIDOMSVGURIReference,
  nsIDOMSVGStylable,
  nsIDOMSVGElement, nsIDOM3Node {}

DOM(nsIDOMSVGRectElement) class SVGRectElement implements
  nsIDOMSVGRectElement,
  nsIDOMEventTarget, nsIDOMSVGLocatable, nsIDOMSVGTransformable, nsIDOMSVGStylable, nsIDOMSVGElement, nsIDOM3Node {}

DOM(nsIDOMSVGScriptElement) class SVGScriptElement implements
  nsIDOMSVGScriptElement,
  nsIDOMSVGURIReference,
  nsIDOMSVGElement, nsIDOM3Node {}

DOM(nsIDOMSVGStopElement) class SVGStopElement implements
  nsIDOMSVGStopElement,
  nsIDOMSVGStylable,
  nsIDOMSVGElement, nsIDOM3Node {}

DOM(nsIDOMSVGStyleElement) class SVGStyleElement implements
  nsIDOMSVGStyleElement,
  nsIDOMLinkStyle,
  nsIDOMSVGElement, nsIDOM3Node {}

DOM(nsIDOMSVGSVGElement) class SVGSVGElement implements
  nsIDOMEventTarget,
  nsIDOMSVGSVGElement,
  nsIDOMSVGFitToViewBox,
  nsIDOMSVGLocatable,
  nsIDOMSVGStylable,
  nsIDOMSVGZoomAndPan,
  nsIDOMSVGElement, nsIDOM3Node {}

DOM(nsIDOMSVGSymbolElement) class SVGSymbolElement implements
  nsIDOMEventTarget,
  nsIDOMSVGSymbolElement,
  nsIDOMSVGFitToViewBox,
  nsIDOMSVGStylable,
  nsIDOMSVGElement, nsIDOM3Node {}

DOM(nsIDOMSVGTextElement) class SVGTextElement implements
  nsIDOMSVGTextPositioningElement,
  nsIDOMSVGTextContentElement,
  nsIDOMEventTarget, nsIDOMSVGLocatable, nsIDOMSVGTransformable, nsIDOMSVGStylable, nsIDOMSVGElement, nsIDOM3Node {}

DOM(nsIDOMSVGTitleElement) class SVGTitleElement implements
  nsIDOMSVGTitleElement,
  nsIDOMSVGStylable,
  nsIDOMSVGElement, nsIDOM3Node {}

DOM(nsIDOMSVGTSpanElement) class SVGTSpanElement implements
  nsIDOMSVGTextPositioningElement,
  nsIDOMSVGTextContentElement,
  nsIDOMEventTarget,
  nsIDOMSVGStylable,
  nsIDOMSVGElement, nsIDOM3Node {}

DOM(nsIDOMSVGUseElement) class SVGUseElement implements
  nsIDOMSVGUseElement,
  nsIDOMSVGURIReference,
  nsIDOMEventTarget, nsIDOMSVGLocatable, nsIDOMSVGTransformable, nsIDOMSVGStylable, nsIDOMSVGElement, nsIDOM3Node {}

DOM(nsIDOMSVGAngle) class SVGAngle implements
  nsIDOMSVGAngle {}

DOM(nsIDOMSVGAnimatedAngle) class SVGAnimatedAngle implements
  nsIDOMSVGAnimatedAngle {}

DOM(nsIDOMSVGAnimatedEnumeration) class SVGAnimatedEnumeration implements
  nsIDOMSVGAnimatedEnumeration {}

DOM(nsIDOMSVGAnimatedLength) class SVGAnimatedLength implements
  nsIDOMSVGAnimatedLength {}

DOM(nsIDOMSVGAnimatedLengthList) class SVGAnimatedLengthList implements
  nsIDOMSVGAnimatedLengthList {}

DOM(nsIDOMSVGAnimatedNumber) class SVGAnimatedNumber implements
  nsIDOMSVGAnimatedNumber {}

DOM(nsIDOMSVGAnimatedNumberList) class SVGAnimatedNumberList implements
  nsIDOMSVGAnimatedNumberList {}

DOM(nsIDOMSVGAnimatedPoints) class SVGAnimatedPoints implements
  nsIDOMSVGAnimatedPoints {}

DOM(nsIDOMSVGAnimatedPreserveAspectRatio) class SVGAnimatedPreserveAspectRatio implements
  nsIDOMSVGAnimatedPreserveAspectRatio {}

DOM(nsIDOMSVGAnimatedRect) class SVGAnimatedRect implements
  nsIDOMSVGAnimatedRect {}

DOM(nsIDOMSVGAnimatedString) class SVGAnimatedString implements
  nsIDOMSVGAnimatedString {}

DOM(nsIDOMSVGAnimatedTransformList) class SVGAnimatedTransformList implements
  nsIDOMSVGAnimatedTransformList {}

DOM(nsIDOMSVGEvent) class SVGEvent implements
  nsIDOMSVGEvent,
  nsIDOMEvent, nsIDOMNSEvent {}

DOM(nsIDOMSVGException) class SVGException implements
  nsIDOMSVGException,
  nsIException {}

DOM(nsIDOMSVGLength) class SVGLength implements
  nsIDOMSVGLength {}

DOM(nsIDOMSVGLengthList) class SVGLengthList implements
  nsIDOMSVGLengthList {}

DOM(nsIDOMSVGMatrix) class SVGMatrix implements
  nsIDOMSVGMatrix {}

DOM(nsIDOMSVGNumber) class SVGNumber implements
  nsIDOMSVGNumber {}

DOM(nsIDOMSVGNumberList) class SVGNumberList implements
  nsIDOMSVGNumberList {}

DOM(nsIDOMSVGPathSegArcAbs) class SVGPathSegArcAbs implements
  nsIDOMSVGPathSegArcAbs {}

DOM(nsIDOMSVGPathSegArcRel) class SVGPathSegArcRel implements
  nsIDOMSVGPathSegArcRel {}

DOM(nsIDOMSVGPathSegClosePath) class SVGPathSegClosePath implements
  nsIDOMSVGPathSegClosePath {}

DOM(nsIDOMSVGPathSegCurvetoCubicAbs) class SVGPathSegCurvetoCubicAbs implements
  nsIDOMSVGPathSegCurvetoCubicAbs {}

DOM(nsIDOMSVGPathSegCurvetoCubicRel) class SVGPathSegCurvetoCubicRel implements
  nsIDOMSVGPathSegCurvetoCubicRel {}

DOM(nsIDOMSVGPathSegCurvetoCubicSmoothAbs) class SVGPathSegCurvetoCubicSmoothAbs implements
  nsIDOMSVGPathSegCurvetoCubicSmoothAbs {}

DOM(nsIDOMSVGPathSegCurvetoCubicSmoothRel) class SVGPathSegCurvetoCubicSmoothRel implements
  nsIDOMSVGPathSegCurvetoCubicSmoothRel {}

DOM(nsIDOMSVGPathSegCurvetoQuadraticAbs) class SVGPathSegCurvetoQuadraticAbs implements
  nsIDOMSVGPathSegCurvetoQuadraticAbs {}

DOM(nsIDOMSVGPathSegCurvetoQuadraticRel) class SVGPathSegCurvetoQuadraticRel implements
  nsIDOMSVGPathSegCurvetoQuadraticRel {}

DOM(nsIDOMSVGPathSegCurvetoQuadraticSmoothAbs) class SVGPathSegCurvetoQuadraticSmoothAbs implements
  nsIDOMSVGPathSegCurvetoQuadraticSmoothAbs {}

DOM(nsIDOMSVGPathSegCurvetoQuadraticSmoothRel) class SVGPathSegCurvetoQuadraticSmoothRel implements
  nsIDOMSVGPathSegCurvetoQuadraticSmoothRel {}

DOM(nsIDOMSVGPathSegLinetoAbs) class SVGPathSegLinetoAbs implements
  nsIDOMSVGPathSegLinetoAbs {}

DOM(nsIDOMSVGPathSegLinetoHorizontalAbs) class SVGPathSegLinetoHorizontalAbs implements
  nsIDOMSVGPathSegLinetoHorizontalAbs {}

DOM(nsIDOMSVGPathSegLinetoHorizontalRel) class SVGPathSegLinetoHorizontalRel implements
  nsIDOMSVGPathSegLinetoHorizontalRel {}

DOM(nsIDOMSVGPathSegLinetoRel) class SVGPathSegLinetoRel implements
  nsIDOMSVGPathSegLinetoRel {}

DOM(nsIDOMSVGPathSegLinetoVerticalAbs) class SVGPathSegLinetoVerticalAbs implements
  nsIDOMSVGPathSegLinetoVerticalAbs {}

DOM(nsIDOMSVGPathSegLinetoVerticalRel) class SVGPathSegLinetoVerticalRel implements
  nsIDOMSVGPathSegLinetoVerticalRel {}

DOM(nsIDOMSVGPathSegList) class SVGPathSegList implements
  nsIDOMSVGPathSegList {}

DOM(nsIDOMSVGPathSegMovetoAbs) class SVGPathSegMovetoAbs implements
  nsIDOMSVGPathSegMovetoAbs {}

DOM(nsIDOMSVGPathSegMovetoRel) class SVGPathSegMovetoRel implements
  nsIDOMSVGPathSegMovetoRel {}

DOM(nsIDOMSVGPoint) class SVGPoint implements
  nsIDOMSVGPoint {}

DOM(nsIDOMSVGPointList) class SVGPointList implements
  nsIDOMSVGPointList {}

DOM(nsIDOMSVGPreserveAspectRatio) class SVGPreserveAspectRatio implements
  nsIDOMSVGPreserveAspectRatio {}

DOM(nsIDOMSVGRect) class SVGRect implements
  nsIDOMSVGRect {}

DOM(nsIDOMSVGTransform) class SVGTransform implements
  nsIDOMSVGTransform {}

DOM(nsIDOMSVGTransformList) class SVGTransformList implements
  nsIDOMSVGTransformList {}

DOM(nsIDOMSVGZoomEvent) class SVGZoomEvent implements
  nsIDOMSVGZoomEvent,
  nsIDOMEvent, nsIDOMNSEvent {}

DOM(nsIDOMHTMLCanvasElement) class HTMLCanvasElement implements
  nsIDOMHTMLCanvasElement,
  nsIDOMNSHTMLElement, nsIDOMElementCSSInlineStyle, nsIDOMEventTarget, nsIDOM3Node {}

DOM(nsIDOMCanvasRenderingContext2D) class CanvasRenderingContext2D implements
  nsIDOMCanvasRenderingContext2D {}

DOM(nsIDOMCanvasGradient) class CanvasGradient implements
  nsIDOMCanvasGradient {}

DOM(nsIDOMCanvasPattern) class CanvasPattern implements
  nsIDOMCanvasPattern {}

DOM(nsIDOMSVGTextPathElement) class SVGTextPathElement implements
  nsIDOMSVGTextContentElement,
  nsIDOMSVGURIReference,
  nsIDOMEventTarget,
  nsIDOMSVGStylable,
  nsIDOMSVGElement, nsIDOM3Node {}

DOM(nsIDOMParser) class DOMParser implements
  nsIDOMParser {}

DOM(nsIDOMSerializer) class XMLSerializer implements
  nsIDOMSerializer {}

DOM(nsIXMLHttpRequest) class XMLHttpRequest implements
  nsIXMLHttpRequest,
  nsIJSXMLHttpRequest,
  nsIDOMEventTarget,
  nsIInterfaceRequestor {}

DOM(nsIDOMEvent) class XMLHttpProgressEvent implements
  nsIDOMEvent,
  nsIDOMLSProgressEvent {}

DOM(nsIDOMSVGForeignObjectElement) class SVGForeignObjectElement implements
  nsIDOMSVGForeignObjectElement,
  nsIDOMEventTarget, nsIDOMSVGLocatable, nsIDOMSVGTransformable, nsIDOMSVGStylable, nsIDOMSVGElement, nsIDOM3Node {}

//check this
DOM(nsIDOMDocument) class Document {}
DOM(nsIDOMDocumentView) class DocumentView {}
DOM(nsIDOMCSSFontFaceRule) class CSSFontFaceRule {}
DOM(nsIDOMCSSPageRule) class CSSPageRule {}
DOM(nsIDOMCSSPrimitiveValue) class CSSPrimitiveValue {}
DOM(nsIDOMCSSRule) class CSSRule {}
DOM(nsIDOMCSSUnknownRule) class CSSUnknownRule {}
DOM(nsIDOMCSSValue) class CSSValue {}
DOM(nsIDOMStyleSheet) class StyleSheet {}
DOM(nsIDOMViewCSS) class ViewCSS {}
DOM(nsISOAPCall) class SOAPCall {}
DOM(nsISOAPEncoding) class SOAPEncoding {}
DOM(nsISOAPFault) class SOAPFault {}
DOM(nsISOAPHeaderBlock) class SOAPHeaderBlock {}
DOM(nsISOAPParameter) class SOAPParameter {}
DOM(nsISOAPPropertyBagMutator) class SOAPPropertyBagMutator {}
DOM(nsISOAPResponse) class SOAPResponse {}
DOM(nsIWebServiceProxyFactory) class WebServiceProxyFactory {}
DOM(nsIWSDLLoader) class WSDLLoader {}
DOM(nsIDOMParser) class DOMParser {}
DOM(nsISchemaLoader) class SchemaLoader {}
DOM(nsIDOMSerializer) class XMLSerializer {}
DOM(nsIDOMXPathEvaluator) class XPathEvaluator {}
DOM(nsIDOMXPathNSResolver) class XPathNSResolver {}
DOM(nsIDOMXPathResult) class XPathResult {}
DOM(nsIXPointerResult) class XPointerResult {}
DOM(nsIXSLTProcessor) class XSLTProcessor {}

DOM(nsIDOMNode) class Node implements
	nsIDOMNode,
	nsIDOM3Node,
	nsIDOMEventTarget {}

DOM(nsIDOMXPathException) class XPathException implements
	nsIDOMXPathException,
	nsIException {}

DOM(nsIXMLHttpRequest) class XMLHttpRequest implements
	nsIXMLHttpRequest,
	nsIJSXMLHttpRequest,
	nsIDOMEventTarget,
	nsIInterfaceRequestor {}

DOM(nsIDOMCSS2Properties) class CSS2Properties implements
	nsIDOMCSS2Properties,
	nsIDOMNSCSS2Properties {}

DOM(nsIDOMXPathExpression) class XPathExpression implements
	nsIDOMXPathExpression,
	nsIDOMNSXPathExpression {}

DOM(nsIDOMHTMLElement) class HTMLElement implements
	nsIDOMHTMLElement,
	nsIDOMNSHTMLElement,
	nsIDOMElementCSSInlineStyle,
  nsIDOMEventTarget,
  nsIDOM3Node {}
