/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.text.html;

import com.spket.ui.internal.UIMessages;
import com.spket.ui.text.html.SubstitutionTextReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.custom.StyleRange;

public class HTML2TextReader
extends SubstitutionTextReader {
    private static final String EMPTY_STRING = "";
    private static final Map fgEntityLookup;
    private static final Set fgTags;
    private int fCounter = 0;
    private TextPresentation fTextPresentation;
    private int fBold = 0;
    private int fStartOffset = -1;
    private boolean fInParagraph = false;
    private boolean fIsPreformattedText = false;
    private boolean fIgnore = false;
    private boolean fHeaderDetected = false;

    public HTML2TextReader(Reader reader, TextPresentation textPresentation) {
        super(new PushbackReader(reader));
        this.fTextPresentation = textPresentation;
    }

    public int read() throws IOException {
        int n = super.read();
        if (n != -1) {
            ++this.fCounter;
        }
        return n;
    }

    protected void startBold() {
        if (this.fBold == 0) {
            this.fStartOffset = this.fCounter;
        }
        ++this.fBold;
    }

    protected void startPreformattedText() {
        this.fIsPreformattedText = true;
        this.setSkipWhitespace(false);
    }

    protected void stopPreformattedText() {
        this.fIsPreformattedText = false;
        this.setSkipWhitespace(true);
    }

    protected void stopBold() {
        --this.fBold;
        if (this.fBold == 0) {
            if (this.fTextPresentation != null) {
                this.fTextPresentation.addStyleRange(new StyleRange(this.fStartOffset, this.fCounter - this.fStartOffset, null, null, 1));
            }
            this.fStartOffset = -1;
        }
    }

    protected String computeSubstitution(int n) throws IOException {
        if (n == 60) {
            return this.processHTMLTag();
        }
        if (this.fIgnore) {
            return EMPTY_STRING;
        }
        if (n == 38) {
            return this.processEntity();
        }
        if (this.fIsPreformattedText) {
            return this.processPreformattedText(n);
        }
        return null;
    }

    private String html2Text(String string) {
        if (string == null || string.length() == 0) {
            return EMPTY_STRING;
        }
        String string2 = string = string.toLowerCase();
        if ('/' == string2.charAt(0)) {
            string2 = string2.substring(1);
        }
        if (!fgTags.contains(string2)) {
            return EMPTY_STRING;
        }
        if ("pre".equals(string)) {
            this.startPreformattedText();
            return EMPTY_STRING;
        }
        if ("/pre".equals(string)) {
            this.stopPreformattedText();
            return EMPTY_STRING;
        }
        if (this.fIsPreformattedText) {
            return EMPTY_STRING;
        }
        if ("b".equals(string)) {
            this.startBold();
            return EMPTY_STRING;
        }
        if (string.length() > 1 && string.charAt(0) == 'h' && Character.isDigit(string.charAt(1)) || "dt".equals(string)) {
            this.startBold();
            return EMPTY_STRING;
        }
        if ("dl".equals(string)) {
            return LINE_DELIM;
        }
        if ("dd".equals(string)) {
            return "\t";
        }
        if ("li".equals(string)) {
            return LINE_DELIM + UIMessages.HTML2TextReader_listItemPrefix;
        }
        if ("/b".equals(string)) {
            this.stopBold();
            return EMPTY_STRING;
        }
        if ("p".equals(string)) {
            this.fInParagraph = true;
            return LINE_DELIM;
        }
        if ("br".equals(string) || "br/".equals(string) || "div".equals(string)) {
            return LINE_DELIM;
        }
        if ("/p".equals(string)) {
            boolean bl = this.fInParagraph;
            this.fInParagraph = false;
            return bl ? EMPTY_STRING : LINE_DELIM;
        }
        if (string.startsWith("/h") && string.length() > 2 && Character.isDigit(string.charAt(2)) || "/dt".equals(string)) {
            this.stopBold();
            return LINE_DELIM;
        }
        if ("/dd".equals(string)) {
            return LINE_DELIM;
        }
        if ("head".equals(string) && !this.fHeaderDetected) {
            this.fHeaderDetected = true;
            this.fIgnore = true;
            return EMPTY_STRING;
        }
        if ("/head".equals(string) && this.fHeaderDetected && this.fIgnore) {
            this.fIgnore = false;
            return EMPTY_STRING;
        }
        return EMPTY_STRING;
    }

    private String processHTMLTag() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n = this.nextChar();
            while (n != -1 && n != 62) {
                stringBuffer.append(Character.toLowerCase((char)n));
                n = this.nextChar();
                if (n == 34) {
                    stringBuffer.append(Character.toLowerCase((char)n));
                    n = this.nextChar();
                    while (n != -1 && n != 34) {
                        stringBuffer.append(Character.toLowerCase((char)n));
                        n = this.nextChar();
                    }
                }
                if (n != 60) continue;
                this.unread(n);
                return '<' + stringBuffer.toString();
            }
            if (n == -1) {
                return null;
            }
            int n2 = stringBuffer.length();
            if (n2 < 3 || !"!--".equals(stringBuffer.substring(0, 3)) || n2 >= 5 && "--".equals(stringBuffer.substring(n2 - 2))) break;
            stringBuffer.append(n);
        }
        return this.html2Text(stringBuffer.toString());
    }

    private String processPreformattedText(int n) {
        if (n == 13 || n == 10) {
            ++this.fCounter;
        }
        return null;
    }

    private void unread(int n) throws IOException {
        ((PushbackReader)this.getReader()).unread(n);
    }

    protected String entity2Text(String string) {
        if (string.length() > 1 && string.charAt(0) == '#') {
            try {
                int n = string.charAt(1) == 'x' ? Integer.parseInt(string.substring(2), 16) : Integer.parseInt(string.substring(1), 10);
                return EMPTY_STRING + (char)n;
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            String string2 = (String)fgEntityLookup.get(string);
            if (string2 != null) {
                return string2;
            }
        }
        return "&" + string;
    }

    private String processEntity() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.nextChar();
        while (Character.isLetterOrDigit((char)n) || n == 35) {
            stringBuffer.append((char)n);
            n = this.nextChar();
        }
        if (n == 59) {
            return this.entity2Text(stringBuffer.toString());
        }
        stringBuffer.insert(0, '&');
        if (n != -1) {
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    static {
        fgTags = new HashSet();
        fgTags.add("b");
        fgTags.add("br");
        fgTags.add("br/");
        fgTags.add("div");
        fgTags.add("h1");
        fgTags.add("h2");
        fgTags.add("h3");
        fgTags.add("h4");
        fgTags.add("h5");
        fgTags.add("p");
        fgTags.add("dl");
        fgTags.add("dt");
        fgTags.add("dd");
        fgTags.add("li");
        fgTags.add("ul");
        fgTags.add("pre");
        fgTags.add("head");
        fgEntityLookup = new HashMap(7);
        fgEntityLookup.put("lt", "<");
        fgEntityLookup.put("gt", ">");
        fgEntityLookup.put("nbsp", " ");
        fgEntityLookup.put("amp", "&");
        fgEntityLookup.put("circ", "^");
        fgEntityLookup.put("tilde", "~");
        fgEntityLookup.put("quot", "\"");
    }
}

