/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.text;

import com.spket.ui.text.ColorManager;
import com.spket.ui.text.IColorManager;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public abstract class TextTools {
    private IColorManager fColorManager;
    private Map fScanners;

    public TextTools(IPreferenceStore iPreferenceStore) {
        this(iPreferenceStore, true);
    }

    public TextTools(IPreferenceStore iPreferenceStore, boolean bl) {
        this.fColorManager = new ColorManager(bl);
    }

    public void dispose() {
        if (this.fColorManager != null) {
            this.fColorManager.dispose();
            this.fColorManager = null;
        }
        if (this.fScanners != null) {
            this.fScanners.clear();
            this.fScanners = null;
        }
    }

    public IColorManager getColorManager() {
        return this.fColorManager;
    }

    protected IDocumentPartitioner createDocumentPartitioner(String string) {
        return new FastPartitioner(this.getPartitionScanner(string), this.getLegalContentTypes());
    }

    public void setupDocumentPartitioner(IDocument iDocument) {
        this.setupDocumentPartitioner(iDocument, "__dftl_partitioning");
    }

    public void setupDocumentPartitioner(IDocument iDocument, String string) {
        IDocumentPartitioner iDocumentPartitioner = this.createDocumentPartitioner(string);
        if (iDocument instanceof IDocumentExtension3) {
            IDocumentExtension3 iDocumentExtension3 = (IDocumentExtension3)iDocument;
            iDocumentExtension3.setDocumentPartitioner(string, iDocumentPartitioner);
        } else {
            iDocument.setDocumentPartitioner(iDocumentPartitioner);
        }
        iDocumentPartitioner.connect(iDocument);
    }

    protected final IPartitionTokenScanner getPartitionScanner(String string) {
        IPartitionTokenScanner iPartitionTokenScanner;
        if (this.fScanners == null) {
            this.fScanners = new HashMap(2);
        }
        if ((iPartitionTokenScanner = (IPartitionTokenScanner)this.fScanners.get(string)) == null) {
            iPartitionTokenScanner = this.createPartitionScanner(string);
            this.fScanners.put(string, iPartitionTokenScanner);
        }
        return iPartitionTokenScanner;
    }

    protected abstract IPartitionTokenScanner createPartitionScanner(String var1);

    protected abstract String[] getLegalContentTypes();

    protected abstract SourceViewerConfiguration createHoverSourceViewerConfiguration();
}

