/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.text;

import com.spket.buffer.ZipEntryStorage;
import com.spket.buffer.ZipPath;
import com.spket.ui.editors.ZipEntryEditorInput;
import com.spket.ui.internal.UIMessages;
import com.spket.ui.internal.UIPlugin;
import com.spket.ui.util.Compatibility;
import com.spket.ui.util.Message;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class DefaultHyperlink
implements IHyperlink {
    private static boolean gHasError;
    private static Constructor gConstructor;
    private IPath fPath;
    private IRegion fRegion;
    private String fHyperlinkText;
    private ITextEditor fEditor;
    private boolean fSameContentType;
    private int fOffset;
    private int fLength;
    static /* synthetic */ Class class$org$eclipse$core$filesystem$IFileStore;

    protected static IEditorInput createLocalFileInput(IFileStore iFileStore) {
        if (gHasError) {
            return null;
        }
        if (gConstructor == null) {
            Class<?> clazz = null;
            try {
                try {
                    clazz = Class.forName(Compatibility.getExternalEditorInputClassName());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    clazz = null;
                    gHasError = true;
                }
                if (clazz != null) {
                    try {
                        gConstructor = clazz.getConstructor(class$org$eclipse$core$filesystem$IFileStore == null ? (class$org$eclipse$core$filesystem$IFileStore = DefaultHyperlink.class$("org.eclipse.core.filesystem.IFileStore")) : class$org$eclipse$core$filesystem$IFileStore);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        gHasError = true;
                        UIPlugin.log(noSuchMethodException);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                gHasError = true;
                throw runtimeException;
            }
            if (gConstructor == null) {
                UIPlugin.logErrorMessage("Unable to find the right editor input for local file...");
                return null;
            }
        }
        try {
            return (IEditorInput)gConstructor.newInstance(iFileStore);
        }
        catch (InstantiationException instantiationException) {
            UIPlugin.log(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            UIPlugin.log(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            UIPlugin.log(invocationTargetException);
        }
        return null;
    }

    public DefaultHyperlink(ITextEditor iTextEditor, IPath iPath) {
        this.fEditor = iTextEditor;
        this.fPath = iPath;
        this.fOffset = -1;
    }

    public void setRegion(IRegion iRegion) {
        this.fRegion = iRegion;
    }

    public void setHyperlinkText(String string) {
        this.fHyperlinkText = string;
    }

    public void setSameContentType(boolean bl) {
        this.fSameContentType = bl;
    }

    public void setSelection(int n, int n2) {
        this.fOffset = n;
        this.fLength = n2;
    }

    public IRegion getHyperlinkRegion() {
        return this.fRegion;
    }

    public String getHyperlinkText() {
        return this.fHyperlinkText;
    }

    public String getTypeLabel() {
        return this.fPath.lastSegment();
    }

    public void open() {
        ITextEditor iTextEditor = null;
        if (this.fPath == null) {
            iTextEditor = this.fEditor;
        } else {
            String string;
            IEditorInput iEditorInput;
            IWorkbenchPage iWorkbenchPage;
            IWorkbenchWindow iWorkbenchWindow = UIPlugin.getActiveWorkbenchWindow();
            IWorkbenchPage iWorkbenchPage2 = iWorkbenchPage = iWorkbenchWindow == null ? null : iWorkbenchWindow.getActivePage();
            if (iWorkbenchPage != null && (iEditorInput = this.getEditorInput(this.fPath)) != null && (string = this.getEditorID(this.fEditor, iEditorInput)) != null) {
                try {
                    IEditorPart iEditorPart = IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IEditorInput)iEditorInput, (String)string, (boolean)true);
                    if (iEditorPart instanceof ITextEditor) {
                        iTextEditor = (ITextEditor)iEditorPart;
                    }
                }
                catch (PartInitException partInitException) {
                    UIPlugin.log(partInitException.getStatus());
                    String string2 = Message.format(UIMessages.Hyperlink_error_message, this.fPath.toPortableString());
                    MessageDialog.openError((Shell)iWorkbenchWindow.getShell(), (String)UIMessages.Hyperlink_error_title, (String)string2);
                }
            }
        }
        if (iTextEditor != null && this.fOffset >= 0) {
            iTextEditor.selectAndReveal(this.fOffset, Math.max(this.fLength, 0));
        }
    }

    protected IEditorInput getEditorInput(IPath iPath) {
        ZipEntryEditorInput zipEntryEditorInput = null;
        if (iPath instanceof ZipPath) {
            zipEntryEditorInput = new ZipEntryEditorInput(new ZipEntryStorage((ZipPath)iPath));
        } else {
            IFileInfo iFileInfo;
            IFile iFile;
            IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            if (iPath.getDevice() == null && (iFile = iWorkspaceRoot.getFile(iPath)) != null && iFile.exists()) {
                zipEntryEditorInput = new FileEditorInput(iFile);
            }
            if (zipEntryEditorInput == null && (iFile = EFS.getLocalFileSystem().getStore(iPath)) != null && !(iFileInfo = iFile.fetchInfo()).isDirectory() && iFileInfo.exists()) {
                IFile[] iFileArray = iWorkspaceRoot.findFilesForLocation((IPath)new Path(iFile.toURI().getPath()));
                if (iFileArray != null) {
                    for (int i = 0; i < iFileArray.length; ++i) {
                        IFile iFile2 = iFileArray[i];
                        if (!iFile2.exists()) continue;
                        zipEntryEditorInput = new FileEditorInput(iFile2);
                        break;
                    }
                }
                if (zipEntryEditorInput == null) {
                    zipEntryEditorInput = DefaultHyperlink.createLocalFileInput((IFileStore)iFile);
                }
            }
        }
        return zipEntryEditorInput;
    }

    protected String getEditorID(ITextEditor iTextEditor, IEditorInput iEditorInput) {
        IWorkbenchPartSite iWorkbenchPartSite;
        IWorkbenchPartSite iWorkbenchPartSite2;
        if (this.fSameContentType && iTextEditor != null && (iWorkbenchPartSite2 = iTextEditor.getSite()) != null) {
            return iWorkbenchPartSite2.getId();
        }
        try {
            iWorkbenchPartSite2 = iEditorInput instanceof IFileEditorInput ? IDE.getEditorDescriptor((IFile)((IFileEditorInput)iEditorInput).getFile()) : IDE.getEditorDescriptor((String)iEditorInput.getName());
        }
        catch (PartInitException partInitException) {
            iWorkbenchPartSite2 = null;
        }
        if (iWorkbenchPartSite2 != null) {
            return iWorkbenchPartSite2.getId();
        }
        if (iTextEditor != null && (iWorkbenchPartSite = iTextEditor.getSite()) != null) {
            return iWorkbenchPartSite.getId();
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

