/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.preferences;

import com.spket.ui.internal.License;
import com.spket.ui.internal.UIPlugin;
import com.spket.ui.preferences.AbstractPreferencePage;
import com.spket.ui.preferences.OverlayPreferenceStore;
import com.spket.ui.preferences.PrefMessages;
import com.spket.ui.util.StatusInfo;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;

public class SpketPreferencePage
extends AbstractPreferencePage {
    private Text fText;
    private String fLicense;
    private boolean isFile;

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(1808));
        this.createLable(composite2, PrefMessages.ProductName);
        new Label(composite2, 0);
        this.createLable(composite2, PrefMessages.Copyright);
        new Label(composite2, 0);
        this.createLink(composite2, PrefMessages.SupportInfo);
        new Label(composite2, 0);
        License license = UIPlugin.getDefault().getLicense();
        if (license.isValid()) {
            this.createLable(composite2, "Valid commercial license code. Thanks for your support.");
        } else {
            GridData gridData;
            this.createLink(composite2, "Spket IDE is free for non-commercial use.\n\n\nTo purchase commercial licenses, please visit:\n  <a>http://www.spket.com/buy.html</a>");
            new Label(composite2, 0);
            Button button = new Button(composite2, 8);
            button.setText("&License...");
            this.setButtonLayoutData(button);
            Object object = button.getLayoutData();
            if (object instanceof GridData) {
                gridData = (GridData)object;
                gridData.horizontalAlignment = 2;
            }
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    if (24 == event.type) {
                        SpketPreferencePage.this.onLicenseChanged(event);
                    } else {
                        SpketPreferencePage.this.onLoadLicense();
                    }
                }
            };
            button.addListener(13, listener);
            new Label(composite2, 0);
            this.createLink(composite2, "Or get a free copy: <a>http://www.spket.com/trialpay.html</a>");
            this.fText = new Text(composite2, 2626);
            gridData = new GridData(1808);
            gridData.verticalIndent = 10;
            this.fText.setLayoutData((Object)gridData);
            this.fText.addListener(24, listener);
        }
        return composite2;
    }

    public void init(IWorkbench iWorkbench) {
        this.noDefaultAndApplyButton();
    }

    protected Plugin getPlugin() {
        return null;
    }

    protected String getPluginId() {
        return "com.spket.ui";
    }

    protected OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        return NO_KEYS;
    }

    protected void onLicenseChanged(Event event) {
        this.isFile = false;
        this.fLicense = this.fText.getText();
        this.valid();
    }

    protected void onLoadLicense() {
        File file;
        FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
        String string = fileDialog.open();
        if (string != null && (file = new File(string)).exists() && file.isFile()) {
            this.isFile = true;
            this.fLicense = file.getAbsolutePath();
            this.valid();
        }
    }

    public boolean performOk() {
        if (this.fLicense != null && this.fLicense.length() > 0) {
            boolean bl = false;
            License license = UIPlugin.getDefault().getLicense();
            try {
                if (this.isFile) {
                    File file = new File(this.fLicense);
                    if (file.exists() && file.isFile() && (bl = license.check(file))) {
                        license.saveLicense(file);
                    }
                } else {
                    bl = license.check(this.fLicense);
                    if (bl) {
                        license.saveLicense(this.fLicense);
                    }
                }
            }
            catch (IOException iOException) {
                bl = false;
                Status status = new Status(4, "com.spket.ui", 4, iOException.getMessage(), (Throwable)iOException);
                UIPlugin.log((IStatus)status);
                ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)status);
            }
            return bl;
        }
        return true;
    }

    private void valid() {
        StatusInfo statusInfo = null;
        if (this.fLicense != null && this.fLicense.length() > 0) {
            boolean bl = false;
            License license = UIPlugin.getDefault().getLicense();
            if (this.isFile) {
                File file = new File(this.fLicense);
                if (file.exists() && file.isFile()) {
                    bl = license.check(file);
                }
            } else {
                bl = license.check(this.fLicense);
            }
            if (statusInfo == null) {
                statusInfo = bl ? new StatusInfo(0, "com.spket.ui", "The license is valid. Thanks for support our product.") : new StatusInfo(4, "com.spket.ui", "The license is not valid!");
            }
        }
        this.updateStatus(statusInfo);
    }
}

