/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.preferences;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class OverlayPreferenceStore
implements IPreferenceStore {
    public static final TypeDescriptor BOOLEAN = new TypeDescriptor();
    public static final TypeDescriptor DOUBLE = new TypeDescriptor();
    public static final TypeDescriptor FLOAT = new TypeDescriptor();
    public static final TypeDescriptor INT = new TypeDescriptor();
    public static final TypeDescriptor LONG = new TypeDescriptor();
    public static final TypeDescriptor STRING = new TypeDescriptor();
    private IPreferenceStore fParent;
    private IPreferenceStore fStore;
    private OverlayKey[] fOverlayKeys;
    private PropertyListener fPropertyListener;
    private boolean fLoaded;

    public OverlayPreferenceStore(IPreferenceStore iPreferenceStore, OverlayKey[] overlayKeyArray) {
        this.fParent = iPreferenceStore;
        this.fOverlayKeys = overlayKeyArray;
        this.fStore = new PreferenceStore();
    }

    private OverlayKey findOverlayKey(String string) {
        for (int i = 0; i < this.fOverlayKeys.length; ++i) {
            if (!this.fOverlayKeys[i].fKey.equals(string)) continue;
            return this.fOverlayKeys[i];
        }
        return null;
    }

    private boolean covers(String string) {
        return this.findOverlayKey(string) != null;
    }

    private void propagateProperty(IPreferenceStore iPreferenceStore, OverlayKey overlayKey, IPreferenceStore iPreferenceStore2) {
        if (iPreferenceStore.isDefault(overlayKey.fKey)) {
            if (!iPreferenceStore2.isDefault(overlayKey.fKey)) {
                iPreferenceStore2.setToDefault(overlayKey.fKey);
            }
            return;
        }
        TypeDescriptor typeDescriptor = overlayKey.fDescriptor;
        if (BOOLEAN == typeDescriptor) {
            boolean bl = iPreferenceStore.getBoolean(overlayKey.fKey);
            boolean bl2 = iPreferenceStore2.getBoolean(overlayKey.fKey);
            if (bl2 != bl) {
                iPreferenceStore2.setValue(overlayKey.fKey, bl);
            }
        } else if (DOUBLE == typeDescriptor) {
            double d = iPreferenceStore.getDouble(overlayKey.fKey);
            double d2 = iPreferenceStore2.getDouble(overlayKey.fKey);
            if (d2 != d) {
                iPreferenceStore2.setValue(overlayKey.fKey, d);
            }
        } else if (FLOAT == typeDescriptor) {
            float f = iPreferenceStore.getFloat(overlayKey.fKey);
            float f2 = iPreferenceStore2.getFloat(overlayKey.fKey);
            if (f2 != f) {
                iPreferenceStore2.setValue(overlayKey.fKey, f);
            }
        } else if (INT == typeDescriptor) {
            int n = iPreferenceStore.getInt(overlayKey.fKey);
            int n2 = iPreferenceStore2.getInt(overlayKey.fKey);
            if (n2 != n) {
                iPreferenceStore2.setValue(overlayKey.fKey, n);
            }
        } else if (LONG == typeDescriptor) {
            long l = iPreferenceStore.getLong(overlayKey.fKey);
            long l2 = iPreferenceStore2.getLong(overlayKey.fKey);
            if (l2 != l) {
                iPreferenceStore2.setValue(overlayKey.fKey, l);
            }
        } else if (STRING == typeDescriptor) {
            String string = iPreferenceStore.getString(overlayKey.fKey);
            String string2 = iPreferenceStore2.getString(overlayKey.fKey);
            if (string2 != null && string != null && !string2.equals(string)) {
                iPreferenceStore2.setValue(overlayKey.fKey, string);
            }
        }
    }

    public void propagate() {
        for (int i = 0; i < this.fOverlayKeys.length; ++i) {
            this.propagateProperty(this.fStore, this.fOverlayKeys[i], this.fParent);
        }
    }

    private void loadProperty(IPreferenceStore iPreferenceStore, OverlayKey overlayKey, IPreferenceStore iPreferenceStore2, boolean bl) {
        TypeDescriptor typeDescriptor = overlayKey.fDescriptor;
        if (BOOLEAN == typeDescriptor) {
            if (bl) {
                iPreferenceStore2.setValue(overlayKey.fKey, true);
            }
            iPreferenceStore2.setValue(overlayKey.fKey, iPreferenceStore.getBoolean(overlayKey.fKey));
            iPreferenceStore2.setDefault(overlayKey.fKey, iPreferenceStore.getDefaultBoolean(overlayKey.fKey));
        } else if (DOUBLE == typeDescriptor) {
            if (bl) {
                iPreferenceStore2.setValue(overlayKey.fKey, 1.0);
            }
            iPreferenceStore2.setValue(overlayKey.fKey, iPreferenceStore.getDouble(overlayKey.fKey));
            iPreferenceStore2.setDefault(overlayKey.fKey, iPreferenceStore.getDefaultDouble(overlayKey.fKey));
        } else if (FLOAT == typeDescriptor) {
            if (bl) {
                iPreferenceStore2.setValue(overlayKey.fKey, 1.0f);
            }
            iPreferenceStore2.setValue(overlayKey.fKey, iPreferenceStore.getFloat(overlayKey.fKey));
            iPreferenceStore2.setDefault(overlayKey.fKey, iPreferenceStore.getDefaultFloat(overlayKey.fKey));
        } else if (INT == typeDescriptor) {
            if (bl) {
                iPreferenceStore2.setValue(overlayKey.fKey, 1);
            }
            iPreferenceStore2.setValue(overlayKey.fKey, iPreferenceStore.getInt(overlayKey.fKey));
            iPreferenceStore2.setDefault(overlayKey.fKey, iPreferenceStore.getDefaultInt(overlayKey.fKey));
        } else if (LONG == typeDescriptor) {
            if (bl) {
                iPreferenceStore2.setValue(overlayKey.fKey, 1L);
            }
            iPreferenceStore2.setValue(overlayKey.fKey, iPreferenceStore.getLong(overlayKey.fKey));
            iPreferenceStore2.setDefault(overlayKey.fKey, iPreferenceStore.getDefaultLong(overlayKey.fKey));
        } else if (STRING == typeDescriptor) {
            if (bl) {
                iPreferenceStore2.setValue(overlayKey.fKey, "1");
            }
            iPreferenceStore2.setValue(overlayKey.fKey, iPreferenceStore.getString(overlayKey.fKey));
            iPreferenceStore2.setDefault(overlayKey.fKey, iPreferenceStore.getDefaultString(overlayKey.fKey));
        }
    }

    public void load() {
        for (int i = 0; i < this.fOverlayKeys.length; ++i) {
            this.loadProperty(this.fParent, this.fOverlayKeys[i], this.fStore, true);
        }
        this.fLoaded = true;
    }

    public void loadDefaults() {
        for (int i = 0; i < this.fOverlayKeys.length; ++i) {
            this.setToDefault(this.fOverlayKeys[i].fKey);
        }
    }

    public void start() {
        if (this.fPropertyListener == null) {
            this.fPropertyListener = new PropertyListener();
            this.fParent.addPropertyChangeListener((IPropertyChangeListener)this.fPropertyListener);
        }
    }

    public void stop() {
        if (this.fPropertyListener != null) {
            this.fParent.removePropertyChangeListener((IPropertyChangeListener)this.fPropertyListener);
            this.fPropertyListener = null;
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.fStore.addPropertyChangeListener(iPropertyChangeListener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.fStore.removePropertyChangeListener(iPropertyChangeListener);
    }

    public void firePropertyChangeEvent(String string, Object object, Object object2) {
        this.fStore.firePropertyChangeEvent(string, object, object2);
    }

    public boolean contains(String string) {
        return this.fStore.contains(string);
    }

    public boolean getBoolean(String string) {
        return this.fStore.getBoolean(string);
    }

    public boolean getDefaultBoolean(String string) {
        return this.fStore.getDefaultBoolean(string);
    }

    public double getDefaultDouble(String string) {
        return this.fStore.getDefaultDouble(string);
    }

    public float getDefaultFloat(String string) {
        return this.fStore.getDefaultFloat(string);
    }

    public int getDefaultInt(String string) {
        return this.fStore.getDefaultInt(string);
    }

    public long getDefaultLong(String string) {
        return this.fStore.getDefaultLong(string);
    }

    public String getDefaultString(String string) {
        return this.fStore.getDefaultString(string);
    }

    public double getDouble(String string) {
        return this.fStore.getDouble(string);
    }

    public float getFloat(String string) {
        return this.fStore.getFloat(string);
    }

    public int getInt(String string) {
        return this.fStore.getInt(string);
    }

    public long getLong(String string) {
        return this.fStore.getLong(string);
    }

    public String getString(String string) {
        return this.fStore.getString(string);
    }

    public boolean isDefault(String string) {
        return this.fStore.isDefault(string);
    }

    public boolean needsSaving() {
        return this.fStore.needsSaving();
    }

    public void putValue(String string, String string2) {
        if (this.covers(string)) {
            this.fStore.putValue(string, string2);
        }
    }

    public void setDefault(String string, double d) {
        if (this.covers(string)) {
            this.fStore.setDefault(string, d);
        }
    }

    public void setDefault(String string, float f) {
        if (this.covers(string)) {
            this.fStore.setDefault(string, f);
        }
    }

    public void setDefault(String string, int n) {
        if (this.covers(string)) {
            this.fStore.setDefault(string, n);
        }
    }

    public void setDefault(String string, long l) {
        if (this.covers(string)) {
            this.fStore.setDefault(string, l);
        }
    }

    public void setDefault(String string, String string2) {
        if (this.covers(string)) {
            this.fStore.setDefault(string, string2);
        }
    }

    public void setDefault(String string, boolean bl) {
        if (this.covers(string)) {
            this.fStore.setDefault(string, bl);
        }
    }

    public void setToDefault(String string) {
        this.fStore.setToDefault(string);
    }

    public void setValue(String string, double d) {
        if (this.covers(string)) {
            this.fStore.setValue(string, d);
        }
    }

    public void setValue(String string, float f) {
        if (this.covers(string)) {
            this.fStore.setValue(string, f);
        }
    }

    public void setValue(String string, int n) {
        if (this.covers(string)) {
            this.fStore.setValue(string, n);
        }
    }

    public void setValue(String string, long l) {
        if (this.covers(string)) {
            this.fStore.setValue(string, l);
        }
    }

    public void setValue(String string, String string2) {
        if (this.covers(string)) {
            this.fStore.setValue(string, string2);
        }
    }

    public void setValue(String string, boolean bl) {
        if (this.covers(string)) {
            this.fStore.setValue(string, bl);
        }
    }

    public void addKeys(OverlayKey[] overlayKeyArray) {
        int n;
        Assert.isTrue((!this.fLoaded ? 1 : 0) != 0);
        Assert.isNotNull((Object)overlayKeyArray);
        int n2 = this.fOverlayKeys.length;
        OverlayKey[] overlayKeyArray2 = new OverlayKey[overlayKeyArray.length + n2];
        int n3 = n2;
        for (n = 0; n < n3; ++n) {
            overlayKeyArray2[n] = this.fOverlayKeys[n];
        }
        n3 = overlayKeyArray.length;
        for (n = 0; n < n3; ++n) {
            overlayKeyArray2[n2 + n] = overlayKeyArray[n];
        }
        this.fOverlayKeys = overlayKeyArray2;
        if (this.fLoaded) {
            this.load();
        }
    }

    private class PropertyListener
    implements IPropertyChangeListener {
        private PropertyListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            OverlayKey overlayKey = OverlayPreferenceStore.this.findOverlayKey(propertyChangeEvent.getProperty());
            if (overlayKey != null) {
                OverlayPreferenceStore.this.propagateProperty(OverlayPreferenceStore.this.fParent, overlayKey, OverlayPreferenceStore.this.fStore);
            }
        }
    }

    public static class OverlayKey {
        TypeDescriptor fDescriptor;
        String fKey;

        public OverlayKey(TypeDescriptor typeDescriptor, String string) {
            this.fDescriptor = typeDescriptor;
            this.fKey = string;
        }
    }

    public static final class TypeDescriptor {
        private TypeDescriptor() {
        }
    }
}

