/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.palette;

import com.spket.palette.PaletteCategory;
import com.spket.palette.PaletteSnippet;
import com.spket.ui.internal.UIMessages;
import com.spket.ui.internal.UIPlugin;
import com.spket.ui.palette.ImagePicker;
import com.spket.ui.preferences.TemplateVariableProcessor;
import com.spket.ui.preferences.TextEditorTemplateMessages;
import com.spket.ui.text.SnippetContextType;
import com.spket.ui.util.StatusInfo;
import com.spket.util.ImageProvider;
import com.spket.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;

public class SnippetDialog
extends StatusDialog {
    private Text fNameText;
    private ImageProvider fImageProvider;
    private ImagePicker fImagePicker;
    private SourceViewer fPatternEditor;
    private Button fInsertVariableButton;
    private StatusInfo fValidationStatus;
    private boolean fSuppressError = true;
    private Map fGlobalActions = new HashMap(10);
    private List fSelectionActions = new ArrayList(3);
    private PaletteCategory fCategory;
    private PaletteSnippet fSnippet;
    private PaletteSnippet fNewSnippet;
    private TemplateContextType fContextType = new SnippetContextType();
    private final TemplateVariableProcessor fTemplateProcessor = new TemplateVariableProcessor();

    public SnippetDialog(Shell shell, PaletteCategory paletteCategory, PaletteSnippet paletteSnippet) {
        super(shell);
        this.fSnippet = paletteSnippet;
        this.fCategory = paletteCategory;
        this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
        String string = paletteSnippet == null ? "New Snippet" : "Edit Snippet";
        this.setTitle(string);
        this.fValidationStatus = new StatusInfo();
        this.fTemplateProcessor.setContextType(this.fContextType);
    }

    public void setImageProvider(ImageProvider imageProvider) {
        this.fImageProvider = imageProvider;
    }

    public void create() {
        boolean bl;
        super.create();
        boolean bl2 = bl = this.fNameText == null || this.fNameText.getText().trim().length() != 0;
        if (!bl) {
            StatusInfo statusInfo = new StatusInfo();
            statusInfo.setError(UIMessages.Name_empty);
            this.updateButtonsEnableState(statusInfo);
        }
    }

    protected Control createDialogArea(Composite composite) {
        Object object;
        Label label;
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (24 == event.type) {
                    SnippetDialog.this.doTextWidgetChanged(event.widget);
                } else if (16 == event.type) {
                    if (SnippetDialog.this.fSuppressError) {
                        SnippetDialog.this.fSuppressError = false;
                        SnippetDialog.this.updateButtons();
                    }
                } else if (13 == event.type) {
                    SnippetDialog.this.fPatternEditor.getTextWidget().setFocus();
                    SnippetDialog.this.fPatternEditor.doOperation(13);
                }
            }
        };
        SnippetDialog.createLabel(composite2, "&Name:");
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)new GridData(768));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite3.setLayout((Layout)gridLayout);
        this.fNameText = SnippetDialog.createText(composite3);
        if (this.fSnippet != null) {
            this.fNameText.setText(this.fSnippet.getLabel());
        }
        this.fNameText.addListener(24, listener);
        this.fNameText.addListener(16, listener);
        this.fImagePicker = new ImagePicker(composite3, 0);
        if (this.fImageProvider != null && (label = this.fImageProvider.getImages()) != null && ((Label)label).length > 0) {
            Arrays.sort((Object[])label);
            object = new Image[((Label)label).length];
            for (int i = 0; i < ((Label)label).length; ++i) {
                object[i] = this.fImageProvider.getImage((String)label[i]);
            }
            this.fImagePicker.setImages((String[])label, (Image[])object);
            if (this.fSnippet != null) {
                this.fImagePicker.setImageName(this.fSnippet.getIconURL());
            }
        }
        label = SnippetDialog.createLabel(composite2, "&Snippet");
        label.setLayoutData((Object)new GridData(2));
        object = null;
        if (this.fSnippet != null) {
            object = this.fSnippet.toSource();
        }
        this.fPatternEditor = this.createEditor(composite2, (String)(object == null ? "" : object));
        Label label2 = new Label(composite2, 0);
        label2.setLayoutData((Object)new GridData());
        composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)new GridData());
        this.fInsertVariableButton = new Button(composite3, 0);
        this.fInsertVariableButton.setLayoutData((Object)SnippetDialog.getButtonGridData(this.fInsertVariableButton));
        this.fInsertVariableButton.setText("Insert &Variable...");
        this.fInsertVariableButton.addListener(13, listener);
        this.initializeActions();
        SnippetDialog.applyDialogFont((Control)composite2);
        return composite3;
    }

    private void doTextWidgetChanged(Widget widget) {
        if (widget == this.fNameText) {
            this.fSuppressError = false;
            this.updateButtons();
        }
    }

    private void doSourceChanged(IDocument iDocument) {
        String string = iDocument.get();
        this.fValidationStatus.setOK();
        if (this.fContextType != null) {
            try {
                this.fContextType.validate(string);
            }
            catch (TemplateException templateException) {
                this.fValidationStatus.setError(templateException.getLocalizedMessage());
            }
        }
        this.updateUndoAction();
        this.updateButtons();
    }

    private static GridData getButtonGridData(Button button) {
        return new GridData(768);
    }

    private static Label createLabel(Composite composite, String string) {
        Label label = new Label(composite, 0);
        label.setText(string);
        label.setLayoutData((Object)new GridData());
        return label;
    }

    private static Text createText(Composite composite) {
        Text text = new Text(composite, 2048);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    protected void setupDocument(IDocument iDocument) {
    }

    private SourceViewer createEditor(Composite composite, String string) {
        SourceViewer sourceViewer = this.createViewer(composite);
        Document document = new Document(string);
        this.setupDocument((IDocument)document);
        sourceViewer.setEditable(true);
        sourceViewer.setDocument((IDocument)document);
        int n = document.getNumberOfLines();
        if (n < 5) {
            n = 5;
        } else if (n > 12) {
            n = 12;
        }
        Control control = sourceViewer.getControl();
        GridData gridData = new GridData(1808);
        gridData.widthHint = this.convertWidthInCharsToPixels(80);
        gridData.heightHint = this.convertHeightInCharsToPixels(n);
        control.setLayoutData((Object)gridData);
        sourceViewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent textEvent) {
                if (textEvent.getDocumentEvent() != null) {
                    SnippetDialog.this.doSourceChanged(textEvent.getDocumentEvent().getDocument());
                }
            }
        });
        sourceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                SnippetDialog.this.updateSelectionDependentActions();
            }
        });
        sourceViewer.prependVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent verifyEvent) {
                SnippetDialog.this.handleVerifyKeyPressed(verifyEvent);
            }
        });
        return sourceViewer;
    }

    protected SourceViewer createViewer(Composite composite) {
        SourceViewer sourceViewer = new SourceViewer(composite, null, null, false, 2816);
        SourceViewerConfiguration sourceViewerConfiguration = new SourceViewerConfiguration(){

            public IContentAssistant getContentAssistant(ISourceViewer iSourceViewer) {
                ContentAssistant contentAssistant = new ContentAssistant();
                contentAssistant.enableAutoActivation(true);
                contentAssistant.enableAutoInsert(true);
                contentAssistant.setContentAssistProcessor((IContentAssistProcessor)SnippetDialog.this.fTemplateProcessor, "__dftl_partition_content_type");
                return contentAssistant;
            }
        };
        sourceViewer.configure(sourceViewerConfiguration);
        return sourceViewer;
    }

    private void handleVerifyKeyPressed(VerifyEvent verifyEvent) {
        if (!verifyEvent.doit) {
            return;
        }
        if (verifyEvent.stateMask != SWT.MOD1) {
            return;
        }
        switch (verifyEvent.character) {
            case ' ': {
                this.fPatternEditor.doOperation(13);
                verifyEvent.doit = false;
                break;
            }
            case '\u001a': {
                this.fPatternEditor.doOperation(1);
                verifyEvent.doit = false;
            }
        }
    }

    private void initializeActions() {
        TextViewerAction textViewerAction = new TextViewerAction((ITextViewer)this.fPatternEditor, 1);
        textViewerAction.setText(TextEditorTemplateMessages.EditTemplateDialog_undo);
        this.fGlobalActions.put(ITextEditorActionConstants.UNDO, textViewerAction);
        textViewerAction = new TextViewerAction((ITextViewer)this.fPatternEditor, 3);
        textViewerAction.setText(TextEditorTemplateMessages.EditTemplateDialog_cut);
        this.fGlobalActions.put(ITextEditorActionConstants.CUT, textViewerAction);
        textViewerAction = new TextViewerAction((ITextViewer)this.fPatternEditor, 4);
        textViewerAction.setText(TextEditorTemplateMessages.EditTemplateDialog_copy);
        this.fGlobalActions.put(ITextEditorActionConstants.COPY, textViewerAction);
        textViewerAction = new TextViewerAction((ITextViewer)this.fPatternEditor, 5);
        textViewerAction.setText(TextEditorTemplateMessages.EditTemplateDialog_paste);
        this.fGlobalActions.put(ITextEditorActionConstants.PASTE, textViewerAction);
        textViewerAction = new TextViewerAction((ITextViewer)this.fPatternEditor, 7);
        textViewerAction.setText(TextEditorTemplateMessages.EditTemplateDialog_select_all);
        this.fGlobalActions.put(ITextEditorActionConstants.SELECT_ALL, textViewerAction);
        textViewerAction = new TextViewerAction((ITextViewer)this.fPatternEditor, 13);
        textViewerAction.setText(TextEditorTemplateMessages.EditTemplateDialog_content_assist);
        this.fGlobalActions.put("ContentAssistProposal", textViewerAction);
        this.fSelectionActions.add(ITextEditorActionConstants.CUT);
        this.fSelectionActions.add(ITextEditorActionConstants.COPY);
        this.fSelectionActions.add(ITextEditorActionConstants.PASTE);
        MenuManager menuManager = new MenuManager(null, null);
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                SnippetDialog.this.fillContextMenu(iMenuManager);
            }
        });
        StyledText styledText = this.fPatternEditor.getTextWidget();
        Menu menu = menuManager.createContextMenu((Control)styledText);
        styledText.setMenu(menu);
    }

    private void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IContributionItem)new GroupMarker("group.undo"));
        iMenuManager.appendToGroup("group.undo", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.UNDO));
        iMenuManager.add((IContributionItem)new Separator("group.edit"));
        iMenuManager.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.CUT));
        iMenuManager.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.COPY));
        iMenuManager.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.PASTE));
        iMenuManager.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.SELECT_ALL));
        iMenuManager.add((IContributionItem)new Separator("templates"));
        iMenuManager.appendToGroup("templates", (IAction)this.fGlobalActions.get("ContentAssistProposal"));
    }

    private void updateSelectionDependentActions() {
        Iterator iterator = this.fSelectionActions.iterator();
        while (iterator.hasNext()) {
            this.updateAction((String)iterator.next());
        }
    }

    private void updateUndoAction() {
        IAction iAction = (IAction)this.fGlobalActions.get(ITextEditorActionConstants.UNDO);
        if (iAction instanceof IUpdate) {
            ((IUpdate)iAction).update();
        }
    }

    private void updateAction(String string) {
        IAction iAction = (IAction)this.fGlobalActions.get(string);
        if (iAction instanceof IUpdate) {
            ((IUpdate)iAction).update();
        }
    }

    private void updateButtons() {
        StatusInfo statusInfo;
        block3: {
            String string;
            block2: {
                statusInfo = this.fValidationStatus;
                string = this.fNameText.getText();
                if (!StringUtils.isEmpty((String)string)) break block2;
                statusInfo = new StatusInfo();
                if (this.fSuppressError) break block3;
                statusInfo.setError(UIMessages.Name_empty);
                break block3;
            }
            if (this.fSnippet == null || !string.equals(this.fSnippet.getLabel())) {
                List list = this.fCategory.getSnippets();
                for (int i = 0; i < list.size(); ++i) {
                    PaletteSnippet paletteSnippet = (PaletteSnippet)list.get(i);
                    if (this.fSnippet == paletteSnippet || !string.equals(paletteSnippet.getLabel())) continue;
                    statusInfo = new StatusInfo();
                    if (this.fSuppressError) break;
                    statusInfo.setWarning(UIMessages.Name_exists);
                    break;
                }
            }
        }
        this.updateStatus(statusInfo);
    }

    public PaletteSnippet getSnippet() {
        return this.fNewSnippet;
    }

    protected void okPressed() {
        this.fNewSnippet = new PaletteSnippet();
        this.fNewSnippet.setLabel(this.fNameText.getText());
        PaletteSnippet.Text text = new PaletteSnippet.Text();
        text.appendContent(this.fPatternEditor.getDocument().get());
        this.fNewSnippet.setNode((PaletteSnippet.Node)text);
        String string = this.fImagePicker.getImageName();
        if (string != null) {
            this.fNewSnippet.setIconURL(string);
            if (this.fImageProvider != null) {
                this.fNewSnippet.setIcon(this.fImageProvider.getImage(string));
            }
        }
        super.okPressed();
    }

    protected IDialogSettings getDialogBoundsSettings() {
        String string = ((Object)((Object)this)).getClass().getName() + "_dialogBounds";
        IDialogSettings iDialogSettings = UIPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(string);
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(string);
        }
        return iDialogSettings2;
    }

    private static class TextViewerAction
    extends Action
    implements IUpdate {
        private int fOperationCode = -1;
        private ITextOperationTarget fOperationTarget;

        public TextViewerAction(ITextViewer iTextViewer, int n) {
            this.fOperationCode = n;
            this.fOperationTarget = iTextViewer.getTextOperationTarget();
            this.update();
        }

        public void update() {
            boolean bl = this.isEnabled();
            boolean bl2 = this.fOperationTarget != null && this.fOperationTarget.canDoOperation(this.fOperationCode);
            this.setEnabled(bl2);
            if (bl != bl2) {
                this.firePropertyChange("enabled", bl ? Boolean.TRUE : Boolean.FALSE, bl2 ? Boolean.TRUE : Boolean.FALSE);
            }
        }

        public void run() {
            if (this.fOperationCode != -1 && this.fOperationTarget != null) {
                this.fOperationTarget.doOperation(this.fOperationCode);
            }
        }
    }
}

