/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.actions;

import com.spket.ui.actions.DropDownAction;
import com.spket.ui.internal.UIImages;
import com.spket.ui.internal.UIMessages;
import com.spket.ui.util.OverlayIcon;
import com.spket.widget.CItem;
import com.spket.widget.ColorList;
import com.spket.widget.Colors;
import com.spket.widget.TransparentImage;
import com.spket.widget.UIUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.MenuItem;

public class SetColorRetargetAction
extends DropDownAction {
    private ColorList list;
    private Colors.NamedColor color;
    private ImageData fBase;
    private ImageData fGrayBase;

    public SetColorRetargetAction(String string) {
        super(string, null);
        boolean bl = "fmt.forecolor".equals(string);
        this.setText(bl ? UIMessages.SetForecolor_text : UIMessages.SetBackcolor_text);
        this.setToolTipText(bl ? UIMessages.SetForecolor_toolTip : UIMessages.SetBackcolor_toolTip);
        this.setImageDescriptor(UIImages.getImageDescriptor(bl ? "forecolor.gif" : "backcolor.gif"));
        this.setDisabledImageDescriptor(UIImages.getImageDescriptor(bl ? "forecolor.gif.d" : "backcolor.gif.d"));
    }

    protected Control createPopup(Composite composite, int n) {
        this.list = new ColorList(composite, n | 0x800000);
        this.list.addDefaultItems();
        this.list.setSelection(this.color == null ? ColorList.DEFAULT_ITEM : this.color);
        return this.list;
    }

    protected void onSelectionChanged() {
        Colors.NamedColor namedColor;
        CItem cItem;
        if (this.list != null && (cItem = this.list.getSelection()) != null && (namedColor = (Colors.NamedColor)cItem.getData()) != null) {
            Event event = new Event();
            event.data = namedColor;
            this.runWithEvent(event);
        }
    }

    protected Object getParameter(Event event) {
        Object object = event.data;
        if (object == null) {
            object = this.color == null || event.widget instanceof MenuItem ? ColorList.CUSTOM_ITEM : this.color;
        }
        return object;
    }

    protected void setParameter(Object object) {
        if (object instanceof Colors.NamedColor) {
            boolean bl = false;
            Colors.NamedColor namedColor = (Colors.NamedColor)object;
            if (ColorList.DEFAULT_ITEM == namedColor || ColorList.CUSTOM_ITEM == namedColor) {
                if (this.color != namedColor) {
                    this.color = namedColor;
                    bl = true;
                }
            } else if (!namedColor.equals((Object)this.color)) {
                bl = true;
                this.color = new Colors.NamedColor(namedColor.getName(), namedColor.getValue());
            }
            if (bl) {
                this.firePropertyChange("image", null, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ImageData getImageData(int n) {
        ImageData imageData;
        Object object;
        Image image;
        Display display = UIUtils.getDisplay();
        boolean bl = true;
        if (this.fBase == null) {
            image = this.getImageDescriptor().createImage();
            this.fBase = image.getImageData();
            ImageDescriptor imageDescriptor = this.getDisabledImageDescriptor();
            object = imageDescriptor == null ? new Image((Device)display, image, 2) : imageDescriptor.createImage();
            this.fGrayBase = object.getImageData();
            object.dispose();
            image.dispose();
        }
        ImageData imageData2 = imageData = 1 == n ? this.fGrayBase : this.fBase;
        if (this.color == null || this.color == ColorList.CUSTOM_ITEM) {
            bl = false;
        }
        image = null;
        if (bl && 1 != n) {
            TransparentImage transparentImage;
            block10: {
                int n2 = 9;
                int n3 = 7;
                transparentImage = new TransparentImage(n2, n3);
                Color color = display.getSystemColor(2);
                Color color2 = display.getSystemColor(16);
                Color color3 = display.getSystemColor(1);
                transparentImage.addColor(color);
                transparentImage.addColor(color2);
                transparentImage.addColor(color3);
                if (ColorList.DEFAULT_ITEM != this.color) {
                    transparentImage.addColor(this.color);
                }
                GC gC = null;
                try {
                    gC = transparentImage.createGC(display);
                    if (ColorList.DEFAULT_ITEM == this.color) {
                        gC.fillRectangle(0, 0, n2, n3);
                        gC.setForeground(color2);
                    } else {
                        Color color4 = gC.getBackground();
                        Color color5 = new Color((Device)display, Colors.getRGB((int)this.color.getValue()));
                        gC.setBackground(color5);
                        gC.fillRectangle(0, 0, n2, n3);
                        gC.setBackground(color4);
                        color5.dispose();
                        gC.setForeground(color);
                    }
                    gC.drawRectangle(0, 0, n2 - 1, n3 - 1);
                    image = transparentImage.getImageData();
                    Object var16_17 = null;
                    if (gC == null) break block10;
                }
                catch (Throwable throwable) {
                    Object var16_18 = null;
                    if (gC != null) {
                        gC.dispose();
                    }
                    transparentImage.dispose();
                    throw throwable;
                }
                gC.dispose();
            }
            transparentImage.dispose();
            {
            }
        }
        if (image == null) {
            return imageData;
        }
        object = new OverlayIcon(imageData, (ImageData)image, 0, 0);
        return object.getImageData();
    }
}

