/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.actions;

import com.spket.ui.editors.PlainTextEditor;
import com.spket.util.Debug;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.IUpdate;

public class ChangeCaseAction
extends Action
implements IUpdate {
    public static final int INVERT = 0;
    public static final int LOWER_CASE = 1;
    public static final int UPPER_CASE = 2;
    public static final int CAPITALIZE = 3;
    private int action;
    private PlainTextEditor editor;

    public ChangeCaseAction(PlainTextEditor plainTextEditor, int n) {
        this.editor = plainTextEditor;
        this.action = n;
        this.update();
    }

    public void run() {
        ISourceViewer iSourceViewer = this.getViewer();
        if (iSourceViewer == null) {
            return;
        }
        IDocument iDocument = iSourceViewer.getDocument();
        if (iDocument == null) {
            return;
        }
        StyledText styledText = iSourceViewer.getTextWidget();
        if (styledText == null || !styledText.isEnabled()) {
            return;
        }
        Point point = iSourceViewer.getSelectedRange();
        if (point == null) {
            return;
        }
        if (point.y > 0) {
            String string = null;
            String string2 = null;
            try {
                string = iDocument.get(point.x, point.y);
            }
            catch (BadLocationException badLocationException) {
                Debug.debug((Throwable)badLocationException);
                return;
            }
            switch (this.action) {
                case 1: {
                    string2 = string.toLowerCase();
                    break;
                }
                case 2: {
                    string2 = string.toUpperCase();
                    break;
                }
                case 3: {
                    string2 = this.capitalize(string);
                    break;
                }
                default: {
                    string2 = this.invertCase(string);
                }
            }
            if (!string.equals(string2)) {
                try {
                    iDocument.replace(point.x, string.length(), string2);
                }
                catch (BadLocationException badLocationException) {
                    Debug.debug((Throwable)badLocationException);
                }
                iSourceViewer.setSelectedRange(point.x, string2.length());
                styledText.showSelection();
            }
        }
    }

    public void update() {
        Point point;
        StyledText styledText;
        IDocument iDocument;
        boolean bl = false;
        ISourceViewer iSourceViewer = this.getViewer();
        if (iSourceViewer != null && (iDocument = iSourceViewer.getDocument()) != null && (styledText = iSourceViewer.getTextWidget()) != null && styledText.isEnabled() && (point = iSourceViewer.getSelectedRange()) != null) {
            bl = point.y > 0;
        }
        this.setEnabled(bl);
    }

    protected ISourceViewer getViewer() {
        if (this.editor == null) {
            return null;
        }
        return this.editor.getViewer();
    }

    protected String capitalize(String string) {
        if (string.length() == 0) {
            return string;
        }
        boolean bl = true;
        boolean bl2 = false;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (Character.isJavaIdentifierPart(c)) {
                c = bl ? Character.toTitleCase(c) : Character.toLowerCase(c);
                bl = false;
                if (c == cArray[i]) continue;
                bl2 = true;
                cArray[i] = c;
                continue;
            }
            bl = true;
        }
        if (bl2) {
            return new String(cArray);
        }
        return string;
    }

    protected String invertCase(String string) {
        if (string.length() == 0) {
            return string;
        }
        boolean bl = false;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (Character.isLowerCase(c)) {
                c = Character.toUpperCase(c);
            } else if (Character.isUpperCase(c)) {
                c = Character.toLowerCase(c);
            }
            if (c == cArray[i]) continue;
            bl = true;
            cArray[i] = c;
        }
        if (bl) {
            return new String(cArray);
        }
        return string;
    }
}

