/*
 * Decompiled with CFR 0.152.
 */
package com.spket.buffer;

import com.spket.buffer.BufferChangedEvent;
import com.spket.buffer.DocumentReader;
import com.spket.buffer.IBuffer;
import com.spket.buffer.IBufferListener;
import com.spket.buffer.IBufferReader;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;

public class DocumentBuffer
implements IBuffer {
    private ListenerList fListeners;
    private IPath path;
    private IDocument fDocument;
    private IDocumentListener fDocumentListener;

    public DocumentBuffer(IPath iPath, IDocument iDocument) {
        this.path = iPath;
        this.fDocument = iDocument;
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    public void close() {
        if (this.fDocumentListener != null) {
            if (this.fDocument != null) {
                this.fDocument.removeDocumentListener(this.fDocumentListener);
            }
            this.fDocumentListener = null;
        }
        if (this.fListeners != null) {
            Object[] objectArray = this.fListeners.getListeners();
            this.fListeners.clear();
            this.fListeners = null;
            for (int i = 0; i < objectArray.length; ++i) {
                ((IBufferListener)objectArray[i]).bufferClosed(this);
            }
        }
    }

    public int getLength() {
        return this.fDocument.getLength();
    }

    public char[] get() {
        if (this.fDocument.getLength() > 0) {
            return this.fDocument.get().toCharArray();
        }
        return null;
    }

    public String get(int n, int n2) {
        try {
            return this.fDocument.get(n, n2);
        }
        catch (BadLocationException badLocationException) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public char get(int n) {
        try {
            return this.fDocument.getChar(n);
        }
        catch (BadLocationException badLocationException) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public IPath getPath() {
        return this.path;
    }

    public IBufferReader createReader() {
        return new DocumentReader(this.fDocument, 0, this.fDocument.getLength());
    }

    public IBufferReader createReader(int n, int n2) {
        return new DocumentReader(this.fDocument, n, n2);
    }

    public void addBufferListener(IBufferListener iBufferListener) {
        if (this.fListeners == null) {
            this.fListeners = new ListenerList(1);
            if (this.fDocumentListener == null) {
                this.fDocumentListener = new DocumentListener();
                this.fDocument.addDocumentListener(this.fDocumentListener);
            }
        }
        this.fListeners.add((Object)iBufferListener);
    }

    public void removeBufferListener(IBufferListener iBufferListener) {
        if (this.fListeners == null) {
            return;
        }
        this.fListeners.remove((Object)iBufferListener);
        if (this.fListeners.isEmpty()) {
            if (this.fDocumentListener != null) {
                this.fDocument.removeDocumentListener(this.fDocumentListener);
                this.fDocumentListener = null;
            }
            this.fListeners = null;
        }
    }

    private class DocumentListener
    implements IDocumentListener {
        private BufferChangedEvent bufferEvent;

        private DocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent documentEvent) {
            BufferChangedEvent bufferChangedEvent = this.bufferEvent = new BufferChangedEvent(DocumentBuffer.this, documentEvent);
            Object[] objectArray = DocumentBuffer.this.fListeners.getListeners();
            for (int i = 0; i < objectArray.length; ++i) {
                ((IBufferListener)objectArray[i]).bufferAboutToBeChanged(bufferChangedEvent);
            }
        }

        public void documentChanged(DocumentEvent documentEvent) {
            BufferChangedEvent bufferChangedEvent = this.bufferEvent;
            if (bufferChangedEvent.getEvent() == documentEvent) {
                this.bufferEvent = null;
            } else {
                bufferChangedEvent = new BufferChangedEvent(DocumentBuffer.this, documentEvent);
            }
            Object[] objectArray = DocumentBuffer.this.fListeners.getListeners();
            for (int i = 0; i < objectArray.length; ++i) {
                ((IBufferListener)objectArray[i]).bufferChanged(bufferChangedEvent);
            }
        }
    }
}

