/*
 * Decompiled with CFR 0.152.
 */
package com.spket.xul.model;

import com.spket.xul.model.XULConstants;
import java.util.HashMap;
import java.util.Map;
import org.apache.xerces.util.SymbolTable;

public class XULHelper
implements XULConstants {
    private static final String[] tags;
    private static final String[] attrs;
    private static Map tagMap;
    private static Map attrMap;

    public static Integer getTagID(String string) {
        if (string == null) {
            return null;
        }
        return (Integer)tagMap.get(string);
    }

    public static int getTagId(String string) {
        Integer n = XULHelper.getTagID(string);
        return n == null ? Integer.MIN_VALUE : n;
    }

    public static String getTagName(int n) {
        if (n > 0 && n <= tags.length) {
            return tags[n - 1];
        }
        return null;
    }

    public static Integer getAttrID(String string) {
        if (string == null) {
            return null;
        }
        return (Integer)attrMap.get(string);
    }

    public static int getAttrId(String string) {
        Integer n = XULHelper.getAttrID(string);
        return n == null ? Integer.MIN_VALUE : n;
    }

    public static String getAttrName(int n) {
        if (n > 0 && n <= attrs.length) {
            return attrs[n - 1];
        }
        return null;
    }

    public static boolean isEventAttribute(String string) {
        return string.length() > 2 && string.startsWith("on");
    }

    public static void initSymbolTable(SymbolTable symbolTable) {
        int n;
        symbolTable.addSymbol("http://www.mozilla.org/xbl");
        symbolTable.addSymbol("http://www.w3.org/1999/xhtml");
        symbolTable.addSymbol("http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul");
        symbolTable.addSymbol("html");
        symbolTable.addSymbol("xbl");
        symbolTable.addSymbol("xul");
        for (n = 0; n < tags.length; ++n) {
            symbolTable.addSymbol(tags[n]);
        }
        for (n = 0; n < attrs.length; ++n) {
            symbolTable.addSymbol(attrs[n]);
        }
    }

    static {
        int n;
        tags = new String[]{"action", "arrowscrollbox", "bbox", "binding", "bindings", "body", "box", "broadcaster", "broadcasterset", "browser", "button", "caption", "checkbox", "children", "colorpicker", "column", "columns", "command", "commandset", "conditions", "constructor", "content", "deck", "description", "destructor", "dialog", "dialogheader", "editor", "field", "getter", "grid", "grippy", "groupbox", "handler", "handlers", "hbox", "iframe", "image", "implementation", "key", "keyset", "label", "listbox", "listcell", "listcol", "listcols", "listhead", "listheader", "listitem", "member", "menu", "menubar", "menuitem", "menulist", "menupopup", "menuseparator", "method", "observes", "overlay", "page", "parameter", "popup", "popupset", "preference", "preferences", "prefpane", "prefwindow", "progressmeter", "property", "radio", "radiogroup", "resizer", "resources", "richlistbox", "richlistitem", "row", "rows", "rule", "script", "scrollbar", "scrollbox", "scrollcorner", "separator", "setter", "spacer", "splitter", "stack", "statusbar", "statusbarpanel", "stringbundle", "stringbundleset", "stylesheet", "tab", "tabbox", "tabbrowser", "tabpanel", "tabpanels", "tabs", "template", "textbox", "textnode", "titlebar", "toolbar", "toolbarbutton", "toolbargrippy", "toolbaritem", "toolbarpalette", "toolbarseparator", "toolbarset", "toolbarspacer", "toolbarspring", "toolbox", "tooltip", "tree", "treecell", "treechildren", "treecol", "treecols", "treeitem", "treerow", "treeseparator", "triple", "vbox", "window", "wizard", "wizardpage"};
        attrs = new String[]{"acceltext", "accessible", "accesskey", "action", "afterselected", "align", "allowevents", "allownegativeassertions", "alternatingbackground", "alwaysopenpopup", "attribute", "autoCheck", "autoFill", "autoFillAfterMatch", "autocheck", "autocompleteenabled", "autocompletepopup", "autocompletesearch", "autocompletesearchparam", "autoscroll", "beforeselected", "button", "buttonaccesskeyaccept", "buttonaccesskeycancel", "buttonaccesskeydisclosure", "buttonaccesskeyextra1", "buttonaccesskeyextra2", "buttonaccesskeyhelp", "buttonalign", "buttondir", "buttonlabelaccept", "buttonlabelcancel", "buttonlabeldisclosure", "buttonlabelextra1", "buttonlabelextra2", "buttonlabelhelp", "buttonorient", "buttonpack", "buttons", "charcode", "checkState", "checked", "class", "clickcount", "closebutton", "coalesceduplicatearcs", "collapse", "collapsed", "color", "cols", "command", "commandupdater", "completedefaultindex", "container", "containment", "contentcontextmenu", "contenttooltip", "context", "contextmenu", "control", "crop", "curpos", "current", "currentset", "customindex", "customizable", "cycler", "datasources", "default", "defaultButton", "defaultset", "description", "dir", "disableAutocomplete", "disableKeyNavigation", "disableautocomplete", "disableautoselect", "disableclose", "disabled", "disablehistory", "disablekeynavigation", "disablesecurity", "display", "dlgType", "dragging", "editable", "editortype", "element", "empty", "enableColumnDrag", "enablehistory", "equalsize", "event", "eventnode", "events", "extends", "first-tab", "firstpage", "fixed", "flags", "flex", "focused", "forceComplete", "forcecomplete", "grippyhidden", "grippytooltiptext", "group", "handleCtrlPageUpDown", "handleCtrlTab", "height", "helpURI", "hidden", "hidechrome", "hidecolumnpicker", "hideheader", "homepage", "icon", "id", "ignoreBlurWhileSearching", "ignorebluewhilesearching", "ignorecolumnpicker", "ignorekeys", "image", "implements", "includes", "increment", "inheritstyle", "inputtooltiptext", "insertafter", "insertbefore", "instantApply", "inverted", "iscontainer", "isempty", "key", "keycode", "keytext", "label", "last-tab", "lastSelected", "lastpage", "left", "linkedpanel", "maxheight", "maxlength", "maxpos", "maxrows", "maxwidth", "member", "menu", "menuactive", "minResultsForPopup", "minheight", "minresultsforpopup", "minwidth", "mode", "modifiers", "mousethrough", "multiline", "name", "next", "noautohide", "nomatch", "observes", "onbeforeaccept", "onbookmarkgroup", "onchange", "onclosetab", "oncommand", "oncommandupdate", "ondialogaccept", "ondialogcancel", "ondialogclosure", "ondialoghelp", "onerror", "onerrorcommand", "onget", "oninput", "onload", "onnewtab", "onpageadvanced", "onpagehide", "onpagerewound", "onpageshow", "onpanelload", "onpopuphidden", "onpopuphiding", "onpopupshowing", "onpopupshown", "onsearchcomplete", "onselect", "onset", "ontextcommand", "ontextentered", "ontextrevert", "ontextreverted", "onwizardback", "onwizardcancel", "onwizardfinish", "onwizardnext", "open", "ordinal", "orient", "pack", "pageid", "pageincrement", "pagestep", "parent", "parsetype", "persist", "phase", "pickertooltiptext", "popup", "position", "preference", "preference-editable", "preventdefault", "primary", "properties", "readonly", "ref", "removeelement", "resizeafter", "resizebefore", "rows", "screenX", "screenY", "searchSessions", "selected", "selectedIndex", "seltype", "setfocus", "showCommentColumn", "showcommentcolumn", "showpopup", "size", "sizemode", "sizetopopup", "sort", "sortActive", "sortDirection", "sortResource", "sortResource2", "src", "state", "statedatasource", "statusbar", "statustext", "style", "substate", "suppressonselect", "tabindex", "tabscrolling", "targets", "template", "timeout", "title", "toolbarname", "tooltip", "tooltiptext", "tooltiptextnew", "top", "type", "uri", "userAction", "validate", "value", "wait-cursor", "width", "windowtype", "wrap"};
        tagMap = new HashMap(tags.length);
        attrMap = new HashMap(attrs.length);
        for (n = 0; n < tags.length; ++n) {
            tagMap.put(tags[n], new Integer(n + 1));
        }
        for (n = 0; n < attrs.length; ++n) {
            attrMap.put(attrs[n], new Integer(n + 1));
        }
    }
}

