/*
 * Decompiled with CFR 0.152.
 */
package com.spket.xul.internal;

import com.spket.ui.text.TextTools;
import com.spket.xul.text.XULTextTools;
import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class XULPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.spket.xul";
    private static final String TEMPLATES_KEY = "com.spket.xultmpl";
    private static XULPlugin plugin;
    private TextTools fTextTools;
    private TemplateStore fTemplateStore;
    private ContextTypeRegistry fContextTypeRegistry;

    public static XULPlugin getDefault() {
        return plugin;
    }

    public static void log(IStatus iStatus) {
        plugin.getLog().log(iStatus);
    }

    public static void log(Throwable throwable) {
        XULPlugin.log((IStatus)new Status(4, PLUGIN_ID, 0, "Internal", throwable));
    }

    public static void logErrorMessage(String string) {
        XULPlugin.log((IStatus)new Status(4, PLUGIN_ID, 0, string, null));
    }

    public XULPlugin() {
        plugin = this;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        plugin = null;
        if (this.fTemplateStore != null) {
            this.fTemplateStore.stopListeningForPreferenceChanges();
            this.fTemplateStore = null;
        }
        super.stop(bundleContext);
    }

    public synchronized TextTools getTextTools() {
        if (this.fTextTools == null) {
            this.fTextTools = new XULTextTools(this.getPreferenceStore());
        }
        return this.fTextTools;
    }

    public ContextTypeRegistry getTemplateContextRegistry() {
        if (this.fContextTypeRegistry == null) {
            ContributionContextTypeRegistry contributionContextTypeRegistry = new ContributionContextTypeRegistry();
            this.fContextTypeRegistry = contributionContextTypeRegistry;
            contributionContextTypeRegistry.addContextType("xbl");
            contributionContextTypeRegistry.addContextType("xul");
        }
        return this.fContextTypeRegistry;
    }

    public TemplateStore getTemplateStore() {
        if (this.fTemplateStore == null) {
            IPreferenceStore iPreferenceStore = this.getPreferenceStore();
            this.fTemplateStore = new ContributionTemplateStore(this.getTemplateContextRegistry(), iPreferenceStore, TEMPLATES_KEY);
            try {
                this.fTemplateStore.load();
            }
            catch (IOException iOException) {
                XULPlugin.log(iOException);
            }
            this.fTemplateStore.startListeningForPreferenceChanges();
        }
        return this.fTemplateStore;
    }
}

