/*
 * Decompiled with CFR 0.152.
 */
package com.spket.util;

import com.spket.util.ByteArrayBuffer;
import com.spket.util.Debug;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Stack;
import java.util.StringTokenizer;

public class FileUtils {
    public static final int BUFFER_SIZE = 8192;
    private char separatorChar;

    public static InputStream cache(InputStream inputStream) {
        return new CachedInputStream(inputStream);
    }

    public FileUtils() {
        this(File.separatorChar);
    }

    public FileUtils(char c) {
        this.separatorChar = c;
    }

    public String resolve(String string, String string2) {
        File file = new File(string);
        return this.resolve(string, string2, file.isFile());
    }

    public String resolve(String string, String string2, boolean bl) {
        char c;
        String string3 = string2;
        boolean bl2 = false;
        int n = string3.indexOf(58);
        if (n > 0) {
            string3 = string3.substring(n + 1);
        }
        if (string3.length() > 0 && ((c = string3.charAt(0)) == this.separatorChar || c == '/' || c == '\\')) {
            bl2 = true;
        }
        if (bl2) {
            string3 = n > 1 ? string2 : this.normalize(string2);
        } else {
            string = this.convertSeparator(string);
            if (bl && (n = string.lastIndexOf(this.separatorChar)) < string.length() - 1) {
                string = string.substring(0, n + 1);
            }
            string3 = this.normalize(new File(string, string3).getAbsolutePath());
        }
        return string3;
    }

    public String normalize(String string) {
        string = this.convertSeparator(string);
        StringBuffer stringBuffer = new StringBuffer();
        if (string.length() >= 2 && string.charAt(1) == ':') {
            stringBuffer.append(Character.toUpperCase(string.charAt(0))).append(':');
            string = string.substring(2);
        }
        Stack<String> stack = new Stack<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, String.valueOf(this.separatorChar));
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ("..".equals(string2)) {
                stack.pop();
                continue;
            }
            if (".".equals(string2)) continue;
            stack.push(string2);
        }
        for (int i = 0; i < stack.size(); ++i) {
            stringBuffer.append(this.separatorChar);
            stringBuffer.append(stack.get(i));
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ByteArrayOutputStream cacheStream(String string) throws IOException {
        long l;
        int n = 0;
        File file = new File(string);
        if (file.isFile() && (l = file.length()) > 0L) {
            n = (int)l;
        }
        ByteArrayBuffer byteArrayBuffer = null;
        if (n <= 0) return byteArrayBuffer;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            byteArrayBuffer = new ByteArrayBuffer(n);
            this.fillStream(fileInputStream, byteArrayBuffer);
            Object var7_7 = null;
            if (fileInputStream == null) return byteArrayBuffer;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (fileInputStream == null) throw throwable;
            try {
                ((InputStream)fileInputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            ((InputStream)fileInputStream).close();
            return byteArrayBuffer;
        }
        catch (IOException iOException) {}
        return byteArrayBuffer;
    }

    public ByteArrayOutputStream cacheStream(InputStream inputStream) throws IOException {
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(8192);
        this.fillStream(inputStream, byteArrayBuffer);
        return byteArrayBuffer;
    }

    protected void fillStream(InputStream inputStream, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        int n;
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
    }

    protected String convertSeparator(String string) {
        if (this.separatorChar != '/') {
            string = string.replace('/', this.separatorChar);
        }
        if (this.separatorChar != '\\') {
            string = string.replace('\\', this.separatorChar);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public char[] getContents(String string) throws IOException {
        char[] cArray = ByteArrayBuffer.NO_CHARS;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            cArray = this.getContents(fileInputStream, null);
            Object var5_4 = null;
            if (fileInputStream == null) return cArray;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                Debug.warn(iOException);
            }
            throw throwable;
        }
        try {
            fileInputStream.close();
            return cArray;
        }
        catch (IOException iOException) {
            Debug.warn(iOException);
        }
        return cArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public char[] getContentsFromURL(String string) throws IOException {
        InputStream inputStream = null;
        char[] cArray = ByteArrayBuffer.NO_CHARS;
        URL uRL = new URL(string);
        try {
            inputStream = uRL.openStream();
            cArray = this.getContents(inputStream, null);
            Object var6_5 = null;
            if (inputStream == null) return cArray;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                Debug.warn(iOException);
            }
            throw throwable;
        }
        try {
            inputStream.close();
            return cArray;
        }
        catch (IOException iOException) {
            Debug.warn(iOException);
        }
        return cArray;
    }

    public char[] getContents(InputStream inputStream, String string) throws IOException {
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(8192);
        this.fillStream(inputStream, byteArrayBuffer);
        return byteArrayBuffer.toCharArray(string);
    }

    public char[] getContents(Reader reader) throws IOException {
        int n;
        char[] cArray = new char[8192];
        CharArrayWriter charArrayWriter = new CharArrayWriter(8192);
        while ((n = reader.read(cArray)) != -1) {
            charArrayWriter.write(cArray, 0, n);
        }
        return charArrayWriter.toCharArray();
    }

    private static final class CachedInputStream
    extends InputStream {
        protected int pos;
        protected int count;
        protected boolean cached;
        protected boolean eof;
        protected InputStream in;
        protected byte[] buf = new byte[0];

        public CachedInputStream(InputStream inputStream) {
            this.in = inputStream;
            this.cached = true;
        }

        public int available() throws IOException {
            return this.count - this.pos + this.in.available();
        }

        public void reset() throws IOException {
            if (this.cached) {
                this.pos = 0;
                this.cached = false;
            }
        }

        public void close() throws IOException {
            if (this.cached) {
                return;
            }
            this.buf = null;
            if (this.in == null) {
                return;
            }
            InputStream inputStream = this.in;
            this.in = null;
            inputStream.close();
        }

        public int read() throws IOException {
            this.ensureOpen();
            int n = -1;
            if (this.cached) {
                if (this.pos >= this.count) {
                    this.cache();
                    if (this.pos >= this.count) {
                        return -1;
                    }
                }
                n = this.buf[this.pos++] & 0xFF;
            } else {
                n = this.pos < this.count ? this.buf[this.pos++] & 0xFF : this.in.read();
            }
            return n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            this.ensureOpen();
            int n3 = -1;
            if (this.cached) {
                int n4;
                if (this.pos + n2 - 1 >= this.count) {
                    this.cache();
                    if (this.pos >= this.count) {
                        return -1;
                    }
                }
                n3 = (n4 = this.count - this.pos) < n2 ? n4 : n2;
                System.arraycopy(this.buf, this.pos, byArray, n, n3);
                this.pos += n3;
            } else {
                int n5 = this.count - this.pos;
                if (n5 > 0) {
                    n3 = n5 < n2 ? n5 : n2;
                    System.arraycopy(this.buf, this.pos, byArray, n, n3);
                    if (n5 < n2 && (n5 = this.in.read(byArray, n + n5, n2 - n5)) != -1) {
                        n3 += n5;
                    }
                    this.pos += n3;
                } else {
                    n3 = this.in.read(byArray, n, n2);
                }
            }
            return n3;
        }

        public int getCount() {
            return this.count;
        }

        public int get(int n) {
            if (n < 0 || n >= this.count) {
                return -1;
            }
            return this.buf[n];
        }

        public long skip(long l) throws IOException {
            if (l <= 0L) {
                return 0L;
            }
            long l2 = this.count - this.pos;
            if (l2 < l) {
                if (this.cached) {
                    this.cache();
                }
            } else {
                this.pos = (int)((long)this.pos + l);
            }
            return l;
        }

        protected void cache() throws IOException {
            if (this.eof) {
                return;
            }
            byte[] byArray = new byte[this.count + 8192];
            if (this.count > 0) {
                System.arraycopy(this.buf, 0, byArray, 0, this.count);
            }
            this.buf = byArray;
            int n = this.in.read(this.buf, this.count, 8192);
            if (n == -1 || n < 8192) {
                this.eof = true;
            }
            if (n > 0) {
                this.count = n + this.count;
            }
        }

        private void ensureOpen() throws IOException {
            if (this.in == null) {
                throw new IOException("Stream closed");
            }
        }
    }
}

