/*
 * Decompiled with CFR 0.152.
 */
package com.spket.wpfe.model.render;

import com.spket.as.internal.compiler.util.HashtableOfInt;
import com.spket.buffer.IBuffer;
import com.spket.util.StringUtils;
import com.spket.wpfe.model.WPFEHelper;
import com.spket.wpfe.model.render.BrushHandler;
import com.spket.wpfe.model.render.Canvas;
import com.spket.wpfe.model.render.PathParser;
import com.spket.wpfe.model.render.TransformHandler;
import com.spket.wpfe.model.render.UIElement;
import com.spket.wpfe.model.render.XAMLHandler;
import com.spket.wpfe.model.render.XShape;
import com.spket.xml.IModelChangedListener;
import com.spket.xml.ModelChangedEvent;
import com.spket.xml.XMLAttr;
import com.spket.xml.XMLElement;
import com.spket.xml.XMLModel;
import com.spket.xml.XMLNode;
import com.spket.xml.XMLUtils;
import java.awt.BasicStroke;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

public class XAMLModelSynchronizer
implements IModelChangedListener {
    private XMLModel fModel;
    private IBuffer fBuffer;
    private PathParser pathParser = new PathParser();
    private boolean changed = false;

    public void setModel(XMLModel xMLModel) {
        if (this.fModel == xMLModel) {
            return;
        }
        if (this.fModel != null) {
            this.fModel.removeModelChangedListener((IModelChangedListener)this);
        }
        this.fModel = xMLModel;
        if (this.fModel != null) {
            this.fModel.addModelChangedListener((IModelChangedListener)this);
        }
        this.changed = true;
    }

    public void dispose() {
        if (this.fModel != null) {
            this.fModel.removeModelChangedListener((IModelChangedListener)this);
            this.fModel = null;
        }
        this.fBuffer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modelChanged(ModelChangedEvent modelChangedEvent) {
        XAMLModelSynchronizer xAMLModelSynchronizer = this;
        synchronized (xAMLModelSynchronizer) {
            this.changed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIElement build() {
        XAMLModelSynchronizer xAMLModelSynchronizer;
        if (this.changed) {
            xAMLModelSynchronizer = this;
            synchronized (xAMLModelSynchronizer) {
                this.changed = false;
            }
        }
        if (this.fModel == null) {
            return null;
        }
        this.fBuffer = this.fModel.getBuffer();
        if (this.fBuffer == null) {
            return null;
        }
        xAMLModelSynchronizer = this.fModel.getXMLDocument();
        if (xAMLModelSynchronizer == null) {
            return null;
        }
        XMLElement xMLElement = xAMLModelSynchronizer.getDocumentElement();
        if (xMLElement == null) {
            return null;
        }
        if (!this.changed) {
            return this.create(xMLElement, null, true);
        }
        return null;
    }

    public boolean isSynchronized() {
        return !this.changed;
    }

    protected UIElement create(XMLElement xMLElement, UIElement uIElement, boolean bl) {
        UIElement uIElement2 = null;
        String string = xMLElement.getLocalName();
        int n = WPFEHelper.getTagId(string);
        block0 : switch (n) {
            case 5: {
                if (!bl) break;
                uIElement2 = new Canvas();
                break;
            }
            case 24: 
            case 152: {
                if (!bl) break;
                uIElement2 = new XShape(1);
                break;
            }
            case 75: 
            case 109: 
            case 131: 
            case 139: {
                if (!bl) break;
                uIElement2 = new XShape(0);
                break;
            }
            default: {
                int n2;
                if (uIElement == null || (n2 = string.indexOf(46)) <= 0) break;
                int n3 = WPFEHelper.getAttrId(string.substring(n2 + 1));
                switch (n3) {
                    case 118: {
                        AffineTransform affineTransform = TransformHandler.handle(xMLElement);
                        if (affineTransform == null) break block0;
                        uIElement.setRenderTransform(affineTransform);
                        break block0;
                    }
                    case 44: {
                        Paint paint;
                        if (!(uIElement instanceof XShape) || (paint = BrushHandler.handle(xMLElement)) == null) break block0;
                        ((XShape)uIElement).setBackground(paint);
                        break block0;
                    }
                    case 142: {
                        Paint paint;
                        if (!(uIElement instanceof XShape) || (paint = BrushHandler.handle(xMLElement)) == null) break block0;
                        ((XShape)uIElement).setForeground(paint);
                        break block0;
                    }
                    case 10: {
                        Paint paint;
                        if (!(uIElement instanceof Canvas) || (paint = BrushHandler.handle(xMLElement)) == null) break block0;
                        ((Canvas)uIElement).setBackground(paint);
                        break block0;
                    }
                    case 32: {
                        Shape shape;
                        if (!(uIElement instanceof XShape) || (shape = this.pathParser.parse(xMLElement, false)) == null) break block0;
                        ((XShape)uIElement).setShape(shape);
                        break block0;
                    }
                }
            }
        }
        if (!this.changed && uIElement2 != null) {
            this.build(xMLElement, uIElement2);
        }
        return uIElement2;
    }

    protected void build(XMLElement xMLElement, UIElement uIElement) {
        Object object;
        Object object2;
        XShape xShape = null;
        HashtableOfInt hashtableOfInt = null;
        int n = xMLElement.getAttrCount();
        if (n > 0) {
            if (uIElement instanceof XShape) {
                xShape = (XShape)uIElement;
            }
            object2 = xMLElement.getAttrs();
            block25: for (int i = 0; i < n; ++i) {
                XMLAttr xMLAttr = object2[i];
                int n2 = WPFEHelper.getAttrId(xMLAttr.getName());
                switch (n2) {
                    case 166: {
                        uIElement.setVisible(this.toBoolean(xMLAttr));
                        continue block25;
                    }
                    case 16: {
                        uIElement.setX(this.toDouble(xMLAttr));
                        continue block25;
                    }
                    case 17: {
                        uIElement.setY(this.toDouble(xMLAttr));
                        continue block25;
                    }
                    case 18: {
                        uIElement.setZIndex(this.toInt(xMLAttr));
                        continue block25;
                    }
                    case 168: {
                        uIElement.setWidth(this.toDouble(xMLAttr));
                        continue block25;
                    }
                    case 59: {
                        uIElement.setHeight(this.toDouble(xMLAttr));
                        continue block25;
                    }
                    case 119: {
                        uIElement.setTransformOrigin(XAMLHandler.toPoint(xMLAttr));
                        continue block25;
                    }
                    case 44: {
                        if (xShape == null) continue block25;
                        xShape.setBackground(XAMLHandler.toColor(xMLAttr));
                        continue block25;
                    }
                    case 10: {
                        if (!(uIElement instanceof Canvas)) continue block25;
                        ((Canvas)uIElement).setBackground(XAMLHandler.toColor(xMLAttr));
                        continue block25;
                    }
                    case 142: {
                        if (xShape == null) continue block25;
                        xShape.setForeground(XAMLHandler.toColor(xMLAttr));
                        continue block25;
                    }
                    case 101: {
                        uIElement.setOpacity(this.toFloat(xMLAttr));
                        continue block25;
                    }
                    case 141: {
                        if (xShape == null) continue block25;
                        xShape.setStretch(XAMLHandler.toStretch(xMLAttr));
                        continue block25;
                    }
                    case 118: {
                        uIElement.setRenderTransform(TransformHandler.toTransform(xMLAttr));
                        continue block25;
                    }
                    case 102: {
                        continue block25;
                    }
                    case 24: {
                        continue block25;
                    }
                    case 32: {
                        if (xShape == null) continue block25;
                        xShape.setShape(this.pathParser.parse(this.getValue(xMLAttr)));
                        continue block25;
                    }
                    case 111: {
                        if (xShape == null || (object = XAMLHandler.toPoints(xMLAttr)) == null) continue block25;
                        GeneralPath generalPath = new GeneralPath(1, ((double[])object).length + 2);
                        generalPath.moveTo((float)object[0], (float)object[1]);
                        for (int j = 2; j < ((double[])object).length; j += 2) {
                            generalPath.lineTo((float)object[j], (float)object[j + 1]);
                        }
                        if ("Polygon".equals(xMLElement.getLocalName())) {
                            generalPath.closePath();
                        }
                        xShape.setShape(generalPath);
                        continue block25;
                    }
                    case 114: 
                    case 115: 
                    case 150: 
                    case 170: 
                    case 171: 
                    case 176: 
                    case 177: {
                        if (xShape == null || (object = (Object)this.getValue(xMLAttr)) == null) continue block25;
                        if (hashtableOfInt == null) {
                            hashtableOfInt = new HashtableOfInt(5);
                        }
                        hashtableOfInt.put(n2, object);
                    }
                }
            }
        }
        if (this.changed) {
            return;
        }
        n = xMLElement.getChildrenCount();
        if (n > 0) {
            object2 = null;
            if (uIElement instanceof Canvas) {
                object2 = (Canvas)uIElement;
            }
            XMLNode[] xMLNodeArray = xMLElement.getChildren();
            for (int i = 0; i < n && !this.changed; ++i) {
                XMLNode xMLNode = xMLNodeArray[i];
                if (1 != xMLNode.getNodeType() || (object = (Object)((Object)this.create((XMLElement)xMLNode, uIElement, object2 != null))) == null || object2 == null) continue;
                ((Canvas)((Object)object2)).addChild((UIElement)((Object)object));
            }
        }
        if (!this.changed && xShape != null) {
            float f;
            String string;
            double d = xShape.getWidth();
            double d2 = xShape.getHeight();
            int n3 = WPFEHelper.getTagId(xMLElement.getLocalName());
            switch (n3) {
                case 152: {
                    if (!(d > 0.0) || !(d2 > 0.0)) break;
                    double d3 = 0.0;
                    double d4 = 0.0;
                    if (hashtableOfInt != null) {
                        d3 = StringUtils.toDouble((String)((String)hashtableOfInt.get(114)));
                        d4 = StringUtils.toDouble((String)((String)hashtableOfInt.get(115)));
                    }
                    if (d3 == 0.0 || d4 == 0.0) {
                        xShape.setShape(new Rectangle2D.Double(0.0, 0.0, d, d2));
                        break;
                    }
                    xShape.setShape(new RoundRectangle2D.Double(0.0, 0.0, xShape.getWidth(), xShape.getHeight(), d3 * 2.0, d4 * 2.0));
                    break;
                }
                case 75: {
                    if (hashtableOfInt == null) break;
                    double d5 = 0.0;
                    double d6 = 0.0;
                    double d7 = 0.0;
                    double d8 = 0.0;
                    d5 = StringUtils.toDouble((String)((String)hashtableOfInt.get(170)));
                    d6 = StringUtils.toDouble((String)((String)hashtableOfInt.get(171)));
                    d7 = StringUtils.toDouble((String)((String)hashtableOfInt.get(176)));
                    d8 = StringUtils.toDouble((String)((String)hashtableOfInt.get(177)));
                    xShape.setShape(new Line2D.Double(d5, d7, d6, d8));
                    break;
                }
                case 24: {
                    if (!(d > 0.0) || !(d2 > 0.0)) break;
                    xShape.setShape(new Ellipse2D.Double(0.0, 0.0, d, d2));
                }
            }
            if (hashtableOfInt != null && xShape.getShape() != null && (string = (String)hashtableOfInt.get(150)) != null && (f = StringUtils.toFloat((String)string, (float)1.0f)) > 0.0f && f != 1.0f) {
                xShape.setStroke(new BasicStroke(f, 0, 0));
            }
        }
    }

    protected int toInt(XMLAttr xMLAttr) {
        return StringUtils.toInt((String)this.getValue(xMLAttr));
    }

    protected boolean toBoolean(XMLAttr xMLAttr) {
        return StringUtils.toBoolean((String)this.getValue(xMLAttr));
    }

    protected double toDouble(XMLAttr xMLAttr) {
        return StringUtils.toDouble((String)this.getValue(xMLAttr));
    }

    protected float toFloat(XMLAttr xMLAttr) {
        return StringUtils.toFloat((String)this.getValue(xMLAttr));
    }

    protected String getValue(XMLAttr xMLAttr) {
        return XMLUtils.getValue((XMLAttr)xMLAttr);
    }
}

