/*
 * Decompiled with CFR 0.152.
 */
package com.spket.wpfe.model.render;

import com.spket.as.internal.compiler.util.HashtableOfInt;
import com.spket.util.StringUtils;
import com.spket.wpfe.model.WPFEHelper;
import com.spket.wpfe.model.render.XAMLHandler;
import com.spket.xml.XMLAttr;
import com.spket.xml.XMLElement;
import com.spket.xml.XMLNode;
import com.spket.xml.XMLUtils;
import java.awt.geom.AffineTransform;

public class TransformHandler {
    public static AffineTransform toTransform(XMLAttr xMLAttr) {
        return TransformHandler.toTransform(XMLUtils.getValue((XMLAttr)xMLAttr));
    }

    public static AffineTransform toTransform(String string) {
        double[] dArray = XAMLHandler.toPoints(string);
        if (dArray != null && dArray.length == 6) {
            return new AffineTransform(dArray);
        }
        return null;
    }

    public static AffineTransform handle(XMLElement xMLElement) {
        int n = xMLElement.getChildrenCount();
        if (n > 0) {
            AffineTransform affineTransform = new AffineTransform();
            XMLNode[] xMLNodeArray = xMLElement.getChildren();
            for (int i = 0; i < n; ++i) {
                XMLNode xMLNode = xMLNodeArray[i];
                if (1 != xMLNode.getNodeType()) continue;
                TransformHandler.setTransform((XMLElement)xMLNode, affineTransform);
            }
            if (!affineTransform.isIdentity()) {
                return affineTransform;
            }
        }
        return null;
    }

    protected static void setTransform(XMLElement xMLElement, AffineTransform affineTransform) {
        int n = WPFEHelper.getTagId(xMLElement.getLocalName());
        switch (n) {
            case 203: {
                if (xMLElement.getChildrenCount() <= 0) break;
                int n2 = xMLElement.getChildrenCount();
                XMLNode[] xMLNodeArray = xMLElement.getChildren();
                for (int i = 0; i < n2; ++i) {
                    XMLNode xMLNode = xMLNodeArray[i];
                    if (1 != xMLNode.getNodeType()) continue;
                    TransformHandler.setTransform((XMLElement)xMLNode, affineTransform);
                }
                break;
            }
            case 163: {
                double d;
                HashtableOfInt hashtableOfInt = XAMLHandler.getAttributes(xMLElement);
                if (hashtableOfInt == null || (d = StringUtils.toDouble((String)((String)hashtableOfInt.get(4)))) == 0.0) break;
                double d2 = StringUtils.toDouble((String)((String)hashtableOfInt.get(20)), (double)0.0);
                double d3 = StringUtils.toDouble((String)((String)hashtableOfInt.get(21)), (double)0.0);
                affineTransform.preConcatenate(AffineTransform.getRotateInstance(Math.toRadians(d), d2, d3));
                break;
            }
            case 205: {
                HashtableOfInt hashtableOfInt = XAMLHandler.getAttributes(xMLElement);
                if (hashtableOfInt == null) break;
                double d = StringUtils.toDouble((String)((String)hashtableOfInt.get(169)));
                double d4 = StringUtils.toDouble((String)((String)hashtableOfInt.get(175)));
                if (d == 0.0 && d4 == 0.0) break;
                affineTransform.preConcatenate(AffineTransform.getTranslateInstance(d, d4));
                break;
            }
            case 168: {
                HashtableOfInt hashtableOfInt = XAMLHandler.getAttributes(xMLElement);
                if (hashtableOfInt == null) break;
                double d = StringUtils.toDouble((String)((String)hashtableOfInt.get(125)), (double)1.0);
                double d5 = StringUtils.toDouble((String)((String)hashtableOfInt.get(126)), (double)1.0);
                if (d == 1.0 && d5 == 1.0) break;
                double d6 = StringUtils.toDouble((String)((String)hashtableOfInt.get(20)), (double)0.0);
                double d7 = StringUtils.toDouble((String)((String)hashtableOfInt.get(21)), (double)0.0);
                if (d6 != 0.0 || d7 != 0.0) {
                    AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(d6, d7);
                    affineTransform2.scale(d, d5);
                    affineTransform2.translate(-d6, -d7);
                    affineTransform.preConcatenate(affineTransform2);
                    break;
                }
                affineTransform.preConcatenate(AffineTransform.getScaleInstance(d, d5));
                break;
            }
            case 169: {
                HashtableOfInt hashtableOfInt = XAMLHandler.getAttributes(xMLElement);
                if (hashtableOfInt == null) break;
                double d = StringUtils.toDouble((String)((String)hashtableOfInt.get(5)), (double)0.0);
                double d8 = StringUtils.toDouble((String)((String)hashtableOfInt.get(6)), (double)0.0);
                if (d != 0.0 || d8 != 0.0) {
                    if (d != 0.0) {
                        d = Math.tan(Math.toRadians(d));
                    }
                    if (d8 != 0.0) {
                        d8 = Math.tan(Math.toRadians(d8));
                    }
                }
                double d9 = StringUtils.toDouble((String)((String)hashtableOfInt.get(20)), (double)0.0);
                double d10 = StringUtils.toDouble((String)((String)hashtableOfInt.get(21)), (double)0.0);
                if (d9 != 0.0 || d10 != 0.0) {
                    AffineTransform affineTransform3 = AffineTransform.getTranslateInstance(d10, d10);
                    affineTransform3.shear(d, d8);
                    affineTransform3.translate(-d10, -d10);
                    affineTransform.preConcatenate(affineTransform3);
                    break;
                }
                affineTransform.preConcatenate(AffineTransform.getShearInstance(d, d8));
                break;
            }
            case 97: {
                AffineTransform affineTransform4 = TransformHandler.toTransform(XMLUtils.getAttrValue((XMLElement)xMLElement, (String)"Matrix"));
                if (affineTransform4 == null) break;
                affineTransform.preConcatenate(affineTransform4);
            }
        }
    }
}

