/*
 * Decompiled with CFR 0.152.
 */
package com.spket.wpfe.internal.editors;

import com.spket.ui.internal.UIMessages;
import com.spket.ui.part.IPart;
import com.spket.ui.part.PartAdapter;
import com.spket.ui.part.PartForm;
import com.spket.wpfe.internal.editors.XAMLDesignPart;
import com.spket.wpfe.model.XAMLManager;
import com.spket.wpfe.model.XAMLModel;
import com.spket.xml.XMLModel;
import com.spket.xml.editors.XMLEditor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

public class XAMLEditor
extends XMLEditor {
    private PartForm partForm;
    private IPart fSourcePart;
    private IPart fDesignPart;
    private IPart fCurrentPart;
    private PartListener fPartListener;

    public void createPartControl(Composite composite) {
        this.partForm = new PartForm(composite);
        this.partForm.setShowTitle(false);
        this.partForm.setHandleMouseDoubleClick(false);
        Composite composite2 = new Composite((Composite)this.partForm, 0);
        composite2.setLayout((Layout)new FillLayout());
        super.createPartControl(composite2);
        this.fSourcePart = new PartAdapter((Control)composite2, UIMessages.SourcePage_title, null);
        this.fDesignPart = this.createDesignPart();
        this.changeLayout();
        IPart iPart = this.partForm.getActivePart();
        if (iPart == null) {
            iPart = this.fSourcePart;
        }
        iPart.setFocus();
        this.setActivePart(iPart);
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        super.init(iEditorSite, iEditorInput);
        this.fPartListener = new PartListener(iEditorSite.getWorkbenchWindow().getPartService());
    }

    public void dispose() {
        XAMLManager xAMLManager = XAMLManager.getDefault();
        xAMLManager.releaseWorkingCopy(this.getModel());
        if (this.fPartListener != null) {
            this.fPartListener.dispose();
            this.fPartListener = null;
        }
        if (this.fDesignPart != null) {
            this.fDesignPart.dispose();
            this.fDesignPart = null;
        }
        super.dispose();
    }

    protected void doSetInput(IEditorInput iEditorInput) throws CoreException {
        XAMLManager xAMLManager = XAMLManager.getDefault();
        xAMLManager.releaseWorkingCopy(this.getModel());
        super.doSetInput(iEditorInput);
        xAMLManager.becomeWorkingCopy(this.getModel());
    }

    protected XMLModel createModel() {
        return new XAMLModel();
    }

    protected IPart createDesignPart() {
        return new XAMLDesignPart(this);
    }

    protected IPart getPart(String string) {
        if ("view.source".equals(string)) {
            return this.fSourcePart;
        }
        if ("view.design".equals(string)) {
            return this.fDesignPart;
        }
        return null;
    }

    protected void setActivePart(IPart iPart) {
        if (this.fCurrentPart == iPart) {
            return;
        }
        this.fCurrentPart = iPart;
        if (this.fCurrentPart != null) {
            // empty if block
        }
    }

    protected void changeLayout() {
        this.partForm.setRedraw(false);
        IPart iPart = this.partForm.getActivePart();
        this.partForm.removeAll();
        this.partForm.addPart(this.fSourcePart, 0);
        this.partForm.addPart(this.fDesignPart, this.fSourcePart, 2);
        if (iPart == null) {
            this.partForm.showPart(this.fDesignPart, false);
            this.partForm.showPart(this.fSourcePart, false);
        } else {
            this.partForm.showPart(iPart);
        }
        this.partForm.layout(true);
        this.partForm.setRedraw(true);
    }

    private class PartListener
    implements IPartListener {
        private IPartService fPartService;

        public PartListener(IPartService iPartService) {
            this.fPartService = iPartService;
            this.fPartService.addPartListener((IPartListener)this);
        }

        public void dispose() {
            if (this.fPartService != null) {
                this.fPartService.removePartListener((IPartListener)this);
                this.fPartService = null;
            }
        }

        public void partActivated(IWorkbenchPart iWorkbenchPart) {
        }

        public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
            if (XAMLEditor.this.fDesignPart instanceof XAMLDesignPart) {
                ((XAMLDesignPart)XAMLEditor.this.fDesignPart).clear();
            }
        }

        public void partClosed(IWorkbenchPart iWorkbenchPart) {
        }

        public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
        }

        public void partOpened(IWorkbenchPart iWorkbenchPart) {
        }
    }
}

