/*
 * Decompiled with CFR 0.152.
 */
package com.spket.wpfe.internal.editors;

import com.spket.ui.part.IPart;
import com.spket.util.IRenderer;
import com.spket.util.Renderer;
import com.spket.widget.UIUtils;
import com.spket.wpfe.internal.editors.XAMLEditor;
import com.spket.wpfe.model.render.UIElement;
import com.spket.wpfe.model.render.XAMLModelSynchronizer;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Widget;

public class XAMLDesignPart
implements IPart {
    private static final int PAGE_BORDER = 20;
    private XAMLEditor fEditor;
    private UIElement fWidget;
    private java.awt.Color bgColor;
    private Canvas fCanvas;
    private BufferedImage fCachedImage;
    private int flags = 0;
    private int fOffsetX;
    private int fOffsetY;
    private int fX;
    private int fY;
    private int fWidth;
    private int fHeight;
    private double sx = 1.0;
    private double sy = 1.0;
    private XAMLModelSynchronizer fModelSynchronizer = new XAMLModelSynchronizer();

    public XAMLDesignPart(XAMLEditor xAMLEditor) {
        this.fEditor = xAMLEditor;
    }

    public void createPartControl(Composite composite) {
        ScrollBar scrollBar;
        this.fCanvas = new Canvas(composite, 1311488);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 9: {
                        XAMLDesignPart.this.onPaint(event);
                        break;
                    }
                    case 26: {
                        XAMLDesignPart.this.onActive(event);
                        break;
                    }
                    case 11: {
                        XAMLDesignPart.this.onResize(event);
                        break;
                    }
                    case 13: {
                        XAMLDesignPart.this.onMenuClicked(event);
                    }
                }
            }
        };
        Color color = composite.getDisplay().getSystemColor(18);
        RGB rGB = color.getRGB();
        this.bgColor = new java.awt.Color(rGB.red, rGB.green, rGB.blue);
        this.fCanvas.setBackground(color);
        Menu menu = new Menu((Control)this.fCanvas);
        this.fCanvas.setMenu(menu);
        this.fCanvas.addListener(9, listener);
        this.fCanvas.addListener(26, listener);
        this.fCanvas.addListener(11, listener);
        ScrollBar scrollBar2 = this.fCanvas.getHorizontalBar();
        if (scrollBar2 != null) {
            scrollBar2.setIncrement(10);
            scrollBar2.setPageIncrement(50);
            scrollBar2.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    XAMLDesignPart.this.hScroll();
                }
            });
        }
        if ((scrollBar = this.fCanvas.getVerticalBar()) != null) {
            scrollBar.setIncrement(10);
            scrollBar.setPageIncrement(50);
            scrollBar.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    XAMLDesignPart.this.vScroll();
                }
            });
        }
        this.addZoomMenu(menu, listener);
        this.fModelSynchronizer.setModel(this.fEditor.getModel());
    }

    protected void addZoomMenu(Menu menu, Listener listener) {
        int[] nArray = new int[]{10, 25, 50, 75, 100, 125, 150, 175, 200, 250, 300, 400, 600, 800};
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            MenuItem menuItem = new MenuItem(menu, 16);
            menuItem.setText(String.valueOf(n) + "%");
            menuItem.setData((Object)new Integer(n));
            if (n == 100) {
                menuItem.setSelection(true);
            }
            menuItem.addListener(13, listener);
        }
    }

    void clear() {
        this.fCachedImage = null;
    }

    public void dispose() {
        if (this.fModelSynchronizer == null) {
            this.fModelSynchronizer.dispose();
            this.fModelSynchronizer = null;
        }
        this.fEditor = null;
    }

    public Control getControl() {
        return this.fCanvas;
    }

    public void setFocus() {
        Control control = this.getControl();
        if (UIUtils.okToUse((Widget)control)) {
            control.setFocus();
        }
    }

    public String getTitle() {
        return "Design";
    }

    public Image getImage() {
        return null;
    }

    public String getTitleToolTip() {
        return null;
    }

    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
    }

    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
    }

    protected void onActive(Event event) {
        if (!this.fModelSynchronizer.isSynchronized()) {
            this.fCanvas.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    XAMLDesignPart.this.update();
                }
            });
        }
    }

    protected void update() {
        if (!this.fModelSynchronizer.isSynchronized()) {
            this.fCachedImage = null;
            this.fWidget = this.fModelSynchronizer.build();
            this.layout();
            this.fCanvas.redraw();
        }
    }

    protected void onPaint(Event event) {
        int n;
        GC gC = event.gc;
        if (this.fWidget == null) {
            gC.fillRectangle(event.x, event.y, event.width, event.height);
            return;
        }
        int n2 = this.fWidth - this.fOffsetX - 20;
        int n3 = this.fHeight - this.fOffsetY - 20;
        if (n2 <= 0 || n3 <= 0) {
            gC.fillRectangle(event.x, event.y, event.width, event.height);
            return;
        }
        int n4 = this.fOffsetX - 20;
        int n5 = this.fOffsetY - 20;
        if (n4 < 0) {
            n4 = 0;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        org.eclipse.swt.graphics.Rectangle rectangle = this.fCanvas.getClientArea();
        IRenderer iRenderer = Renderer.getRenderer();
        if (this.fCachedImage == null) {
            if (n2 > rectangle.width) {
                n2 = rectangle.width;
            }
            if (n3 > rectangle.height) {
                n3 = rectangle.height;
            }
            this.fCachedImage = iRenderer.createImage(n2, n3);
            Graphics2D graphics2D = this.fCachedImage.createGraphics();
            graphics2D.setBackground(this.bgColor);
            graphics2D.clearRect(0, 0, n2, n3);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setClip(0, 0, n2, n3);
            if (this.fX < 0) {
                if (this.fY < 0) {
                    graphics2D.translate(-this.fX, -this.fY);
                } else {
                    graphics2D.translate(-this.fX, 0);
                }
            } else if (this.fY < 0) {
                graphics2D.translate(0, -this.fY);
            }
            graphics2D.translate(-n4, -n5);
            graphics2D.scale(this.sx, this.sy);
            graphics2D.setPaint(java.awt.Color.black);
            this.fWidget.paint(graphics2D);
            graphics2D.dispose();
        }
        n4 = 20 - this.fOffsetX;
        n5 = 20 - this.fOffsetY;
        if (n4 < 0) {
            n4 = 0;
        } else {
            gC.fillRectangle(0, 0, n4, rectangle.height);
        }
        if (n5 < 0) {
            n5 = 0;
        } else {
            gC.fillRectangle(n4, 0, rectangle.width, n5);
        }
        if (n2 < rectangle.width) {
            int n6 = n4 + n2;
            if (n6 < rectangle.width) {
                // empty if block
            }
            gC.fillRectangle(n6, n5, rectangle.width - n6, n3);
        }
        if (n3 < rectangle.height && (n = n5 + n3) < rectangle.height) {
            gC.fillRectangle(n4, n, rectangle.width - n4, rectangle.height - n);
        }
        gC.setClipping(n4, n5, n2, n3);
        iRenderer.drawImage(gC, this.fCachedImage, rectangle.x + n4, rectangle.y + n5);
    }

    protected void onResize(Event event) {
        this.fCachedImage = null;
        this.layout();
        this.fCanvas.redraw();
    }

    protected void onMenuClicked(Event event) {
        if (event.widget instanceof MenuItem) {
            MenuItem menuItem = (MenuItem)event.widget;
            if (!menuItem.getSelection()) {
                return;
            }
            Object object = menuItem.getData();
            if (object instanceof Integer) {
                int n = (Integer)object;
                this.sx = n;
                this.sx /= 100.0;
                if (this.sx != this.sy) {
                    this.sy = this.sx;
                    this.fCachedImage = null;
                    this.layout();
                    this.fCanvas.redraw();
                }
            }
        }
    }

    protected boolean getFlag(int n) {
        return (this.flags & n) != 0;
    }

    protected void setFlag(int n, boolean bl) {
        this.flags = bl ? (this.flags |= n) : (this.flags &= ~n);
    }

    private void hScroll() {
        if (this.fCachedImage == null) {
            return;
        }
        ScrollBar scrollBar = this.fCanvas.getHorizontalBar();
        int n = scrollBar.getSelection();
        if (this.fOffsetX != n) {
            this.fOffsetX = n;
            this.fCachedImage = null;
            this.fCanvas.redraw();
        }
    }

    private void vScroll() {
        if (this.fCachedImage == null) {
            return;
        }
        ScrollBar scrollBar = this.fCanvas.getVerticalBar();
        int n = scrollBar.getSelection();
        if (this.fOffsetY != n) {
            this.fOffsetY = n;
            this.fCachedImage = null;
            this.fCanvas.redraw();
        }
    }

    protected void layout() {
        org.eclipse.swt.graphics.Rectangle rectangle = this.fCanvas.getBounds();
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            return;
        }
        ScrollBar scrollBar = this.fCanvas.getHorizontalBar();
        ScrollBar scrollBar2 = this.fCanvas.getVerticalBar();
        if (this.fWidget == null) {
            scrollBar.setVisible(false);
            scrollBar2.setVisible(false);
            return;
        }
        AffineTransform affineTransform = AffineTransform.getScaleInstance(this.sx, this.sy);
        Rectangle2D rectangle2D = this.fWidget.getTransformedBounds(affineTransform);
        if (rectangle2D == null) {
            this.fHeight = 0;
            this.fWidth = 0;
            this.fY = 0;
            this.fX = 0;
        } else {
            Rectangle rectangle2 = rectangle2D.getBounds();
            this.fX = rectangle2.x;
            this.fY = rectangle2.y;
            this.fWidth = rectangle2.width;
            if (this.fX > 0) {
                this.fWidth += this.fX;
            }
            this.fHeight = rectangle2.height;
            if (this.fY > 0) {
                this.fHeight += this.fY;
            }
        }
        this.fWidth += 40;
        this.fHeight += 40;
        int n = this.fCanvas.getBorderWidth();
        rectangle.width -= 2 * n;
        rectangle.height -= 2 * n;
        if (this.fWidth <= rectangle.width) {
            if (this.fHeight <= rectangle.height) {
                scrollBar.setVisible(false);
                scrollBar2.setVisible(false);
            } else {
                scrollBar2.setVisible(true);
                Point point = scrollBar2.getSize();
                if (point != null) {
                    rectangle.width -= point.x;
                }
                scrollBar.setVisible(this.fWidth > rectangle.width);
            }
        } else {
            scrollBar.setVisible(true);
            Point point = scrollBar.getSize();
            if (point != null) {
                rectangle.height -= point.y;
            }
            scrollBar2.setVisible(this.fHeight > rectangle.height);
        }
        rectangle = this.fCanvas.getClientArea();
        this.setRange(scrollBar, rectangle.width, this.fWidth);
        this.setRange(scrollBar2, rectangle.height, this.fHeight);
        this.fOffsetX = scrollBar.getSelection();
        this.fOffsetY = scrollBar2.getSelection();
    }

    protected void setRange(ScrollBar scrollBar, int n, int n2) {
        scrollBar.setMaximum(n2);
        int n3 = Math.min(n, n2);
        scrollBar.setThumb(n3);
        scrollBar.setIncrement(n3 / 20);
        scrollBar.setPageIncrement(n3 * 3 / 4);
        int n4 = n2 - n;
        int n5 = scrollBar.getSelection();
        if (n5 >= n4 && n4 <= 0) {
            scrollBar.setSelection(0);
        }
    }
}

