/*
 * Decompiled with CFR 0.152.
 */
package com.spket.as.internal.compiler.recovery;

import com.spket.as.internal.compiler.ASTVisitor;
import com.spket.as.internal.compiler.ast.ASTNode;
import com.spket.as.internal.compiler.ast.Block;
import com.spket.as.internal.compiler.ast.CompilationUnitDeclaration;
import com.spket.as.internal.compiler.ast.FunctionDeclaration;
import com.spket.as.internal.compiler.ast.FunctionExpression;
import com.spket.as.internal.compiler.ast.ObjectInitializer;
import com.spket.as.internal.compiler.ast.SwitchStatement;
import com.spket.as.internal.compiler.lookup.Frame;
import com.spket.as.internal.compiler.recovery.ErrorInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class ErrorVisitor
extends ASTVisitor {
    private int start;
    private int end;
    private int firstToken;
    private ErrorInfo error;
    private Stack stack;
    private List errors;

    public ErrorVisitor(int n, int n2, int n3) {
        this.start = n2;
        this.end = n3;
        this.firstToken = n;
    }

    private int[] shrink(int n, int[] nArray) {
        if (n == 0) {
            return ErrorInfo.EMPTY;
        }
        if (n == nArray.length) {
            return nArray;
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    public ErrorInfo[] getErrors() {
        int n = this.errors.size();
        if (n > 0) {
            int n2 = 0;
            ErrorInfo[] errorInfoArray = new ErrorInfo[n];
            for (int i = 0; i < n; ++i) {
                ErrorInfo errorInfo = (ErrorInfo)this.errors.get(i);
                if (errorInfo.start >= errorInfo.end) continue;
                errorInfo.starts = this.shrink(errorInfo.count, errorInfo.starts);
                errorInfo.stops = this.shrink(errorInfo.count, errorInfo.stops);
                errorInfoArray[n2++] = errorInfo;
            }
            if (n2 > 0) {
                if (n2 < n) {
                    ErrorInfo[] errorInfoArray2 = new ErrorInfo[n2];
                    System.arraycopy(errorInfoArray, 0, errorInfoArray2, 0, n2);
                    return errorInfoArray2;
                }
                return errorInfoArray;
            }
        }
        return null;
    }

    public void endVisit(Block block, Frame frame) {
        this.uncheck(block.bits);
    }

    public void endVisit(ObjectInitializer objectInitializer, Frame frame) {
        this.uncheck(objectInitializer.bits);
    }

    public void endVisit(SwitchStatement switchStatement, Frame frame) {
        this.uncheck(switchStatement.bits);
    }

    private void uncheck(int n) {
        Object e;
        if ((n & 0x20) != 0 && (e = this.stack.pop()) instanceof ErrorInfo) {
            this.error = (ErrorInfo)e;
        }
    }

    private boolean check(int n, int n2, int n3) {
        boolean bl = false;
        int n4 = this.error.count;
        if (n2 + 1 < --n3) {
            boolean bl2;
            boolean bl3 = bl2 = this.error.end > this.error.start;
            if (bl2) {
                if (n4 == 0) {
                    bl = (n & 0x20) == 0;
                } else {
                    boolean bl4 = bl = this.error.stops[n4 - 1] < n2;
                    bl = bl ? (n & 0x20) == 0 : (n & 0x20) != 0;
                }
            } else {
                boolean bl5 = bl = (n & 0x20) != 0;
            }
        }
        if ((n & 0x20) == 0) {
            if (bl) {
                if (n4 >= this.error.starts.length) {
                    int[] nArray = new int[n4 + 10];
                    System.arraycopy(this.error.starts, 0, nArray, 0, n4);
                    this.error.starts = nArray;
                    nArray = new int[n4 + 10];
                    System.arraycopy(this.error.stops, 0, nArray, 0, n4);
                    this.error.stops = nArray;
                }
                this.error.starts[n4] = n2 + 1;
                this.error.stops[n4] = n3;
                ++this.error.count;
            }
        } else {
            if (bl) {
                this.stack.push(this.error);
                this.error = new ErrorInfo();
                this.errors.add(this.error);
                this.error.token = this.firstToken;
                this.error.start = n2 + 1;
                this.error.end = n3;
                return true;
            }
            this.stack.push(Boolean.FALSE);
        }
        return false;
    }

    private boolean hasContent(ASTNode[] aSTNodeArray, int n) {
        return (n & 0x20) != 0 || aSTNodeArray != null && aSTNodeArray.length > 0;
    }

    public boolean visit(Block block, Frame frame) {
        if (this.hasContent(block.statements, block.bits)) {
            int n = block.sourceStart;
            int n2 = block.sourceEnd;
            this.check(block.bits, n, n2);
            return true;
        }
        return false;
    }

    public boolean visit(CompilationUnitDeclaration compilationUnitDeclaration, Frame frame) {
        this.stack = new Stack();
        this.errors = new ArrayList();
        this.error = new ErrorInfo();
        this.errors.add(this.error);
        this.error.token = this.firstToken;
        if ((compilationUnitDeclaration.bits & 0x20) != 0) {
            this.error.start = this.start;
            this.error.end = this.end;
        }
        return true;
    }

    public boolean visit(ObjectInitializer objectInitializer, Frame frame) {
        if (this.hasContent(objectInitializer.expressions, objectInitializer.bits)) {
            if (this.check(objectInitializer.bits, objectInitializer.sourceStart, objectInitializer.sourceEnd)) {
                this.error.token = 1;
            }
            return true;
        }
        return false;
    }

    public boolean visit(SwitchStatement switchStatement, Frame frame) {
        if (this.hasContent(switchStatement.statements, switchStatement.bits)) {
            int n = switchStatement.blockStart;
            int n2 = switchStatement.sourceEnd;
            if (this.check(switchStatement.bits, n, n2)) {
                this.error.token = 70;
            }
            return true;
        }
        return false;
    }

    public boolean visit(FunctionDeclaration functionDeclaration, Frame frame) {
        if (functionDeclaration.body != null) {
            functionDeclaration.body.traverse(this, frame);
        }
        return false;
    }

    public boolean visit(FunctionExpression functionExpression, Frame frame) {
        if (functionExpression.body != null) {
            functionExpression.body.traverse(this, frame);
        }
        return false;
    }
}

