/*
 * Decompiled with CFR 0.152.
 */
package com.spket.as.internal.compiler.parser;

import com.spket.as.core.compiler.CharOperation;
import com.spket.as.core.compiler.InvalidInputException;
import com.spket.as.internal.compiler.CompilationResult;
import com.spket.as.internal.compiler.parser.NLSTag;
import com.spket.as.internal.compiler.parser.ScannerHelper;
import com.spket.as.internal.compiler.parser.TerminalTokens;

public class Scanner
implements TerminalTokens {
    public int sourceLevel;
    public int crPos = 0;
    public int flags = 0;
    public boolean recordLineSeparator = false;
    public int startPosition;
    public int currentPosition;
    public int initialPosition;
    public int eofPosition;
    public boolean tokenizeComments = false;
    public boolean tokenizeWhiteSpace = false;
    public char[] source;
    public char[] withoutUnicodeBuffer;
    public int withoutUnicodePtr;
    public static int COMMENT_ARRAYS_SIZE = 30;
    public int[] commentStops = new int[COMMENT_ARRAYS_SIZE];
    public int[] commentStarts = new int[COMMENT_ARRAYS_SIZE];
    public int[] commentTagStarts = new int[COMMENT_ARRAYS_SIZE];
    public int commentPtr = -1;
    protected int lastCommentLinePosition = -1;
    public char[][] foundTaskTags = null;
    public char[][] foundTaskMessages;
    public char[][] foundTaskPriorities = null;
    public int[][] foundTaskPositions;
    public int foundTaskCount = 0;
    public char[][] taskTags = null;
    public char[][] taskPriorities = null;
    public boolean isTaskCaseSensitive = true;
    public boolean diet = false;
    public int[] lineEnds = new int[250];
    public int linePtr = -1;
    public boolean wasAcr = false;
    public static final String END_OF_SOURCE = "End_Of_Source";
    public static final String INVALID_HEXA = "Invalid_Hexa_Literal";
    public static final String INVALID_UNICODE_ESCAPE = "Invalid_Unicode_Escape";
    public static final String INVALID_FLOAT = "Invalid_Float_Literal";
    public static final String INVALID_LOW_SURROGATE = "Invalid_Low_Surrogate";
    public static final String INVALID_HIGH_SURROGATE = "Invalid_High_Surrogate";
    public static final String UNTERMINATED_STRING = "Unterminated_String";
    public static final String UNTERMINATED_COMMENT = "Unterminated_Comment";
    public static final String INVALID_CHAR_IN_STRING = "Invalid_Char_In_String";
    public static final String UNTERMINATED_REGEXP = "Unterminated_RegExp";
    public static final String INVALID_REGEXP_FLAG = "Invalid_RegExp_Flag";
    private static final int[] EMPTY_LINE_ENDS = new int[0];
    static final char[] charArray_a = new char[]{'a'};
    static final char[] charArray_b = new char[]{'b'};
    static final char[] charArray_c = new char[]{'c'};
    static final char[] charArray_d = new char[]{'d'};
    static final char[] charArray_e = new char[]{'e'};
    static final char[] charArray_f = new char[]{'f'};
    static final char[] charArray_g = new char[]{'g'};
    static final char[] charArray_h = new char[]{'h'};
    static final char[] charArray_i = new char[]{'i'};
    static final char[] charArray_j = new char[]{'j'};
    static final char[] charArray_k = new char[]{'k'};
    static final char[] charArray_l = new char[]{'l'};
    static final char[] charArray_m = new char[]{'m'};
    static final char[] charArray_n = new char[]{'n'};
    static final char[] charArray_o = new char[]{'o'};
    static final char[] charArray_p = new char[]{'p'};
    static final char[] charArray_q = new char[]{'q'};
    static final char[] charArray_r = new char[]{'r'};
    static final char[] charArray_s = new char[]{'s'};
    static final char[] charArray_t = new char[]{'t'};
    static final char[] charArray_u = new char[]{'u'};
    static final char[] charArray_v = new char[]{'v'};
    static final char[] charArray_w = new char[]{'w'};
    static final char[] charArray_x = new char[]{'x'};
    static final char[] charArray_y = new char[]{'y'};
    static final char[] charArray_z = new char[]{'z'};
    static final char[] initCharArray = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};
    static final int TableSize = 30;
    static final int InternalTableSize = 6;
    public static final int OptimizedLength = 7;
    public final char[][][][] charArray_length = new char[7][30][6][];
    public static final char[] TAG_PREFIX = "//$NON-NLS-".toCharArray();
    public static final int TAG_PREFIX_LENGTH = TAG_PREFIX.length;
    public static final char TAG_POSTFIX = '$';
    public static final int TAG_POSTFIX_LENGTH = 1;
    private NLSTag[] nlsTags = null;
    protected int nlsTagsPtr;
    public boolean checkNonExternalizedStringLiterals;
    int newEntry2;
    int newEntry3;
    int newEntry4;
    int newEntry5;
    int newEntry6;
    public boolean insideRecovery;
    public static final int RoundBracket = 0;
    public static final int SquareBracket = 1;
    public static final int CurlyBracket = 2;
    public static final int BracketKinds = 3;
    public static final int LOW_SURROGATE_MIN_VALUE = 56320;
    public static final int HIGH_SURROGATE_MIN_VALUE = 55296;
    public static final int HIGH_SURROGATE_MAX_VALUE = 56319;
    public static final int LOW_SURROGATE_MAX_VALUE = 57343;
    public static final int LINE_SEPARATOR = 8232;
    public static final int PARA_SEPARATOR = 8233;

    public Scanner() {
        this(6);
    }

    public Scanner(int n) {
        this(false, false, false, n, null, null, true);
    }

    public Scanner(boolean bl, boolean bl2, boolean bl3, int n, char[][] cArray, char[][] cArray2, boolean bl4) {
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 30; ++j) {
                for (int k = 0; k < 6; ++k) {
                    this.charArray_length[i][j][k] = initCharArray;
                }
            }
        }
        this.newEntry2 = 0;
        this.newEntry3 = 0;
        this.newEntry4 = 0;
        this.newEntry5 = 0;
        this.newEntry6 = 0;
        this.insideRecovery = false;
        this.eofPosition = Integer.MAX_VALUE;
        this.tokenizeComments = bl;
        this.tokenizeWhiteSpace = bl2;
        this.sourceLevel = n;
        this.checkNonExternalizedStringLiterals = bl3;
        this.taskTags = cArray;
        this.taskPriorities = cArray2;
        this.isTaskCaseSensitive = bl4;
    }

    public final boolean atEnd() {
        return this.source.length == this.currentPosition;
    }

    public void checkTaskTag(int n, int n2) throws InvalidInputException {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        char[] cArray = this.source;
        if (this.foundTaskCount > 0 && this.foundTaskPositions[this.foundTaskCount - 1][0] >= n) {
            return;
        }
        int n9 = this.foundTaskCount;
        char c = cArray[n + 1];
        for (n8 = n + 2; n8 < n2 && n8 < this.eofPosition; ++n8) {
            char[] cArray2 = null;
            char[] cArray3 = null;
            if (c != '@') {
                block1: for (n7 = 0; n7 < this.taskTags.length; ++n7) {
                    cArray2 = this.taskTags[n7];
                    n6 = cArray2.length;
                    if (n6 == 0 || ScannerHelper.isJavaIdentifierStart(cArray2[0]) && ScannerHelper.isJavaIdentifierPart(c)) continue;
                    for (n5 = 0; n5 < n6; ++n5) {
                        char c2;
                        int n10 = n8 + n5;
                        if (n10 >= this.eofPosition || n10 >= n2 || (n4 = cArray[n8 + n5]) != (c2 = cArray2[n5]) && (this.isTaskCaseSensitive || ScannerHelper.toLowerCase((char)n4) != ScannerHelper.toLowerCase(c2))) continue block1;
                    }
                    if (n8 + n6 < n2 && ScannerHelper.isJavaIdentifierPart(cArray[n8 + n6 - 1]) && ScannerHelper.isJavaIdentifierPart(cArray[n8 + n6])) continue;
                    if (this.foundTaskTags == null) {
                        this.foundTaskTags = new char[5][];
                        this.foundTaskMessages = new char[5][];
                        this.foundTaskPriorities = new char[5][];
                        this.foundTaskPositions = new int[5][];
                    } else if (this.foundTaskCount == this.foundTaskTags.length) {
                        char[][] cArrayArray = new char[this.foundTaskCount * 2][];
                        this.foundTaskTags = cArrayArray;
                        System.arraycopy(this.foundTaskTags, 0, cArrayArray, 0, this.foundTaskCount);
                        char[][] cArrayArray2 = new char[this.foundTaskCount * 2][];
                        this.foundTaskMessages = cArrayArray2;
                        System.arraycopy(this.foundTaskMessages, 0, cArrayArray2, 0, this.foundTaskCount);
                        char[][] cArrayArray3 = new char[this.foundTaskCount * 2][];
                        this.foundTaskPriorities = cArrayArray3;
                        System.arraycopy(this.foundTaskPriorities, 0, cArrayArray3, 0, this.foundTaskCount);
                        int[][] nArrayArray = new int[this.foundTaskCount * 2][];
                        this.foundTaskPositions = nArrayArray;
                        System.arraycopy(this.foundTaskPositions, 0, nArrayArray, 0, this.foundTaskCount);
                    }
                    cArray3 = this.taskPriorities != null && n7 < this.taskPriorities.length ? this.taskPriorities[n7] : null;
                    this.foundTaskTags[this.foundTaskCount] = cArray2;
                    this.foundTaskPriorities[this.foundTaskCount] = cArray3;
                    this.foundTaskPositions[this.foundTaskCount] = new int[]{n8, n8 + n6 - 1};
                    this.foundTaskMessages[this.foundTaskCount] = CharOperation.NO_CHAR;
                    ++this.foundTaskCount;
                    n8 += n6 - 1;
                    break;
                }
            }
            c = cArray[n8];
        }
        n8 = 0;
        for (n3 = n9; n3 < this.foundTaskCount; ++n3) {
            int n11 = this.foundTaskPositions[n3][0] + this.foundTaskTags[n3].length;
            int n12 = n7 = n3 + 1 < this.foundTaskCount ? this.foundTaskPositions[n3 + 1][0] - 1 : n2 - 1;
            if (n7 < n11) {
                n7 = n11;
            }
            n6 = -1;
            for (n4 = n11; n4 < n7; ++n4) {
                n5 = cArray[n4];
                if (n5 != 10 && n5 != 13) continue;
                n6 = n4 - 1;
                break;
            }
            if (n6 == -1) {
                for (n4 = n7; n4 > n11; --n4) {
                    n5 = cArray[n4];
                    if (n5 != 42) continue;
                    n6 = n4 - 1;
                    break;
                }
                if (n6 == -1) {
                    n6 = n7;
                }
            }
            if (n11 == n6) {
                n8 = 1;
                continue;
            }
            while (CharOperation.isWhitespace(cArray[n6]) && n11 <= n6) {
                --n6;
            }
            while (CharOperation.isWhitespace(cArray[n11]) && n11 <= n6) {
                ++n11;
            }
            this.foundTaskPositions[n3][1] = n6;
            n4 = n6 - n11 + 1;
            char[] cArray4 = new char[n4];
            System.arraycopy(cArray, n11, cArray4, 0, n4);
            this.foundTaskMessages[n3] = cArray4;
        }
        if (n8 != 0) {
            int n13 = this.foundTaskCount;
            block8: for (n3 = n9; n3 < n13; ++n3) {
                if (this.foundTaskMessages[n3].length != 0) continue;
                for (n7 = n3 + 1; n7 < n13; ++n7) {
                    if (this.foundTaskMessages[n7].length == 0) continue;
                    this.foundTaskMessages[n3] = this.foundTaskMessages[n7];
                    this.foundTaskPositions[n3][1] = this.foundTaskPositions[n7][1];
                    continue block8;
                }
            }
        }
    }

    public char[] getCurrentIdentifierSource() {
        char[] cArray;
        if (this.withoutUnicodePtr != 0) {
            cArray = new char[this.withoutUnicodePtr];
            System.arraycopy(this.withoutUnicodeBuffer, 1, cArray, 0, this.withoutUnicodePtr);
        } else {
            int n = this.currentPosition - this.startPosition;
            if (n == this.source.length) {
                return this.source;
            }
            switch (n) {
                case 1: {
                    return this.optimizedCurrentTokenSource1();
                }
                case 2: {
                    return this.optimizedCurrentTokenSource2();
                }
                case 3: {
                    return this.optimizedCurrentTokenSource3();
                }
                case 4: {
                    return this.optimizedCurrentTokenSource4();
                }
                case 5: {
                    return this.optimizedCurrentTokenSource5();
                }
                case 6: {
                    return this.optimizedCurrentTokenSource6();
                }
            }
            cArray = new char[n];
            System.arraycopy(this.source, this.startPosition, cArray, 0, n);
        }
        return cArray;
    }

    public int getCurrentTokenEndPosition() {
        return this.currentPosition - 1;
    }

    public char[] getCurrentTokenSource() {
        char[] cArray;
        if (this.withoutUnicodePtr != 0) {
            cArray = new char[this.withoutUnicodePtr];
            System.arraycopy(this.withoutUnicodeBuffer, 1, cArray, 0, this.withoutUnicodePtr);
        } else {
            int n = this.currentPosition - this.startPosition;
            cArray = new char[n];
            System.arraycopy(this.source, this.startPosition, cArray, 0, n);
        }
        return cArray;
    }

    public char[] getCurrentTokenSourceString() {
        char[] cArray;
        if (this.withoutUnicodePtr != 0) {
            cArray = new char[this.withoutUnicodePtr - 2];
            System.arraycopy(this.withoutUnicodeBuffer, 2, cArray, 0, this.withoutUnicodePtr - 2);
        } else {
            int n = this.currentPosition - this.startPosition - 2;
            cArray = new char[n];
            System.arraycopy(this.source, this.startPosition + 1, cArray, 0, n);
        }
        return cArray;
    }

    public final char[] getRawTokenSource() {
        int n = this.currentPosition - this.startPosition;
        char[] cArray = new char[n];
        System.arraycopy(this.source, this.startPosition, cArray, 0, n);
        return cArray;
    }

    public int getCurrentTokenStartPosition() {
        return this.startPosition;
    }

    public final int getLineEnd(int n) {
        if (this.lineEnds == null || this.linePtr == -1) {
            return -1;
        }
        if (n > this.lineEnds.length + 1) {
            return -1;
        }
        if (n <= 0) {
            return -1;
        }
        if (n == this.lineEnds.length + 1) {
            return this.eofPosition;
        }
        return this.lineEnds[n - 1];
    }

    public final int[] getLineEnds() {
        if (this.linePtr == -1) {
            return EMPTY_LINE_ENDS;
        }
        int[] nArray = new int[this.linePtr + 1];
        System.arraycopy(this.lineEnds, 0, nArray, 0, this.linePtr + 1);
        return nArray;
    }

    public final int getLineStart(int n) {
        if (this.lineEnds == null || this.linePtr == -1) {
            return -1;
        }
        if (n > this.lineEnds.length + 1) {
            return -1;
        }
        if (n <= 0) {
            return -1;
        }
        if (n == 1) {
            return this.initialPosition;
        }
        return this.lineEnds[n - 2] + 1;
    }

    public final int getNextChar() {
        try {
            char c = this.source[this.currentPosition++];
            if (c == '\\') {
                while (true) {
                    char c2;
                    if ((c2 = this.source[this.currentPosition]) == 'u') {
                        return this.getNextUnicodeChar();
                    }
                    if (!Scanner.isJSFormat(c2)) break;
                    ++this.currentPosition;
                }
            }
            if (this.withoutUnicodePtr != 0) {
                this.unicodeStore(c);
            }
            return c;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return -1;
        }
        catch (InvalidInputException invalidInputException) {
            return -1;
        }
    }

    public final boolean getNextChar(char c) {
        if (this.currentPosition >= this.source.length) {
            return false;
        }
        try {
            char c2;
            do {
                if ((c2 = this.source[this.currentPosition++]) != c) continue;
                return true;
            } while (Scanner.isJSFormat(c2));
            --this.currentPosition;
            return false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            --this.currentPosition;
            return false;
        }
    }

    public final int getNextChar(char c, char c2) {
        if (this.currentPosition >= this.source.length) {
            return -1;
        }
        try {
            char c3;
            do {
                if ((c3 = this.source[this.currentPosition++]) == c) {
                    return 0;
                }
                if (c3 != c2) continue;
                return 1;
            } while (Scanner.isJSFormat(c3));
            --this.currentPosition;
            return -1;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            --this.currentPosition;
            return -1;
        }
    }

    public final boolean getNextCharAsDigit() throws InvalidInputException {
        if (this.currentPosition >= this.source.length) {
            return false;
        }
        try {
            char c;
            do {
                if ((c = this.source[this.currentPosition++]) >= '\u0080' || (ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[c] & 4) == 0) continue;
                return true;
            } while (Scanner.isJSFormat(c));
            --this.currentPosition;
            return false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            --this.currentPosition;
            return false;
        }
    }

    public final boolean getNextCharAsDigit(int n) {
        if (this.currentPosition >= this.source.length) {
            return false;
        }
        try {
            char c;
            do {
                if (ScannerHelper.digit(c = this.source[this.currentPosition++], n) == -1) continue;
                return true;
            } while (Scanner.isJSFormat(c));
            --this.currentPosition;
            return false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            --this.currentPosition;
            return false;
        }
    }

    public boolean getNextCharAsJavaIdentifierPart() {
        int n = this.currentPosition;
        if (n >= this.source.length) {
            return false;
        }
        int n2 = this.withoutUnicodePtr;
        try {
            char c;
            char c2;
            boolean bl = false;
            block3: while (true) {
                if ((c2 = this.source[this.currentPosition++]) == '\\') {
                    while (true) {
                        if ((c = this.source[this.currentPosition]) == 'u') {
                            c2 = this.getNextUnicodeChar();
                            bl = true;
                            break block3;
                        }
                        if (!Scanner.isJSFormat(c)) break block3;
                        ++this.currentPosition;
                    }
                }
                if (!Scanner.isJSFormat(c2)) break;
                ++n;
            }
            c = '\u0000';
            if (c2 >= '\ud800' && c2 <= '\udbff') {
                char c3 = (char)this.getNextChar();
                if (c3 < '\udc00' || c3 > '\udfff') {
                    this.currentPosition = n;
                    this.withoutUnicodePtr = n2;
                    return false;
                }
                c = (char)(ScannerHelper.isJavaIdentifierPart(c2, c3) ? 1 : 0);
            } else {
                if (c2 >= '\udc00' && c2 <= '\udfff') {
                    this.currentPosition = n;
                    this.withoutUnicodePtr = n2;
                    return false;
                }
                c = (char)(ScannerHelper.isJavaIdentifierPart(c2) ? 1 : 0);
            }
            if (bl) {
                if (c == '\u0000') {
                    this.currentPosition = n;
                    this.withoutUnicodePtr = n2;
                    return false;
                }
                return true;
            }
            if (c == '\u0000') {
                this.currentPosition = n;
                return false;
            }
            if (this.withoutUnicodePtr != 0) {
                this.unicodeStore(c2);
            }
            return true;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.currentPosition = n;
            this.withoutUnicodePtr = n2;
            return false;
        }
        catch (InvalidInputException invalidInputException) {
            this.currentPosition = n;
            this.withoutUnicodePtr = n2;
            return false;
        }
    }

    private final void scanString(char c) throws InvalidInputException {
        char[] cArray = this.source;
        try {
            char c2;
            while ((c2 = cArray[this.currentPosition++]) != c) {
                block1 : switch (c2) {
                    case '\n': 
                    case '\r': 
                    case '\u2028': 
                    case '\u2029': {
                        --this.currentPosition;
                        throw new InvalidInputException(INVALID_CHAR_IN_STRING);
                    }
                    case '\\': {
                        while (true) {
                            int n;
                            int n2;
                            char c3;
                            int n3;
                            int n4;
                            c2 = cArray[this.currentPosition++];
                            switch (c2) {
                                case 'b': {
                                    c2 = '\b';
                                    break block1;
                                }
                                case 't': {
                                    c2 = '\t';
                                    break block1;
                                }
                                case 'n': {
                                    c2 = '\n';
                                    break block1;
                                }
                                case 'f': {
                                    c2 = '\f';
                                    break block1;
                                }
                                case 'r': {
                                    c2 = '\r';
                                    break block1;
                                }
                                case 'v': {
                                    c2 = '\u000b';
                                    break block1;
                                }
                                case 'u': 
                                case 'x': {
                                    n4 = 0;
                                    n3 = this.currentPosition;
                                    char c4 = c3 = c2 == 'u' ? (char)'\u0004' : '\u0002';
                                    while (c3 > '\u0000') {
                                        if ((n2 = ScannerHelper.hex((char)(n = cArray[this.currentPosition++]))) == -1) {
                                            if (Scanner.isJSFormat((char)n)) continue;
                                            this.currentPosition = n3;
                                            break;
                                        }
                                        --c3;
                                        n4 = (n4 << 4) + n2;
                                    }
                                    if (c3 != '\u0000') break block1;
                                    c2 = (char)n4;
                                    break block1;
                                }
                            }
                            if (c2 >= '0' && c2 < '8') {
                                n2 = 0;
                                n4 = this.currentPosition;
                                n3 = c2 - 48;
                                do {
                                    if ((c3 = cArray[this.currentPosition++]) < 48 || c3 >= 56) continue;
                                    ++n2;
                                    n = n3 * 8 + (c3 - 48);
                                    if (n > 255) break;
                                    n4 = this.currentPosition;
                                } while (n2 <= 1 && Scanner.isJSFormat(c3));
                                this.currentPosition = n4;
                                c2 = (char)n3;
                                break block1;
                            }
                            if (!Scanner.isJSFormat(c2)) break block1;
                        }
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            --this.currentPosition;
            throw new InvalidInputException(UNTERMINATED_STRING);
        }
    }

    public int scanRegExp() throws InvalidInputException {
        char[] cArray = this.source;
        boolean bl = false;
        try {
            char c;
            block14: while (true) {
                c = cArray[this.currentPosition++];
                switch (c) {
                    case '\n': 
                    case '\r': 
                    case '\u2028': 
                    case '\u2029': {
                        --this.currentPosition;
                        throw new InvalidInputException(UNTERMINATED_REGEXP);
                    }
                    case '\\': {
                        ++this.currentPosition;
                        continue block14;
                    }
                    case '[': {
                        if ((this.sourceLevel & 0x1000) != 0) continue block14;
                        bl = true;
                        continue block14;
                    }
                    case ']': {
                        bl = false;
                        continue block14;
                    }
                    case '/': {
                        if (bl) continue block14;
                        break block14;
                    }
                    default: {
                        continue block14;
                    }
                }
                break;
            }
            try {
                block15: while (true) {
                    c = cArray[this.currentPosition++];
                    switch (c) {
                        case 'g': 
                        case 'i': 
                        case 'm': {
                            continue block15;
                        }
                    }
                    if (ScannerHelper.isAlpha(c)) {
                        throw new InvalidInputException(INVALID_REGEXP_FLAG);
                    }
                    if (!Scanner.isJSFormat(c)) break;
                }
                --this.currentPosition;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                --this.currentPosition;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            --this.currentPosition;
            throw new InvalidInputException(UNTERMINATED_REGEXP);
        }
        return 59;
    }

    public void pushBack() {
        this.currentPosition = this.startPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getNextToken() throws InvalidInputException {
        this.crPos = 0;
        this.wasAcr = false;
        if (this.diet) {
            this.jumpOverMethodBody();
            this.diet = false;
            if (this.currentPosition <= this.source.length) return 44;
            return 45;
        }
        var1_1 = '\u0000';
        var2_2 = 0;
        try {
            block114: {
                block67: while (true) lbl-1000:
                // 4 sources

                {
                    this.withoutUnicodePtr = 0;
                    var2_2 = ++this.currentPosition;
                    var3_3 = false;
                    block68: while (true) {
                        block113: {
                            var4_5 = this.currentPosition;
                            this.startPosition = this.currentPosition;
                            try {
                                var1_1 = this.source[this.currentPosition++];
                            }
                            catch (IndexOutOfBoundsException var5_7) {
                                if (this.tokenizeWhiteSpace && var2_2 != this.currentPosition - 1) {
                                    --this.currentPosition;
                                    this.startPosition = var2_2;
                                    return 1000;
                                }
                                if (this.currentPosition <= this.eofPosition) break block113;
                                return 45;
                            }
                        }
                        if (this.currentPosition > this.eofPosition) {
                            return 45;
                        }
                        var4_5 = this.currentPosition - var4_5;
                        switch (var1_1) {
                            case ' ': {
                                var3_3 = true;
                                continue block68;
                            }
                            case '\n': 
                            case '\r': {
                                if (this.recordLineSeparator) {
                                    this.pushLineSeparator(var1_1);
                                }
                            }
                            case '\u2028': 
                            case '\u2029': {
                                var3_3 = true;
                                if (this.crPos != 0) continue block68;
                                this.crPos = this.currentPosition - 1;
                                continue block68;
                            }
                        }
                        if (Scanner.isJSFormat(var1_1)) continue;
                        if (!Scanner.isWhitespace(var1_1)) break;
                        var3_3 = true;
                    }
                    if (var3_3 && this.tokenizeWhiteSpace) {
                        this.currentPosition -= var4_5;
                        this.startPosition = var2_2;
                        return 1000;
                    }
                    switch (var1_1) {
                        case '@': {
                            return 41;
                        }
                        case '(': {
                            return 4;
                        }
                        case ')': {
                            return 48;
                        }
                        case '{': {
                            return 46;
                        }
                        case '}': {
                            return 44;
                        }
                        case '[': {
                            return 5;
                        }
                        case ']': {
                            return 69;
                        }
                        case ';': {
                            return 36;
                        }
                        case ',': {
                            return 31;
                        }
                        case '.': {
                            if (this.getNextCharAsDigit()) {
                                this.scanNumber(true);
                                return 52;
                            }
                            if ((this.sourceLevel & 4096) != 0) {
                                if (this.getNextChar('.') == false) return 11;
                                if (this.getNextChar('.') == false) return 12;
                                return 83;
                            }
                            if ((this.sourceLevel & 1) == 0) return 11;
                            if (this.getNextChar('.') == false) return 11;
                            return 12;
                        }
                        case '+': {
                            var5_8 = this.getNextChar('+', '=');
                            if (var5_8 == 0) {
                                return 17;
                            }
                            if (var5_8 <= 0) return 2;
                            return 86;
                        }
                        case '-': {
                            var5_9 = this.getNextChar('-', '=');
                            if (var5_9 == 0) {
                                return 18;
                            }
                            if (var5_9 <= 0) return 3;
                            return 87;
                        }
                        case '~': {
                            return 65;
                        }
                        case '!': {
                            if (this.getNextChar('=') == false) return 64;
                            if (this.getNextChar('=') == false) return 14;
                            return 16;
                        }
                        case '*': {
                            if (this.getNextChar('=') == false) return 1;
                            return 88;
                        }
                        case '%': {
                            if (this.getNextChar('=') == false) return 9;
                            return 93;
                        }
                        case '<': {
                            var5_10 = this.getNextChar('=', '<');
                            if (var5_10 == 0) {
                                return 22;
                            }
                            if (var5_10 <= 0) return 25;
                            if (this.getNextChar('=') == false) return 6;
                            return 94;
                        }
                        case '>': {
                            var5_11 = this.getNextChar('=', '>');
                            if (var5_11 == 0) {
                                return 23;
                            }
                            if (var5_11 <= 0) return 24;
                            var5_11 = this.getNextChar('=', '>');
                            if (var5_11 == 0) {
                                return 95;
                            }
                            if (var5_11 <= 0) return 7;
                            if (this.getNextChar('=') == false) return 8;
                            return 96;
                        }
                        case '=': {
                            if (this.getNextChar('=') == false) return 70;
                            if (this.getNextChar('=') == false) return 13;
                            return 15;
                        }
                        case '&': {
                            if ((this.flags & 4) != 0) return 26;
                            var5_12 = this.getNextChar('&', '=');
                            if (var5_12 == 0) {
                                if ((this.sourceLevel & 4096) == 0) return 30;
                                if (this.getNextChar('=') == false) return 30;
                                return 97;
                            }
                            if (var5_12 <= 0) return 26;
                            return 90;
                        }
                        case '|': {
                            var5_13 = this.getNextChar('|', '=');
                            if (var5_13 == 0) {
                                if ((this.sourceLevel & 4096) == 0) return 33;
                                if (this.getNextChar('=') == false) return 33;
                                return 99;
                            }
                            if (var5_13 <= 0) return 29;
                            return 91;
                        }
                        case '^': {
                            if (this.getNextChar('=')) {
                                return 92;
                            }
                            if ((this.sourceLevel & 4096) == 0) return 28;
                            if (this.getNextChar('^') == false) return 28;
                            if (this.getNextChar('=') == false) return 34;
                            return 98;
                        }
                        case '?': {
                            return 32;
                        }
                        case ':': {
                            if ((this.sourceLevel & 1) == 0) return 53;
                            if (this.getNextChar(':') == false) return 53;
                            return 35;
                        }
                        case '\"': 
                        case '\'': {
                            this.scanString(var1_1);
                            return 51;
                        }
                        case '/': {
                            var5_6 = this.getNextChar('/', '*');
                            if (var5_6 != 0) ** GOTO lbl197
                            this.lastCommentLinePosition = this.currentPosition--;
                            try {
                                block69: while (true) {
                                    var1_1 = this.source[this.currentPosition++];
                                    switch (var1_1) {
                                        case '\n': 
                                        case '\r': 
                                        case '\u2028': 
                                        case '\u2029': {
                                            if (this.crPos != 0) break block69;
                                            this.crPos = this.startPosition;
                                            break block69;
                                        }
                                        default: {
                                            this.lastCommentLinePosition = this.currentPosition;
                                            continue block69;
                                        }
                                    }
                                    break;
                                }
                                if (var1_1 == '\r' && this.source.length > this.currentPosition && this.source[this.currentPosition] == '\n') {
                                    ++this.currentPosition;
                                    var1_1 = '\n';
                                }
                                this.recordComment(1001);
                                if (this.taskTags != null) {
                                    this.checkTaskTag(this.startPosition, this.currentPosition);
                                }
                                if (var1_1 == '\r' || var1_1 == '\n') {
                                    if (this.checkNonExternalizedStringLiterals) {
                                        this.parseTags();
                                    }
                                    if (this.recordLineSeparator) {
                                        this.pushLineSeparator(var1_1);
                                    }
                                }
                                if (!this.tokenizeComments) ** GOTO lbl-1000
                                return 1001;
                            }
                            catch (IndexOutOfBoundsException var6_18) {
                                this.recordComment(1001);
                                if (this.taskTags != null) {
                                    this.checkTaskTag(this.startPosition, this.currentPosition);
                                }
                                if (this.checkNonExternalizedStringLiterals) {
                                    this.parseTags();
                                }
                                if (!this.tokenizeComments) ** GOTO lbl-1000
                                return 1001;
                            }
lbl197:
                            // 1 sources

                            if (var5_6 > 0) {
                                try {
                                    var7_24 = 0;
                                    var8_25 = 0;
                                    var1_1 = this.source[this.currentPosition++];
                                    switch (var1_1) {
                                        case '*': {
                                            var7_24 = 1;
                                            var8_25 = 1;
                                            break;
                                        }
                                        case '\n': 
                                        case '\r': {
                                            if (this.recordLineSeparator) {
                                                this.pushLineSeparator(var1_1);
                                            }
                                        }
                                        case '\u2028': 
                                        case '\u2029': {
                                            if (this.crPos != 0) break;
                                            this.crPos = this.startPosition;
                                            break;
                                        }
                                    }
                                    var6_19 = this.currentPosition;
                                    var1_1 = this.source[this.currentPosition++];
                                    if (var1_1 == '/') {
                                        var7_24 = 0;
                                    }
                                    var9_26 = 0;
                                    while (var1_1 != '/' || var8_25 == 0) {
                                        switch (var1_1) {
                                            case '\n': 
                                            case '\r': {
                                                if (this.recordLineSeparator) {
                                                    this.pushLineSeparator(var1_1);
                                                }
                                            }
                                            case '\u2028': 
                                            case '\u2029': {
                                                var8_25 = 0;
                                                if (this.crPos != 0) break;
                                                this.crPos = this.startPosition;
                                                break;
                                            }
                                            case '*': {
                                                var8_25 = 1;
                                                break;
                                            }
                                            case '@': {
                                                if (var9_26 == 0) {
                                                    var9_26 = var6_19;
                                                }
                                            }
                                            default: {
                                                var8_25 = 0;
                                            }
                                        }
                                        var6_19 = this.currentPosition;
                                        var1_1 = this.source[this.currentPosition++];
                                    }
                                    var10_27 = var7_24 != 0 ? 1003 : 1002;
                                    this.recordComment(var10_27);
                                    this.commentTagStarts[this.commentPtr] = var9_26;
                                    if (this.taskTags == null) continue block67;
                                    this.checkTaskTag(this.startPosition, this.currentPosition);
                                    if (!this.tokenizeComments) continue block67;
                                    return var10_27;
                                }
                                catch (IndexOutOfBoundsException var6_20) {
                                    --this.currentPosition;
                                    throw new InvalidInputException("Unterminated_Comment");
                                }
                            }
                            if ((this.flags & 2) != 0 && (this.sourceLevel & 2) != 0) {
                                return this.scanRegExp();
                            }
                            if (this.getNextChar('=') == false) return 10;
                            return 89;
                        }
                        case '\u001a': {
                            if (this.atEnd() == false) throw new InvalidInputException("Ctrl-Z");
                            return 45;
                        }
                        case '\\': {
                            while (true) {
                                if ((var1_1 = this.source[this.currentPosition]) != 'u') ** GOTO lbl264
                                var1_1 = this.getNextUnicodeChar();
                                if (var1_1 < '\u0080') {
                                    break;
                                }
                                ** GOTO lbl269
lbl264:
                                // 1 sources

                                if (Scanner.isJSFormat(var1_1) == false) return 116;
                                ++this.currentPosition;
                            }
                            if ((ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[var1_1] & 64) == 0) return 116;
                            return this.scanIdentifierOrKeyword();
lbl269:
                            // 1 sources

                            if (var1_1 >= '\ud800' && var1_1 <= '\udbff') {
                                var5_14 = (char)this.getNextChar();
                                if (var5_14 < '\udc00') throw new InvalidInputException("Invalid_Low_Surrogate");
                                if (var5_14 > '\udfff') {
                                    throw new InvalidInputException("Invalid_Low_Surrogate");
                                }
                                if (ScannerHelper.isJavaIdentifierStart(var1_1, var5_14) == false) return 116;
                                return this.scanIdentifierOrKeyword();
                            }
                            if (var1_1 >= '\udc00' && var1_1 <= '\udfff') {
                                throw new InvalidInputException("Invalid_High_Surrogate");
                            }
                            if (Character.isJavaIdentifierStart(var1_1) == false) return 116;
                            return this.scanIdentifierOrKeyword();
                        }
                    }
                    break;
                }
                if (var1_1 >= '\u0080') break block114;
                if ((ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[var1_1] & 64) != 0) {
                    return this.scanIdentifierOrKeyword();
                }
                if ((ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[var1_1] & 4) != 0) {
                    this.scanNumber(false);
                    return 52;
                }
                if (var1_1 != '#') return 116;
                if ((this.sourceLevel & 0x100000) == 0) return 116;
                var7_24 = this.sourceLevel;
                switch (this.source[this.currentPosition]) {
                    case 'i': {
                        this.sourceLevel |= 4096;
                        var5_15 = this.startPosition;
                        var6_21 = this.startPosition = this.currentPosition;
                        try {
                            if (109 == this.scanIdentifierOrKeyword()) {
                                var8_25 = 109;
                                return var8_25;
                            }
                        }
                        finally {
                            this.sourceLevel = var7_24;
                        }
                        this.startPosition = var5_15;
                        this.currentPosition = var6_21;
                        return 116;
                    }
                    case 'p': {
                        this.sourceLevel |= 0x200000;
                        var5_16 = this.startPosition;
                        var6_22 = this.startPosition = this.currentPosition;
                        try {
                            if (110 == this.scanIdentifierOrKeyword()) {
                                var8_25 = 110;
                                return var8_25;
                            }
                        }
                        finally {
                            this.sourceLevel = var7_24;
                        }
                        this.startPosition = var5_16;
                        this.currentPosition = var6_22;
                        return 116;
                    }
                }
                return 116;
            }
            if (var1_1 >= '\ud800' && var1_1 <= '\udbff') {
                var6_23 = (char)this.getNextChar();
                if (var6_23 < '\udc00') throw new InvalidInputException("Invalid_Low_Surrogate");
                if (var6_23 > '\udfff') {
                    throw new InvalidInputException("Invalid_Low_Surrogate");
                }
                var5_17 = ScannerHelper.isJavaIdentifierStart(var1_1, var6_23);
            } else {
                if (var1_1 >= '\udc00' && var1_1 <= '\udfff') {
                    throw new InvalidInputException("Invalid_High_Surrogate");
                }
                var5_17 = Character.isJavaIdentifierStart(var1_1);
            }
            if (var5_17) {
                return this.scanIdentifierOrKeyword();
            }
            if (ScannerHelper.isDigit(var1_1) == false) return 116;
            this.scanNumber(false);
            return 52;
        }
        catch (IndexOutOfBoundsException var3_4) {
            if (this.tokenizeWhiteSpace == false) return 45;
            if (var2_2 == this.currentPosition - 1) return 45;
            --this.currentPosition;
            this.startPosition = var2_2;
            return 1000;
        }
    }

    public final char getNextUnicodeChar() throws InvalidInputException {
        int n = 4;
        int n2 = 0;
        ++this.currentPosition;
        try {
            char c;
            while (n > 0) {
                int n3;
                if ((n3 = ScannerHelper.hex(c = this.source[this.currentPosition++])) == -1) {
                    if (Scanner.isJSFormat(c)) continue;
                    throw new InvalidInputException(INVALID_UNICODE_ESCAPE);
                }
                --n;
                n2 = (n2 << 4) + n3;
            }
            if (this.withoutUnicodePtr == 0) {
                this.unicodeInitializeBuffer(this.currentPosition - 6 - this.startPosition);
            }
            c = (char)n2;
            this.unicodeStore(c);
            return c;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            --this.currentPosition;
            throw new InvalidInputException(INVALID_UNICODE_ESCAPE);
        }
    }

    public NLSTag[] getNLSTags() {
        int n = this.nlsTagsPtr;
        if (n != 0) {
            NLSTag[] nLSTagArray = new NLSTag[n];
            System.arraycopy(this.nlsTags, 0, nLSTagArray, 0, n);
            this.nlsTagsPtr = 0;
            return nLSTagArray;
        }
        return null;
    }

    public char[] getSource() {
        return this.source;
    }

    public final void jumpOverMethodBody() {
        throw new UnsupportedOperationException("TODO");
    }

    final char[] optimizedCurrentTokenSource1() {
        char c = this.source[this.startPosition];
        switch (c) {
            case 'a': {
                return charArray_a;
            }
            case 'b': {
                return charArray_b;
            }
            case 'c': {
                return charArray_c;
            }
            case 'd': {
                return charArray_d;
            }
            case 'e': {
                return charArray_e;
            }
            case 'f': {
                return charArray_f;
            }
            case 'g': {
                return charArray_g;
            }
            case 'h': {
                return charArray_h;
            }
            case 'i': {
                return charArray_i;
            }
            case 'j': {
                return charArray_j;
            }
            case 'k': {
                return charArray_k;
            }
            case 'l': {
                return charArray_l;
            }
            case 'm': {
                return charArray_m;
            }
            case 'n': {
                return charArray_n;
            }
            case 'o': {
                return charArray_o;
            }
            case 'p': {
                return charArray_p;
            }
            case 'q': {
                return charArray_q;
            }
            case 'r': {
                return charArray_r;
            }
            case 's': {
                return charArray_s;
            }
            case 't': {
                return charArray_t;
            }
            case 'u': {
                return charArray_u;
            }
            case 'v': {
                return charArray_v;
            }
            case 'w': {
                return charArray_w;
            }
            case 'x': {
                return charArray_x;
            }
            case 'y': {
                return charArray_y;
            }
            case 'z': {
                return charArray_z;
            }
        }
        return new char[]{c};
    }

    final char[] optimizedCurrentTokenSource2() {
        char[] cArray;
        char[] cArray2 = this.source;
        int n = this.startPosition;
        char c = cArray2[n];
        char c2 = cArray2[n + 1];
        int n2 = ((c << 6) + c2) % 30;
        char[][] cArray3 = this.charArray_length[0][n2];
        int n3 = this.newEntry2;
        while (++n3 < 6) {
            char[] cArray4 = cArray3[n3];
            if (c != cArray4[0] || c2 != cArray4[1]) continue;
            return cArray4;
        }
        n3 = -1;
        int n4 = this.newEntry2;
        while (++n3 <= n4) {
            cArray = cArray3[n3];
            if (c != cArray[0] || c2 != cArray[1]) continue;
            return cArray;
        }
        if (++n4 >= 6) {
            n4 = 0;
        }
        cArray = new char[2];
        System.arraycopy(cArray2, n, cArray, 0, 2);
        this.newEntry2 = n4;
        cArray3[this.newEntry2] = cArray;
        return cArray;
    }

    final char[] optimizedCurrentTokenSource3() {
        char[] cArray;
        char[] cArray2 = this.source;
        int n = this.startPosition;
        char c = cArray2[n + 1];
        char c2 = cArray2[n];
        char c3 = cArray2[n + 2];
        int n2 = ((c2 << 6) + c3) % 30;
        char[][] cArray3 = this.charArray_length[1][n2];
        int n3 = this.newEntry3;
        while (++n3 < 6) {
            char[] cArray4 = cArray3[n3];
            if (c2 != cArray4[0] || c != cArray4[1] || c3 != cArray4[2]) continue;
            return cArray4;
        }
        n3 = -1;
        int n4 = this.newEntry3;
        while (++n3 <= n4) {
            cArray = cArray3[n3];
            if (c2 != cArray[0] || c != cArray[1] || c3 != cArray[2]) continue;
            return cArray;
        }
        if (++n4 >= 6) {
            n4 = 0;
        }
        cArray = new char[3];
        System.arraycopy(cArray2, n, cArray, 0, 3);
        this.newEntry3 = n4;
        cArray3[this.newEntry3] = cArray;
        return cArray;
    }

    final char[] optimizedCurrentTokenSource4() {
        char[] cArray;
        char[] cArray2 = this.source;
        int n = this.startPosition;
        char c = cArray2[n + 1];
        char c2 = cArray2[n + 3];
        char c3 = cArray2[n];
        char c4 = cArray2[n + 2];
        int n2 = ((c3 << 6) + c4) % 30;
        char[][] cArray3 = this.charArray_length[2][n2];
        int n3 = this.newEntry4;
        while (++n3 < 6) {
            char[] cArray4 = cArray3[n3];
            if (c3 != cArray4[0] || c != cArray4[1] || c4 != cArray4[2] || c2 != cArray4[3]) continue;
            return cArray4;
        }
        n3 = -1;
        int n4 = this.newEntry4;
        while (++n3 <= n4) {
            cArray = cArray3[n3];
            if (c3 != cArray[0] || c != cArray[1] || c4 != cArray[2] || c2 != cArray[3]) continue;
            return cArray;
        }
        if (++n4 >= 6) {
            n4 = 0;
        }
        cArray = new char[4];
        System.arraycopy(cArray2, n, cArray, 0, 4);
        this.newEntry4 = n4;
        cArray3[this.newEntry4] = cArray;
        return cArray;
    }

    final char[] optimizedCurrentTokenSource5() {
        char[] cArray;
        char[] cArray2 = this.source;
        int n = this.startPosition;
        char c = cArray2[n + 1];
        char c2 = cArray2[n + 3];
        char c3 = cArray2[n];
        char c4 = cArray2[n + 2];
        char c5 = cArray2[n + 4];
        int n2 = ((c3 << 12) + (c4 << 6) + c5) % 30;
        char[][] cArray3 = this.charArray_length[3][n2];
        int n3 = this.newEntry5;
        while (++n3 < 6) {
            char[] cArray4 = cArray3[n3];
            if (c3 != cArray4[0] || c != cArray4[1] || c4 != cArray4[2] || c2 != cArray4[3] || c5 != cArray4[4]) continue;
            return cArray4;
        }
        n3 = -1;
        int n4 = this.newEntry5;
        while (++n3 <= n4) {
            cArray = cArray3[n3];
            if (c3 != cArray[0] || c != cArray[1] || c4 != cArray[2] || c2 != cArray[3] || c5 != cArray[4]) continue;
            return cArray;
        }
        if (++n4 >= 6) {
            n4 = 0;
        }
        cArray = new char[5];
        System.arraycopy(cArray2, n, cArray, 0, 5);
        this.newEntry5 = n4;
        cArray3[this.newEntry5] = cArray;
        return cArray;
    }

    final char[] optimizedCurrentTokenSource6() {
        char[] cArray;
        char[] cArray2 = this.source;
        int n = this.startPosition;
        char c = cArray2[n + 1];
        char c2 = cArray2[n + 3];
        char c3 = cArray2[n + 5];
        char c4 = cArray2[n];
        char c5 = cArray2[n + 2];
        char c6 = cArray2[n + 4];
        int n2 = ((c4 << 12) + (c5 << 6) + c6) % 30;
        char[][] cArray3 = this.charArray_length[4][n2];
        int n3 = this.newEntry6;
        while (++n3 < 6) {
            char[] cArray4 = cArray3[n3];
            if (c4 != cArray4[0] || c != cArray4[1] || c5 != cArray4[2] || c2 != cArray4[3] || c6 != cArray4[4] || c3 != cArray4[5]) continue;
            return cArray4;
        }
        n3 = -1;
        int n4 = this.newEntry6;
        while (++n3 <= n4) {
            cArray = cArray3[n3];
            if (c4 != cArray[0] || c != cArray[1] || c5 != cArray[2] || c2 != cArray[3] || c6 != cArray[4] || c3 != cArray[5]) continue;
            return cArray;
        }
        if (++n4 >= 6) {
            n4 = 0;
        }
        cArray = new char[6];
        System.arraycopy(cArray2, n, cArray, 0, 6);
        this.newEntry6 = n4;
        cArray3[this.newEntry6] = cArray;
        return cArray;
    }

    private void parseTags() {
        int n = 0;
        int n2 = this.startPosition;
        int n3 = this.linePtr;
        if (n3 >= 0) {
            n = this.lineEnds[n3] + 1;
        }
        while (ScannerHelper.isWhitespace(this.source[n])) {
            ++n;
        }
        if (n2 == n) {
            return;
        }
        char[] cArray = null;
        int n4 = this.currentPosition;
        int n5 = n2;
        int n6 = 0;
        if (this.withoutUnicodePtr != 0) {
            cArray = new char[this.withoutUnicodePtr];
            System.arraycopy(this.withoutUnicodeBuffer, 1, cArray, 0, this.withoutUnicodePtr);
            n4 = this.withoutUnicodePtr;
            n5 = 1;
            n6 = n2;
        } else {
            cArray = this.source;
        }
        int n7 = CharOperation.indexOf(TAG_PREFIX, cArray, true, n5, n4);
        if (n7 != -1) {
            if (this.nlsTags == null) {
                this.nlsTags = new NLSTag[10];
                this.nlsTagsPtr = 0;
            }
            while (n7 != -1) {
                int n8 = n7 + TAG_PREFIX_LENGTH;
                int n9 = CharOperation.indexOf('$', cArray, n8, n4);
                if (n9 != -1) {
                    NLSTag nLSTag = null;
                    int n10 = n3 + 1;
                    try {
                        nLSTag = new NLSTag(n7 + n6, n9 + n6, n10, this.extractInt(cArray, n8, n9));
                    }
                    catch (NumberFormatException numberFormatException) {
                        nLSTag = new NLSTag(n7 + n6, n9 + n6, n10, -1);
                    }
                    if (this.nlsTagsPtr == this.nlsTags.length) {
                        this.nlsTags = new NLSTag[this.nlsTagsPtr + 10];
                        System.arraycopy(this.nlsTags, 0, this.nlsTags, 0, this.nlsTagsPtr);
                    }
                    this.nlsTags[this.nlsTagsPtr++] = nLSTag;
                } else {
                    n9 = n8;
                }
                n7 = CharOperation.indexOf(TAG_PREFIX, cArray, true, n9, n4);
            }
        }
    }

    private int extractInt(char[] cArray, int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            char c = cArray[i];
            int n4 = 0;
            switch (c) {
                case '0': {
                    n4 = 0;
                    break;
                }
                case '1': {
                    n4 = 1;
                    break;
                }
                case '2': {
                    n4 = 2;
                    break;
                }
                case '3': {
                    n4 = 3;
                    break;
                }
                case '4': {
                    n4 = 4;
                    break;
                }
                case '5': {
                    n4 = 5;
                    break;
                }
                case '6': {
                    n4 = 6;
                    break;
                }
                case '7': {
                    n4 = 7;
                    break;
                }
                case '8': {
                    n4 = 8;
                    break;
                }
                case '9': {
                    n4 = 9;
                    break;
                }
                default: {
                    throw new NumberFormatException();
                }
            }
            n3 *= 10;
            if (n4 < 0) {
                throw new NumberFormatException();
            }
            n3 += n4;
        }
        return n3;
    }

    public final void pushLineSeparator(char c) {
        block12: {
            if (c == '\r') {
                int n = this.currentPosition - 1;
                if (this.linePtr >= 0 && this.lineEnds[this.linePtr] >= n) {
                    return;
                }
                int n2 = this.lineEnds.length;
                if (++this.linePtr >= n2) {
                    this.lineEnds = new int[n2 + 250];
                    System.arraycopy(this.lineEnds, 0, this.lineEnds, 0, n2);
                }
                this.lineEnds[this.linePtr] = n;
                try {
                    if (this.source[this.currentPosition] == '\n') {
                        this.lineEnds[this.linePtr] = this.currentPosition++;
                        this.wasAcr = false;
                        break block12;
                    }
                    this.wasAcr = true;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    this.wasAcr = true;
                }
            } else if (c == '\n') {
                if (this.wasAcr && this.lineEnds[this.linePtr] == this.currentPosition - 2) {
                    this.lineEnds[this.linePtr] = this.currentPosition - 1;
                } else {
                    int n = this.currentPosition - 1;
                    if (this.linePtr >= 0 && this.lineEnds[this.linePtr] >= n) {
                        return;
                    }
                    int n3 = this.lineEnds.length;
                    if (++this.linePtr >= n3) {
                        this.lineEnds = new int[n3 + 250];
                        System.arraycopy(this.lineEnds, 0, this.lineEnds, 0, n3);
                    }
                    this.lineEnds[this.linePtr] = n;
                }
                this.wasAcr = false;
            }
        }
    }

    public void recordComment(int n) {
        int n2 = this.currentPosition;
        switch (n) {
            case 1001: {
                n2 = -this.lastCommentLinePosition;
                break;
            }
            case 1002: {
                n2 = -this.currentPosition;
            }
        }
        int n3 = this.commentStops.length;
        if (++this.commentPtr >= n3) {
            int n4 = n3 + COMMENT_ARRAYS_SIZE * 10;
            this.commentStops = new int[n4];
            System.arraycopy(this.commentStops, 0, this.commentStops, 0, n3);
            this.commentStarts = new int[n4];
            System.arraycopy(this.commentStarts, 0, this.commentStarts, 0, n3);
            this.commentTagStarts = new int[n4];
            System.arraycopy(this.commentTagStarts, 0, this.commentTagStarts, 0, n3);
        }
        this.commentStops[this.commentPtr] = n2;
        this.commentStarts[this.commentPtr] = this.startPosition;
    }

    public void resetTo(int n, int n2) {
        this.diet = false;
        this.startPosition = this.currentPosition = n;
        this.initialPosition = this.currentPosition;
        this.eofPosition = this.source != null && this.source.length < n2 ? this.source.length : (n2 < Integer.MAX_VALUE ? n2 + 1 : n2);
        this.commentPtr = -1;
        this.foundTaskCount = 0;
    }

    public int scanIdentifierOrKeyword() {
        int n;
        char[] cArray = this.source;
        int n2 = this.source.length;
        while (this.currentPosition < n2) {
            n = cArray[this.currentPosition];
            if (n < 128) {
                if ((ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[n] & 0x3C) != 0) {
                    if (this.withoutUnicodePtr != 0) {
                        this.unicodeStore((char)n);
                    }
                    ++this.currentPosition;
                    continue;
                }
                if ((ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[n] & 0x102) != 0) break;
                while (this.getNextCharAsJavaIdentifierPart()) {
                }
            } else {
                while (this.getNextCharAsJavaIdentifierPart()) {
                }
            }
            break;
        }
        if (this.withoutUnicodePtr != 0 || (this.flags & 1) != 0) {
            return 37;
        }
        n2 = this.currentPosition - this.startPosition;
        if (n2 == 1) {
            return 37;
        }
        n = this.startPosition;
        switch (cArray[n]) {
            case 'a': {
                switch (n2) {
                    case 2: {
                        if (cArray[++n] == 's' && (this.sourceLevel & 0x1000) != 0) {
                            return 19;
                        }
                        return 37;
                    }
                }
                return 37;
            }
            case 'b': {
                if (n2 == 5 && cArray[++n] == 'r' && cArray[++n] == 'e' && cArray[++n] == 'a' && cArray[++n] == 'k') {
                    return 73;
                }
                return 37;
            }
            case 'c': {
                switch (n2) {
                    case 4: {
                        if (cArray[++n] == 'a' && cArray[++n] == 's' && cArray[++n] == 'e') {
                            return 102;
                        }
                        return 37;
                    }
                    case 5: {
                        if (cArray[++n] == 'a') {
                            if (cArray[++n] == 't' && cArray[++n] == 'c' && cArray[++n] == 'h') {
                                return 103;
                            }
                            return 37;
                        }
                        if (cArray[n] == 'l') {
                            if ((this.sourceLevel & 0x10) != 0 && cArray[++n] == 'a' && cArray[++n] == 's' && cArray[++n] == 's') {
                                return 71;
                            }
                            return 37;
                        }
                        if (cArray[n] == 'o' && (this.sourceLevel & 0x800) == 0 && cArray[++n] == 'n' && cArray[++n] == 's' && cArray[++n] == 't') {
                            return 67;
                        }
                        return 37;
                    }
                    case 8: {
                        if (cArray[++n] == 'o' && cArray[++n] == 'n' && cArray[++n] == 't' && cArray[++n] == 'i' && cArray[++n] == 'n' && cArray[++n] == 'u' && cArray[++n] == 'e') {
                            return 74;
                        }
                        return 37;
                    }
                }
                return 37;
            }
            case 'd': {
                switch (n2) {
                    case 2: {
                        if (cArray[++n] == 'o') {
                            return 75;
                        }
                        return 37;
                    }
                    case 6: {
                        if (cArray[++n] == 'e' && cArray[++n] == 'l' && cArray[++n] == 'e' && cArray[++n] == 't' && cArray[++n] == 'e') {
                            return 61;
                        }
                        return 37;
                    }
                    case 7: {
                        if (cArray[++n] == 'e' && cArray[++n] == 'f' && cArray[++n] == 'a' && cArray[++n] == 'u' && cArray[++n] == 'l' && cArray[++n] == 't') {
                            return 100;
                        }
                        return 37;
                    }
                    case 8: {
                        if (cArray[++n] == 'e' && (this.sourceLevel & 0x800) == 0 && cArray[++n] == 'b' && cArray[++n] == 'u' && cArray[++n] == 'g' && cArray[++n] == 'g' && cArray[++n] == 'e' && cArray[++n] == 'r') {
                            return 115;
                        }
                        return 37;
                    }
                }
                return 37;
            }
            case 'e': {
                switch (n2) {
                    case 4: {
                        if (cArray[++n] == 'l' && cArray[++n] == 's' && cArray[++n] == 'e') {
                            return 49;
                        }
                        if (cArray[n] == 'a' && (this.sourceLevel & 1) != 0 && cArray[++n] == 'c' && cArray[++n] == 'h') {
                            return 84;
                        }
                        return 37;
                    }
                    case 6: {
                        if (cArray[++n] == 'x' && (this.sourceLevel & 0x400) == 0 && cArray[++n] == 'p' && cArray[++n] == 'o' && cArray[++n] == 'r' && cArray[++n] == 't') {
                            return 114;
                        }
                        return 37;
                    }
                    case 7: {
                        if (cArray[++n] == 'x' && (this.sourceLevel & 0x10) != 0 && cArray[++n] == 't' && cArray[++n] == 'e' && cArray[++n] == 'n' && cArray[++n] == 'd' && cArray[++n] == 's') {
                            return 104;
                        }
                        return 37;
                    }
                }
                return 37;
            }
            case 'f': {
                switch (n2) {
                    case 3: {
                        if (cArray[++n] == 'o' && cArray[++n] == 'r') {
                            return 76;
                        }
                        return 37;
                    }
                    case 5: {
                        if (cArray[++n] == 'a' && cArray[++n] == 'l' && cArray[++n] == 's' && cArray[++n] == 'e') {
                            return 42;
                        }
                        return 37;
                    }
                    case 7: {
                        if (cArray[++n] == 'i' && cArray[++n] == 'n' && cArray[++n] == 'a' && cArray[++n] == 'l' && cArray[++n] == 'l' && cArray[++n] == 'y') {
                            return 101;
                        }
                        return 37;
                    }
                    case 8: {
                        if (cArray[++n] == 'u' && cArray[++n] == 'n' && cArray[++n] == 'c' && cArray[++n] == 't' && cArray[++n] == 'i' && cArray[++n] == 'o' && cArray[++n] == 'n') {
                            return 50;
                        }
                        return 37;
                    }
                }
                return 37;
            }
            case 'g': {
                if (n2 == 3 && cArray[++n] == 'e' && cArray[++n] == 't' && (this.sourceLevel & 0x400) != 0) {
                    return 111;
                }
                return 37;
            }
            case 'i': {
                switch (n2) {
                    case 2: {
                        switch (cArray[++n]) {
                            case 'f': {
                                return 77;
                            }
                            case 'n': {
                                return 27;
                            }
                            case 's': {
                                return (this.sourceLevel & 0x1000) == 0 ? 37 : 21;
                            }
                        }
                        return 37;
                    }
                    case 6: {
                        if (cArray[++n] == 'm' && cArray[++n] == 'p' && cArray[++n] == 'o' && cArray[++n] == 'r' && cArray[++n] == 't') {
                            return 105;
                        }
                        return 37;
                    }
                    case 7: {
                        if (cArray[++n] == 'n' && (this.sourceLevel & 0x1000) != 0 && cArray[++n] == 'c' && cArray[++n] == 'l' && cArray[++n] == 'u' && cArray[++n] == 'd' && cArray[++n] == 'e') {
                            return 109;
                        }
                        return 37;
                    }
                    case 9: {
                        if (cArray[++n] == 'n' && cArray[++n] == 't' && cArray[++n] == 'e' && cArray[++n] == 'r' && cArray[++n] == 'f' && cArray[++n] == 'a' && cArray[++n] == 'c' && cArray[++n] == 'e') {
                            return 72;
                        }
                        return 37;
                    }
                    case 10: {
                        if (cArray[++n] == 'm') {
                            if (cArray[++n] == 'p' && cArray[++n] == 'l' && cArray[++n] == 'e' && cArray[++n] == 'm' && cArray[++n] == 'e' && cArray[++n] == 'n' && cArray[++n] == 't' && cArray[++n] == 's') {
                                return 113;
                            }
                            return 37;
                        }
                        if (cArray[n] == 'n' && cArray[++n] == 's' && cArray[++n] == 't' && cArray[++n] == 'a' && cArray[++n] == 'n' && cArray[++n] == 'c' && cArray[++n] == 'e' && cArray[++n] == 'o' && cArray[++n] == 'f') {
                            return 20;
                        }
                        return 37;
                    }
                }
                return 37;
            }
            case 'n': {
                switch (n2) {
                    case 3: {
                        if (cArray[++n] == 'e' && cArray[++n] == 'w') {
                            return 54;
                        }
                        return 37;
                    }
                    case 4: {
                        if (cArray[++n] == 'u' && cArray[++n] == 'l' && cArray[++n] == 'l') {
                            return 55;
                        }
                        return 37;
                    }
                    case 9: {
                        if (cArray[++n] == 'a' && (this.sourceLevel & 1) != 0 && cArray[++n] == 'm' && cArray[++n] == 'e' && cArray[++n] == 's' && cArray[++n] == 'p' && cArray[++n] == 'a' && cArray[++n] == 'c' && cArray[++n] == 'e') {
                            return 85;
                        }
                        return 37;
                    }
                }
                return 37;
            }
            case 'p': {
                switch (n2) {
                    case 6: {
                        if (cArray[++n] == 'u' && cArray[++n] == 'b' && cArray[++n] == 'l' && cArray[++n] == 'i' && cArray[++n] == 'c') {
                            return 39;
                        }
                        if (cArray[n] == 'r' && (this.sourceLevel & 0x200000) != 0 && cArray[++n] == 'a' && cArray[++n] == 'g' && cArray[++n] == 'm' && cArray[++n] == 'a') {
                            return 110;
                        }
                        return 37;
                    }
                    case 7: {
                        if (cArray[++n] == 'a') {
                            if (cArray[++n] == 'c' && (this.sourceLevel & 0x1000) != 0 && cArray[++n] == 'k' && cArray[++n] == 'a' && cArray[++n] == 'g' && cArray[++n] == 'e') {
                                return 106;
                            }
                            return 37;
                        }
                        if (cArray[n] == 'r' && cArray[++n] == 'i' && cArray[++n] == 'v' && cArray[++n] == 'a' && cArray[++n] == 't' && cArray[++n] == 'e') {
                            return 38;
                        }
                        return 37;
                    }
                    case 9: {
                        if (cArray[++n] == 'r' && (this.sourceLevel & 0x1000) != 0 && cArray[++n] == 'o' && cArray[++n] == 't' && cArray[++n] == 'e' && cArray[++n] == 'c' && cArray[++n] == 't' && cArray[++n] == 'e' && cArray[++n] == 'd') {
                            return 40;
                        }
                        return 37;
                    }
                }
                return 37;
            }
            case 'r': {
                if (n2 == 6 && cArray[++n] == 'e' && cArray[++n] == 't' && cArray[++n] == 'u' && cArray[++n] == 'r' && cArray[++n] == 'n') {
                    return 78;
                }
                return 37;
            }
            case 's': {
                switch (n2) {
                    case 3: {
                        if (cArray[++n] == 'e' && cArray[++n] == 't' && (this.sourceLevel & 0x400) != 0) {
                            return 112;
                        }
                        return 37;
                    }
                    case 5: {
                        if (cArray[++n] == 'u' && cArray[++n] == 'p' && cArray[++n] == 'e' && cArray[++n] == 'r') {
                            return 56;
                        }
                        return 37;
                    }
                    case 6: {
                        if (cArray[++n] == 'w' && cArray[++n] == 'i' && cArray[++n] == 't' && cArray[++n] == 'c' && cArray[++n] == 'h') {
                            return 79;
                        }
                        return 37;
                    }
                }
            }
            case 't': {
                switch (n2) {
                    case 3: {
                        if (cArray[++n] == 'r' && cArray[++n] == 'y') {
                            return 81;
                        }
                        return 37;
                    }
                    case 4: {
                        if (cArray[++n] == 'h') {
                            if (cArray[++n] == 'i' && cArray[++n] == 's') {
                                return 57;
                            }
                            return 37;
                        }
                        if (cArray[n] == 'r' && cArray[++n] == 'u' && cArray[++n] == 'e') {
                            return 43;
                        }
                        return 37;
                    }
                    case 5: {
                        if (cArray[++n] == 'h' && cArray[++n] == 'r' && cArray[++n] == 'o' && cArray[++n] == 'w') {
                            return 80;
                        }
                        return 37;
                    }
                    case 6: {
                        if (cArray[++n] == 'y' && cArray[++n] == 'p' && cArray[++n] == 'e' && cArray[++n] == 'o' && cArray[++n] == 'f') {
                            return 62;
                        }
                        return 37;
                    }
                }
                return 37;
            }
            case 'u': {
                if (n2 == 3 && cArray[++n] == 's' && cArray[++n] == 'e' && (this.sourceLevel & 0x1000) != 0) {
                    return 107;
                }
                return 37;
            }
            case 'v': {
                switch (n2) {
                    case 3: {
                        if (cArray[++n] == 'a' && cArray[++n] == 'r') {
                            return 68;
                        }
                        return 37;
                    }
                    case 4: {
                        if (cArray[++n] == 'o' && cArray[++n] == 'i' && cArray[++n] == 'd') {
                            return 63;
                        }
                        return 37;
                    }
                }
                return 37;
            }
            case 'w': {
                switch (n2) {
                    case 4: {
                        if (cArray[++n] == 'i' && cArray[++n] == 't' && cArray[++n] == 'h') {
                            return 82;
                        }
                        return 37;
                    }
                    case 5: {
                        if (cArray[++n] == 'h' && cArray[++n] == 'i' && cArray[++n] == 'l' && cArray[++n] == 'e') {
                            return 58;
                        }
                        return 37;
                    }
                }
                return 37;
            }
            case 'x': {
                if (n2 == 3 && cArray[++n] == 'm' && cArray[++n] == 'l' && (this.sourceLevel & 1) != 0) {
                    return 108;
                }
                return 37;
            }
        }
        return 37;
    }

    private final void scanNumber(boolean bl) throws InvalidInputException {
        char[] cArray = this.source;
        char c = cArray[this.currentPosition - 1];
        if (!bl && (c == '0' || Scanner.isJSFormat(c) && this.getNextChar('0'))) {
            if (this.getNextChar('x', 'X') >= 0) {
                int n = 0;
                while (this.getNextCharAsDigit(16)) {
                    ++n;
                }
                if (n == 0) {
                    throw new InvalidInputException(INVALID_HEXA);
                }
                return;
            }
            if (this.getNextCharAsDigit()) {
                while (this.getNextCharAsDigit()) {
                }
                if (this.getNextChar('.')) {
                    while (this.getNextCharAsDigit()) {
                    }
                }
                if (this.getNextChar('e', 'E') >= 0) {
                    block23: {
                        boolean bl2 = true;
                        do {
                            if ((c = cArray[this.currentPosition++]) >= '\u0080') continue;
                            if (c == '-' || c == '+') {
                                if (bl2) {
                                    bl2 = false;
                                    c = cArray[this.currentPosition++];
                                } else {
                                    throw new InvalidInputException(INVALID_FLOAT);
                                }
                            }
                            if ((ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[c] & 4) != 0) break block23;
                        } while (Scanner.isJSFormat(c));
                        throw new InvalidInputException(INVALID_FLOAT);
                    }
                    while (this.getNextCharAsDigit()) {
                    }
                }
                return;
            }
        }
        while (this.getNextCharAsDigit()) {
        }
        if (!bl && this.getNextChar('.')) {
            while (this.getNextCharAsDigit()) {
            }
        }
        if (this.getNextChar('e', 'E') >= 0) {
            block24: {
                boolean bl3 = true;
                do {
                    if ((c = cArray[this.currentPosition++]) >= '\u0080') continue;
                    if (c == '-' || c == '+') {
                        if (bl3) {
                            bl3 = false;
                            c = cArray[this.currentPosition++];
                        } else {
                            throw new InvalidInputException(INVALID_FLOAT);
                        }
                    }
                    if ((ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[c] & 4) != 0) break block24;
                } while (Scanner.isJSFormat(c));
                throw new InvalidInputException(INVALID_FLOAT);
            }
            while (this.getNextCharAsDigit()) {
            }
        }
    }

    public final int getLineNumber(int n) {
        if (this.lineEnds == null) {
            return 1;
        }
        int n2 = this.linePtr + 1;
        if (n2 == 0) {
            return 1;
        }
        int n3 = 0;
        int n4 = n2 - 1;
        int n5 = 0;
        while (n3 <= n4) {
            n5 = (n3 + n4) / 2;
            if (n < this.lineEnds[n5]) {
                n4 = n5 - 1;
                continue;
            }
            if (n > this.lineEnds[n5]) {
                n3 = n5 + 1;
                continue;
            }
            return n5 + 1;
        }
        if (n < this.lineEnds[n5]) {
            return n5 + 1;
        }
        return n5 + 2;
    }

    public void setSource(char[] cArray) {
        int n;
        if (cArray == null) {
            this.source = CharOperation.NO_CHAR;
            n = 0;
        } else {
            this.source = cArray;
            n = cArray.length;
        }
        this.startPosition = -1;
        this.eofPosition = n;
        this.currentPosition = 0;
        this.initialPosition = 0;
        this.linePtr = -1;
    }

    public final void setSource(char[] cArray, CompilationResult compilationResult) {
        Object[] objectArray;
        if (cArray == null) {
            objectArray = compilationResult.compilationUnit.getContents();
            this.setSource((char[])objectArray);
        } else {
            this.setSource(cArray);
        }
        objectArray = compilationResult.lineSeparatorPositions;
        if (objectArray != null) {
            this.lineEnds = objectArray;
            this.linePtr = objectArray.length - 1;
        }
    }

    public final void setSource(CompilationResult compilationResult) {
        this.setSource(null, compilationResult);
    }

    public String toString() {
        char[] cArray;
        if (this.startPosition == this.source.length) {
            return "EOF\n\n" + new String(this.source);
        }
        if (this.currentPosition > this.source.length) {
            return "behind the EOF\n\n" + new String(this.source);
        }
        char[] cArray2 = new char[this.startPosition];
        System.arraycopy(this.source, 0, cArray2, 0, this.startPosition);
        int n = this.currentPosition - 1 - this.startPosition + 1;
        if (n > -1) {
            cArray = new char[n];
            System.arraycopy(this.source, this.startPosition, cArray, 0, n);
        } else {
            cArray = CharOperation.NO_CHAR;
        }
        char[] cArray3 = new char[this.source.length - (this.currentPosition - 1)];
        System.arraycopy(this.source, this.currentPosition - 1 + 1, cArray3, 0, this.source.length - (this.currentPosition - 1) - 1);
        return new String(cArray2) + "\n===============================\nStarts here -->" + new String(cArray) + "<-- Ends here\n===============================\n" + new String(cArray3);
    }

    public void unicodeInitializeBuffer(int n) {
        int n2;
        this.withoutUnicodePtr = n;
        if (this.withoutUnicodeBuffer == null) {
            this.withoutUnicodeBuffer = new char[n + 11];
        }
        if (1 + n >= (n2 = this.withoutUnicodeBuffer.length)) {
            this.withoutUnicodeBuffer = new char[n + 11];
            System.arraycopy(this.withoutUnicodeBuffer, 0, this.withoutUnicodeBuffer, 0, n2);
        }
        System.arraycopy(this.source, this.startPosition, this.withoutUnicodeBuffer, 1, n);
    }

    public void unicodeStore(char c) {
        int n;
        int n2 = ++this.withoutUnicodePtr;
        if (this.withoutUnicodeBuffer == null) {
            this.withoutUnicodeBuffer = new char[10];
        }
        if (n2 == (n = this.withoutUnicodeBuffer.length)) {
            this.withoutUnicodeBuffer = new char[n * 2];
            System.arraycopy(this.withoutUnicodeBuffer, 0, this.withoutUnicodeBuffer, 0, n);
        }
        this.withoutUnicodeBuffer[n2] = c;
    }

    private static final boolean isWhitespace(char c) {
        if (c < '\u0080') {
            return (ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[c] & 0x100) != 0;
        }
        return c == '\u00a0' || c == '\u3000' || c >= '\u2000' && c < '\u200c';
    }

    private static final boolean isJSFormat(char c) {
        return c > '\u0080' && Character.getType(c) == 16;
    }
}

