/*
 * Decompiled with CFR 0.152.
 */
package com.spket.as.internal.compiler.ast;

import com.spket.as.internal.compiler.ASTVisitor;
import com.spket.as.internal.compiler.ast.EmptyStatement;
import com.spket.as.internal.compiler.ast.Expression;
import com.spket.as.internal.compiler.ast.Statement;
import com.spket.as.internal.compiler.lookup.Frame;

public class WhileStatement
extends Statement {
    public Expression condition;
    public Statement action;

    public WhileStatement(Expression expression, Statement statement, int n, int n2) {
        this.condition = expression;
        this.action = statement;
        if (statement instanceof EmptyStatement) {
            statement.bits |= 1;
        }
        this.sourceStart = n;
        this.sourceEnd = n2;
    }

    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        WhileStatement.printIndent(n, stringBuffer).append("while (");
        this.condition.printExpression(0, stringBuffer).append(')');
        if (this.action == null) {
            stringBuffer.append(';');
        } else {
            this.action.printStatement(n + 1, stringBuffer);
        }
        return stringBuffer;
    }

    public void traverse(ASTVisitor aSTVisitor, Frame frame) {
        if (aSTVisitor.visit(this, frame)) {
            this.condition.traverse(aSTVisitor, frame);
            if (this.action != null) {
                this.action.traverse(aSTVisitor, frame);
            }
        }
        aSTVisitor.endVisit(this, frame);
    }
}

