/*
 * Decompiled with CFR 0.152.
 */
package com.spket.as.internal.compiler.ast;

import com.spket.as.internal.compiler.ASTVisitor;
import com.spket.as.internal.compiler.ast.CaseStatement;
import com.spket.as.internal.compiler.ast.Expression;
import com.spket.as.internal.compiler.ast.Statement;
import com.spket.as.internal.compiler.lookup.BlockScope;
import com.spket.as.internal.compiler.lookup.Frame;

public class SwitchStatement
extends Statement {
    public Expression expression;
    public Statement[] statements;
    public int blockStart;
    public BlockScope frame;

    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        SwitchStatement.printIndent(n, stringBuffer).append("switch (");
        this.expression.printExpression(0, stringBuffer).append(") {");
        if (this.statements != null) {
            for (int i = 0; i < this.statements.length; ++i) {
                stringBuffer.append('\n');
                if (this.statements[i] instanceof CaseStatement) {
                    this.statements[i].printStatement(n, stringBuffer);
                    continue;
                }
                this.statements[i].printStatement(n + 2, stringBuffer);
            }
        }
        stringBuffer.append("\n");
        return SwitchStatement.printIndent(n, stringBuffer).append('}');
    }

    public void traverse(ASTVisitor aSTVisitor, Frame frame) {
        if (aSTVisitor.visit(this, frame)) {
            this.expression.traverse(aSTVisitor, this.frame);
            if (this.statements != null) {
                int n = this.statements.length;
                for (int i = 0; i < n; ++i) {
                    this.statements[i].traverse(aSTVisitor, this.frame);
                }
            }
        }
        aSTVisitor.endVisit(this, frame);
    }
}

