/*
 * Decompiled with CFR 0.152.
 */
package com.spket.as.internal.compiler.ast;

import com.spket.as.core.compiler.IProblem;
import com.spket.as.internal.compiler.ASTVisitor;
import com.spket.as.internal.compiler.CompilationResult;
import com.spket.as.internal.compiler.ast.Block;
import com.spket.as.internal.compiler.ast.Javadoc;
import com.spket.as.internal.compiler.ast.Statement;
import com.spket.as.internal.compiler.impl.ReferenceContext;
import com.spket.as.internal.compiler.lookup.Frame;
import com.spket.as.internal.compiler.lookup.PackageScope;
import com.spket.as.internal.compiler.problem.AbortPackage;
import com.spket.as.internal.compiler.problem.ProblemSeverities;

public class PackageDeclaration
extends Statement
implements ProblemSeverities,
ReferenceContext {
    public int[][] comments;
    public boolean ignoreFurtherInvestigation = false;
    public PackageScope frame;
    public CompilationResult compilationResult;
    public char[][] name;
    public long[] sourcePositions;
    public int declarationEnd;
    public int declarationSourceStart;
    public int declarationSourceEnd;
    public Block body;
    public Javadoc javadoc;

    public PackageDeclaration(CompilationResult compilationResult) {
        this.compilationResult = compilationResult;
    }

    public int getDeclarationEnd() {
        return this.declarationEnd;
    }

    public int getDeclarationSourceEnd() {
        return this.declarationSourceEnd;
    }

    public int getDeclarationSourceStart() {
        return this.declarationSourceStart;
    }

    public void abort(int n, IProblem iProblem) {
    }

    public CompilationResult compilationResult() {
        return this.compilationResult;
    }

    public boolean hasErrors() {
        return this.ignoreFurtherInvestigation;
    }

    public void tagAsHavingErrors() {
        this.ignoreFurtherInvestigation = true;
    }

    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        PackageDeclaration.printIndent(n, stringBuffer);
        stringBuffer.append("package ");
        if (this.name != null) {
            for (int i = 0; i < this.name.length; ++i) {
                if (i > 0) {
                    stringBuffer.append('.');
                }
                stringBuffer.append(this.name[i]);
            }
            stringBuffer.append(' ');
        }
        PackageDeclaration.printIndent(n, stringBuffer);
        stringBuffer.append("{\n");
        this.body.printBody(n, stringBuffer);
        return PackageDeclaration.printIndent(n, stringBuffer).append('}');
    }

    public void traverse(ASTVisitor aSTVisitor, Frame frame) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            if (aSTVisitor.visit(this, frame) && this.body != null) {
                this.body.traverseBody(aSTVisitor, this.frame);
            }
            aSTVisitor.endVisit(this, frame);
        }
        catch (AbortPackage abortPackage) {
            // empty catch block
        }
    }
}

