/*
 * Decompiled with CFR 0.152.
 */
package com.spket.as.internal.compiler.ast;

import com.spket.as.internal.compiler.ASTVisitor;
import com.spket.as.internal.compiler.ast.AttributeStatement;
import com.spket.as.internal.compiler.ast.Block;
import com.spket.as.internal.compiler.ast.Expression;
import com.spket.as.internal.compiler.ast.Parameter;
import com.spket.as.internal.compiler.lookup.Frame;
import com.spket.as.internal.compiler.lookup.FunctionScope;

public class FunctionDeclaration
extends AttributeStatement {
    public int kind;
    public char[] name;
    public Parameter[] parameters;
    public Expression resultType;
    public Block body;
    public int bodyStart;
    public int bodyEnd;
    public FunctionScope frame;

    public FunctionDeclaration(int n, char[] cArray, long l) {
        this.kind = n;
        this.name = cArray;
        this.sourceEnd = (int)l;
        this.sourceStart = (int)(l >>> 32);
        this.declarationEnd = this.sourceEnd;
    }

    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        FunctionDeclaration.printIndent(n, stringBuffer);
        this.printAttribute(stringBuffer);
        stringBuffer.append("function ");
        stringBuffer.append(this.name).append('(');
        if (this.parameters != null) {
            for (int i = 0; i < this.parameters.length; ++i) {
            }
        }
        stringBuffer.append(") {\n");
        this.body.printBody(n, stringBuffer);
        FunctionDeclaration.printIndent(n, stringBuffer);
        return stringBuffer.append("}");
    }

    public void traverse(ASTVisitor aSTVisitor, Frame frame) {
        if (aSTVisitor.visit(this, frame)) {
            if (this.resultType != null) {
                this.resultType.traverse(aSTVisitor, this.frame);
            }
            if (this.parameters != null) {
                for (int i = 0; i < this.parameters.length; ++i) {
                    this.parameters[i].traverse(aSTVisitor, this.frame);
                }
            }
            if (this.body != null) {
                this.body.traverseBody(aSTVisitor, this.frame);
            }
        }
        aSTVisitor.endVisit(this, frame);
    }
}

