/*
 * Decompiled with CFR 0.152.
 */
package com.spket.as.internal.compiler.ast;

import com.spket.as.internal.compiler.ASTVisitor;
import com.spket.as.internal.compiler.ast.Expression;
import com.spket.as.internal.compiler.ast.Statement;
import com.spket.as.internal.compiler.lookup.Frame;

public class ExpressionStatement
extends Statement {
    public Expression[] expressions;

    public ExpressionStatement(Expression expression) {
        this.expressions = new Expression[]{expression};
        this.sourceStart = expression.sourceStart;
        this.sourceEnd = expression.sourceEnd;
    }

    public ExpressionStatement(Expression[] expressionArray) {
        this.expressions = expressionArray;
        this.sourceStart = expressionArray[0].sourceStart;
        this.sourceEnd = expressionArray[expressionArray.length - 1].sourceEnd;
    }

    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        ExpressionStatement.printIndent(n, stringBuffer);
        int n2 = this.expressions.length;
        for (int i = 0; i < n2; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            this.expressions[i].printExpression(n, stringBuffer);
        }
        return stringBuffer.append(';');
    }

    public void traverse(ASTVisitor aSTVisitor, Frame frame) {
        if (aSTVisitor.visit(this, frame)) {
            int n = this.expressions.length;
            for (int i = 0; i < n; ++i) {
                this.expressions[i].traverse(aSTVisitor, frame);
            }
        }
        aSTVisitor.endVisit(this, frame);
    }
}

