/*
 * Decompiled with CFR 0.152.
 */
package com.spket.as.internal.compiler.ast;

import com.spket.as.internal.compiler.ASTVisitor;
import com.spket.as.internal.compiler.ast.EmptyStatement;
import com.spket.as.internal.compiler.ast.Expression;
import com.spket.as.internal.compiler.ast.Statement;
import com.spket.as.internal.compiler.lookup.Frame;

public class DoStatement
extends Statement {
    public Expression condition;
    public Statement action;

    public DoStatement(Expression expression, Statement statement, int n, int n2) {
        this.sourceStart = n;
        this.sourceEnd = n2;
        this.condition = expression;
        this.action = statement;
        if (statement instanceof EmptyStatement) {
            statement.bits |= 1;
        }
    }

    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        DoStatement.printIndent(n, stringBuffer).append("do");
        if (this.action == null) {
            stringBuffer.append(" ;\n");
        } else {
            stringBuffer.append('\n');
            this.action.printStatement(n + 1, stringBuffer).append('\n');
        }
        stringBuffer.append("while (");
        return this.condition.printExpression(0, stringBuffer).append(");");
    }

    public void traverse(ASTVisitor aSTVisitor, Frame frame) {
        if (aSTVisitor.visit(this, frame)) {
            if (this.action != null) {
                this.action.traverse(aSTVisitor, frame);
            }
            this.condition.traverse(aSTVisitor, frame);
        }
        aSTVisitor.endVisit(this, frame);
    }
}

