/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.text;

import com.spket.js.editors.JSEditor;
import com.spket.js.internal.text.JSAutoIndentStrategy;
import com.spket.js.internal.text.JSCodeScanner;
import com.spket.js.internal.text.JSCommentScanner;
import com.spket.js.internal.text.JSContentAssistProcessor;
import com.spket.js.internal.text.JSDocAutoIndentStrategy;
import com.spket.js.internal.text.JSDocDoubleClickStrategy;
import com.spket.js.internal.text.JSDocScanner;
import com.spket.js.internal.text.JSDoubleClickStrategy;
import com.spket.js.internal.text.JSReconciler;
import com.spket.js.internal.text.JSRegExpDoubleClickStrategy;
import com.spket.js.internal.text.JSStringAutoIndentStrategy;
import com.spket.js.internal.text.JSStringDoubleClickSelector;
import com.spket.js.internal.text.hover.JSHyperlinkDetector;
import com.spket.js.internal.text.hover.JSInformationProvider;
import com.spket.js.internal.text.hover.JSTextHover;
import com.spket.ui.text.ConfigurableScanner;
import com.spket.ui.text.IColorManager;
import com.spket.ui.text.IConfigurable;
import com.spket.ui.text.InformationControlCreator;
import com.spket.ui.text.SingleTokenScanner;
import com.spket.ui.text.html.HTMLTextPresenter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.texteditor.ITextEditor;

public class JSSourceViewerConfiguration
extends TextSourceViewerConfiguration
implements IConfigurable {
    private JSEditor fEditor;
    private IColorManager fColorManager;
    private String fDocumentPartitioning;
    private ConfigurableScanner fCodeScanner;
    private ConfigurableScanner fStringScanner;
    private ConfigurableScanner fRegExpScanner;
    private ConfigurableScanner fJSDocScanner;
    private ConfigurableScanner fMultilineCommentScanner;
    private ConfigurableScanner fSinglelineCommentScanner;
    private ContentAssistant fContentAssistant;
    private JSDoubleClickStrategy fDoubleClickStrategy;

    public JSSourceViewerConfiguration(JSEditor jSEditor, IColorManager iColorManager, IPreferenceStore iPreferenceStore, String string) {
        super(iPreferenceStore);
        this.fEditor = jSEditor;
        this.fColorManager = iColorManager;
        this.fDocumentPartitioning = string;
        this.initializeScanners();
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer iSourceViewer) {
        if (this.fDocumentPartitioning != null) {
            return this.fDocumentPartitioning;
        }
        return super.getConfiguredDocumentPartitioning(iSourceViewer);
    }

    public String[] getConfiguredContentTypes(ISourceViewer iSourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__js_jsdoc", "__js_multiline_comment", "__js_singleline_comment", "__js_string", "__js_regexp"};
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer iSourceViewer, String string) {
        if (this.fEditor != null) {
            String string2 = this.getConfiguredDocumentPartitioning(iSourceViewer);
            if ("__js_string".equals(string)) {
                return new IAutoEditStrategy[]{new JSStringAutoIndentStrategy(string2)};
            }
            if ("__js_jsdoc".equals(string) || "__js_multiline_comment".equals(string)) {
                return new IAutoEditStrategy[]{new JSDocAutoIndentStrategy(string2)};
            }
            return new IAutoEditStrategy[]{new JSAutoIndentStrategy(this.fEditor.getPartitioner())};
        }
        return super.getAutoEditStrategies(iSourceViewer, string);
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer iSourceViewer, String string) {
        if (this.fEditor == null) {
            return super.getDoubleClickStrategy(iSourceViewer, string);
        }
        if ("__js_jsdoc".equals(string)) {
            return new JSDocDoubleClickStrategy();
        }
        if ("__js_multiline_comment".equals(string) || "__js_singleline_comment".equals(string)) {
            return new DefaultTextDoubleClickStrategy();
        }
        if ("__js_string".equals(string)) {
            return new JSStringDoubleClickSelector(this.getConfiguredDocumentPartitioning(iSourceViewer));
        }
        if ("__js_regexp".equals(string)) {
            return new JSRegExpDoubleClickStrategy(this.getConfiguredDocumentPartitioning(iSourceViewer));
        }
        if (this.fDoubleClickStrategy == null) {
            this.fDoubleClickStrategy = new JSDoubleClickStrategy(this.fEditor.getPartitioner());
        }
        return this.fDoubleClickStrategy;
    }

    public IContentAssistant getContentAssistant(ISourceViewer iSourceViewer) {
        JSEditor jSEditor = this.getEditor();
        if (jSEditor != null) {
            ContentAssistant contentAssistant = this.fContentAssistant = new ContentAssistant();
            contentAssistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(iSourceViewer));
            JSContentAssistProcessor jSContentAssistProcessor = new JSContentAssistProcessor(jSEditor);
            contentAssistant.setContentAssistProcessor((IContentAssistProcessor)jSContentAssistProcessor, "__dftl_partition_content_type");
            String string = this.fPreferenceStore.getString("autoProposeChar");
            if (string != null && string.length() > 0) {
                jSContentAssistProcessor.setActivationCharacters(string.toCharArray());
            }
            contentAssistant.setContextInformationPopupOrientation(20);
            contentAssistant.setInformationControlCreator(this.getInformationControlCreator(iSourceViewer));
            contentAssistant.setAutoActivationDelay(this.fPreferenceStore.getInt("autoDelay"));
            contentAssistant.enableAutoActivation(this.fPreferenceStore.getBoolean("autoPropose"));
            return contentAssistant;
        }
        return null;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer iSourceViewer) {
        PresentationReconciler presentationReconciler = new PresentationReconciler();
        presentationReconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(iSourceViewer));
        DefaultDamagerRepairer defaultDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)this.getCodeScanner());
        presentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, "__dftl_partition_content_type");
        presentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, "__dftl_partition_content_type");
        defaultDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)this.getJSDocScanner());
        presentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, "__js_jsdoc");
        presentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, "__js_jsdoc");
        defaultDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)this.getMultilineCommentScanner());
        presentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, "__js_multiline_comment");
        presentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, "__js_multiline_comment");
        defaultDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)this.getSinglelineCommentScanner());
        presentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, "__js_singleline_comment");
        presentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, "__js_singleline_comment");
        defaultDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)this.getStringScanner());
        presentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, "__js_string");
        presentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, "__js_string");
        defaultDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)this.getRegExpScanner());
        presentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, "__js_regexp");
        presentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, "__js_regexp");
        return presentationReconciler;
    }

    public IReconciler getReconciler(ISourceViewer iSourceViewer) {
        if (this.fEditor != null) {
            JSReconciler jSReconciler = new JSReconciler(this.fEditor.getLexerProvider(), false);
            jSReconciler.setIsIncrementalReconciler(false);
            jSReconciler.setDelay(500);
            return jSReconciler;
        }
        return null;
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer iSourceViewer) {
        if (!this.fPreferenceStore.getBoolean("hyperlinksEnabled")) {
            return null;
        }
        if (this.fEditor == null) {
            return null;
        }
        IHyperlinkDetector[] iHyperlinkDetectorArray = new IHyperlinkDetector[]{new JSHyperlinkDetector((ITextEditor)this.fEditor, this.getConfiguredDocumentPartitioning(iSourceViewer))};
        return iHyperlinkDetectorArray;
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer iSourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                return new DefaultInformationControl(shell, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true));
            }
        };
    }

    public IInformationPresenter getInformationPresenter(ISourceViewer iSourceViewer) {
        String string = this.getConfiguredDocumentPartitioning(iSourceViewer);
        InformationPresenter informationPresenter = new InformationPresenter((IInformationControlCreator)new InformationControlCreator());
        informationPresenter.setDocumentPartitioning(string);
        JSInformationProvider jSInformationProvider = new JSInformationProvider((ITextEditor)this.getEditor(), string);
        String[] stringArray = this.getConfiguredContentTypes(iSourceViewer);
        for (int i = 0; i < stringArray.length; ++i) {
            informationPresenter.setInformationProvider((IInformationProvider)jSInformationProvider, stringArray[i]);
        }
        informationPresenter.setSizeConstraints(60, 10, true, true);
        return informationPresenter;
    }

    public ITextHover getTextHover(ISourceViewer iSourceViewer, String string) {
        return this.getTextHover(iSourceViewer, string, 255);
    }

    public ITextHover getTextHover(ISourceViewer iSourceViewer, String string, int n) {
        JSEditor jSEditor = this.getEditor();
        if (jSEditor != null) {
            return new JSTextHover(jSEditor, this.getConfiguredDocumentPartitioning(iSourceViewer));
        }
        return null;
    }

    public boolean affectsTextPresentation(PropertyChangeEvent propertyChangeEvent) {
        return this.fCodeScanner.affectsTextPresentation(propertyChangeEvent) || this.fStringScanner.affectsTextPresentation(propertyChangeEvent) || this.fRegExpScanner.affectsTextPresentation(propertyChangeEvent) || this.fJSDocScanner.affectsTextPresentation(propertyChangeEvent) || this.fMultilineCommentScanner.affectsTextPresentation(propertyChangeEvent) || this.fSinglelineCommentScanner.affectsTextPresentation(propertyChangeEvent);
    }

    public void changeConfiguration(PropertyChangeEvent propertyChangeEvent) {
        if (this.fContentAssistant != null) {
            String string = propertyChangeEvent.getProperty();
            if ("autoPropose".equals(string)) {
                this.fContentAssistant.enableAutoActivation(this.fPreferenceStore.getBoolean("autoPropose"));
                return;
            }
            if ("autoDelay".equals(string)) {
                this.fContentAssistant.setAutoActivationDelay(this.fPreferenceStore.getInt("autoDelay"));
                return;
            }
            if ("autoProposeChar".equals(string)) {
                String string2 = this.fPreferenceStore.getString("autoProposeChar");
                JSContentAssistProcessor jSContentAssistProcessor = (JSContentAssistProcessor)this.fContentAssistant.getContentAssistProcessor("__dftl_partition_content_type");
                if (jSContentAssistProcessor != null) {
                    if (string2 != null && string2.length() > 0) {
                        jSContentAssistProcessor.setActivationCharacters(string2.toCharArray());
                    } else {
                        jSContentAssistProcessor.setActivationCharacters(null);
                    }
                }
                return;
            }
        }
        this.fCodeScanner.changeConfiguration(propertyChangeEvent);
        this.fStringScanner.changeConfiguration(propertyChangeEvent);
        this.fRegExpScanner.changeConfiguration(propertyChangeEvent);
        this.fJSDocScanner.changeConfiguration(propertyChangeEvent);
        this.fMultilineCommentScanner.changeConfiguration(propertyChangeEvent);
        this.fSinglelineCommentScanner.changeConfiguration(propertyChangeEvent);
    }

    private void initializeScanners() {
        this.fCodeScanner = new JSCodeScanner(this.getColorManager(), this.fPreferenceStore);
        this.fJSDocScanner = new JSDocScanner(this.getColorManager(), this.fPreferenceStore);
        this.fStringScanner = new SingleTokenScanner(this.getColorManager(), this.fPreferenceStore, "js_string");
        this.fRegExpScanner = new SingleTokenScanner(this.getColorManager(), this.fPreferenceStore, "js_regexp");
        this.fMultilineCommentScanner = new JSCommentScanner(this.getColorManager(), this.fPreferenceStore, "js_ml_comment");
        this.fSinglelineCommentScanner = new JSCommentScanner(this.getColorManager(), this.fPreferenceStore, "js_sl_comment");
    }

    protected JSEditor getEditor() {
        return this.fEditor;
    }

    protected IColorManager getColorManager() {
        return this.fColorManager;
    }

    protected RuleBasedScanner getCodeScanner() {
        return this.fCodeScanner;
    }

    protected RuleBasedScanner getStringScanner() {
        return this.fStringScanner;
    }

    protected RuleBasedScanner getJSDocScanner() {
        return this.fJSDocScanner;
    }

    protected RuleBasedScanner getRegExpScanner() {
        return this.fRegExpScanner;
    }

    protected RuleBasedScanner getMultilineCommentScanner() {
        return this.fMultilineCommentScanner;
    }

    protected RuleBasedScanner getSinglelineCommentScanner() {
        return this.fSinglelineCommentScanner;
    }
}

